/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.DataType;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldHeader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldHeader.class);
    public static int indentationNumerOfSpace = 4;
    private final String fieldName;
    private final DataType dataType;
    private final int[] dimensions;
    private final long positionBuffer;
    private final long expectedNumberOfBytes;
    private Optional<FieldHeader> parent;
    private final List<FieldHeader> children = new ArrayList<FieldHeader>();

    public FieldHeader(FieldHeader parent, String fieldName, DataType dataType, int[] dims, long positionBuffer, long expectedNumberOfBytes) {
        this.parent = parent == null ? Optional.empty() : Optional.of(parent);
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.dimensions = Arrays.copyOf(dims, dims.length);
        this.positionBuffer = positionBuffer;
        this.expectedNumberOfBytes = expectedNumberOfBytes;
    }

    public FieldHeader(String fieldName, DataType dataType, int[] dims, long positionBuffer, long expectedNumberOfBytes) {
        this(null, fieldName, dataType, dims, positionBuffer, expectedNumberOfBytes);
    }

    public List<FieldHeader> getChildren() {
        return this.children;
    }

    public long getDataBufferPosition() {
        return this.positionBuffer;
    }

    public int getDataDimension() {
        return this.dimensions.length;
    }

    public int[] getDataDimensions() {
        return this.dimensions;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public long getExpectedNumberOfDataBytes() {
        return this.expectedNumberOfBytes;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Optional<FieldHeader> getParent() {
        return this.parent;
    }

    public void printFieldStructure() {
        if (this.parent.isPresent()) {
            LOGGER.atInfo().addArgument((Object)this.parent.get()).log("FielHeader structure (parent: {}):");
            FieldHeader.printFieldStructure(this, 0);
        } else {
            LOGGER.atInfo().log("FielHeader structure (no parent):");
        }
        FieldHeader.printFieldStructure(this, 0);
    }

    public String toString() {
        if (this.dimensions.length == 1 && this.dimensions[0] == 1) {
            return String.format("[fieldName=%s, fieldType=%s]", this.fieldName, this.dataType.getAsString());
        }
        StringBuilder builder = new StringBuilder(27);
        builder.append("[fieldName=").append(this.fieldName).append(", fieldType=").append(this.dataType.getAsString()).append('[');
        for (int i = 0; i < this.dimensions.length; ++i) {
            builder.append(this.dimensions[i]);
            if (i >= this.dimensions.length - 1) continue;
            builder.append(',');
        }
        builder.append("]]");
        return builder.toString();
    }

    void setParent(FieldHeader parent) {
        this.parent = Optional.of(parent);
    }

    public static Optional<FieldHeader> findHeaderFor(List<FieldHeader> fieldHeaderList, String fieldName) {
        return fieldHeaderList.stream().filter(p -> p.getFieldName().equals(fieldName)).findFirst();
    }

    protected static void printFieldStructure(FieldHeader field, int recursionLevel) {
        String mspace = FieldHeader.spaces(recursionLevel * indentationNumerOfSpace);
        LOGGER.atInfo().addArgument((Object)mspace).addArgument((Object)field.toString()).log("{}{}");
        field.getChildren().stream().forEach(f -> FieldHeader.printFieldStructure(f, recursionLevel + 1));
    }

    private static String spaces(int spaces) {
        return CharBuffer.allocate(spaces).toString().replace('\u0000', ' ');
    }
}

