/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.spi.AbstractSerialiser;
import de.gsi.dataset.serializer.spi.ClassFieldDescription;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldSerialiser.class);
    private final Class<?> classPrototype;
    private final List<Class<?>> classGenericArguments;
    private final String name;
    private final String canonicalName;
    private final String simpleName;
    private final int cachedHashCode;
    protected FieldSerialiserFunction readerFunction;
    protected FieldSerialiserFunction writerFunction;

    public FieldSerialiser(FieldSerialiserFunction reader, FieldSerialiserFunction writer, Class<?> classPrototype, Class<?> ... classGenericArguments) {
        if (reader == null || writer == null) {
            LOGGER.atDebug().addArgument((Object)reader).addArgument((Object)writer).log("caution: reader {} or writer {} is null");
        }
        if (classPrototype == null) {
            throw new IllegalArgumentException("classPrototype must not be null");
        }
        this.readerFunction = reader;
        this.writerFunction = writer;
        this.classPrototype = classPrototype;
        this.classGenericArguments = Arrays.asList(classGenericArguments);
        this.cachedHashCode = AbstractSerialiser.computeHashCode(classPrototype, this.classGenericArguments);
        String genericFieldString = this.classGenericArguments.isEmpty() ? "" : this.classGenericArguments.stream().map(Class::getName).collect(Collectors.joining(", ", "<", ">"));
        this.canonicalName = classPrototype.getCanonicalName() + genericFieldString;
        this.simpleName = classPrototype.getSimpleName() + AbstractSerialiser.getGenericFieldSimpleTypeString(this.classGenericArguments);
        this.name = "Serialiser for " + this.canonicalName;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public Class<?> getClassPrototype() {
        return this.classPrototype;
    }

    public List<Class<?>> getGenericsPrototypes() {
        return this.classGenericArguments;
    }

    public FieldSerialiserFunction getReaderFunction() {
        return this.readerFunction;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public FieldSerialiserFunction getWriterFunction() {
        return this.writerFunction;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return this.name;
    }

    public static interface FieldSerialiserFunction {
        public void exec(Object var1, ClassFieldDescription var2) throws IllegalAccessException;
    }
}

