/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.serializer.DataType;
import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.FieldHeader;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetSerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetSerialiser.class);
    private static final String DATA_SET_NAME = "dataSetName";
    private static final String DIMENSIONS = "nDims";
    private static final String ARRAY_PREFIX = "array";
    private static final String EN_PREFIX = "en";
    private static final String EP_PREFIX = "ep";
    private static final String AXIS = "axis";
    private static final String NAME = "name";
    private static final String UNIT = "unit";
    private static final String MIN = "Min";
    private static final String MAX = "Max";
    private static final String META_INFO = "metaInfo";
    private static final String ERROR_LIST = "errorList";
    private static final String WARNING_LIST = "warningList";
    private static final String INFO_LIST = "infoList";
    private static final String DATA_STYLES = "dataStyles";
    private static final String DATA_LABELS = "dataLabels";
    private static boolean transmitDataLabels = true;
    private static boolean transmitMetaData = true;

    private DataSetSerialiser() {
    }

    protected static Optional<FieldHeader> checkFieldCompatibility(IoBuffer buffer, List<FieldHeader> fieldHeaderList, String fieldName, DataType ... requireDataTypes) {
        Optional<FieldHeader> fieldHeader = FieldHeader.findHeaderFor(fieldHeaderList, fieldName);
        if (!fieldHeader.isPresent()) {
            return Optional.empty();
        }
        if (fieldHeader.get().getFieldName().equals(fieldName)) {
            boolean foundMatchingDataType = false;
            for (DataType dataType : requireDataTypes) {
                if (!fieldHeader.get().getDataType().equals((Object)dataType)) continue;
                foundMatchingDataType = true;
                break;
            }
            if (!foundMatchingDataType) {
                throw new InputMismatchException(fieldName + " is type " + fieldHeader.get().getDataType() + " vs. required type " + Arrays.asList(requireDataTypes).toString());
            }
            long dataPosition = fieldHeader.get().getDataBufferPosition();
            buffer.position(dataPosition);
            return fieldHeader;
        }
        return Optional.empty();
    }

    public static boolean isDataLablesSerialised() {
        return transmitDataLabels;
    }

    public static boolean isMetaDataSerialised() {
        return transmitMetaData;
    }

    protected static void parseDataLabels(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        ConcurrentHashMap<Integer, String> map;
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DATA_LABELS, DataType.MAP).isPresent()) {
            map = new ConcurrentHashMap();
            map = BinarySerialiser.getMap(readBuffer, map);
            builder.setDataLabelMap(map);
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DATA_STYLES, DataType.MAP).isPresent()) {
            map = new ConcurrentHashMap();
            map = BinarySerialiser.getMap(readBuffer, map);
            builder.setDataStyleMap(map);
        }
    }

    protected static void parseHeaders(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DATA_SET_NAME, DataType.STRING).isPresent()) {
            builder.setName(BinarySerialiser.getString(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DIMENSIONS, DataType.INT).isPresent()) {
            builder.setDimension(BinarySerialiser.getInteger(readBuffer));
        }
        for (FieldHeader fieldHeader : fieldHeaderList) {
            DataSetSerialiser.parseHeader(readBuffer, builder, fieldHeader);
        }
    }

    private static void parseHeader(IoBuffer readBuffer, DataSetBuilder builder, FieldHeader fieldHeader) {
        String fieldName = fieldHeader.getFieldName();
        if (fieldName == null || !fieldName.startsWith(AXIS)) {
            return;
        }
        String[] parsed = fieldName.split("\\.");
        if (parsed.length <= 1) {
            return;
        }
        int dimension = DataSetSerialiser.getDimIndex(parsed[0], AXIS);
        if (dimension < 0) {
            return;
        }
        readBuffer.position(fieldHeader.getDataBufferPosition());
        if (parsed[1].equals(MIN)) {
            builder.setAxisMin(dimension, BinarySerialiser.getDouble(readBuffer));
        } else if (parsed[1].equals(MAX)) {
            builder.setAxisMax(dimension, BinarySerialiser.getDouble(readBuffer));
        } else if (parsed[1].equals(NAME)) {
            builder.setAxisName(dimension, BinarySerialiser.getString(readBuffer));
        } else if (parsed[1].equals(UNIT)) {
            builder.setAxisUnit(dimension, BinarySerialiser.getString(readBuffer));
        }
    }

    protected static void parseMetaData(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, INFO_LIST, DataType.STRING_ARRAY).isPresent()) {
            builder.setMetaInfoList(BinarySerialiser.getStringArray(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, WARNING_LIST, DataType.STRING_ARRAY).isPresent()) {
            builder.setMetaWarningList(BinarySerialiser.getStringArray(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, ERROR_LIST, DataType.STRING_ARRAY).isPresent()) {
            builder.setMetaErrorList(BinarySerialiser.getStringArray(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, META_INFO, DataType.MAP).isPresent()) {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap();
            map = BinarySerialiser.getMap(readBuffer, map);
            builder.setMetaInfoMap(map);
        }
    }

    protected static void parseNumericData(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        for (FieldHeader fieldHeader : fieldHeaderList) {
            String fieldName = fieldHeader.getFieldName();
            if (fieldName == null || fieldHeader.getDataType() != DataType.DOUBLE_ARRAY && fieldHeader.getDataType() != DataType.FLOAT_ARRAY) continue;
            if (fieldName.startsWith(ARRAY_PREFIX)) {
                DataSetSerialiser.readValues(readBuffer, builder, fieldHeader, fieldName);
                continue;
            }
            if (fieldName.startsWith(EP_PREFIX)) {
                DataSetSerialiser.readPosError(readBuffer, builder, fieldHeader, fieldName);
                continue;
            }
            if (!fieldName.startsWith(EN_PREFIX)) continue;
            DataSetSerialiser.readNegError(readBuffer, builder, fieldHeader, fieldName);
        }
    }

    private static void readValues(IoBuffer readBuffer, DataSetBuilder builder, FieldHeader fieldHeader, String fieldName) {
        int dimIndex = DataSetSerialiser.getDimIndex(fieldName, ARRAY_PREFIX);
        if (dimIndex >= 0) {
            readBuffer.position(fieldHeader.getDataBufferPosition());
            builder.setValues(dimIndex, BinarySerialiser.getDoubleArray(readBuffer, fieldHeader.getDataType()));
        }
    }

    private static void readNegError(IoBuffer readBuffer, DataSetBuilder builder, FieldHeader fieldHeader, String fieldName) {
        int dimIndex = DataSetSerialiser.getDimIndex(fieldName, EP_PREFIX);
        if (dimIndex >= 0) {
            readBuffer.position(fieldHeader.getDataBufferPosition());
            builder.setNegError(dimIndex, BinarySerialiser.getDoubleArray(readBuffer, fieldHeader.getDataType()));
        }
    }

    private static void readPosError(IoBuffer readBuffer, DataSetBuilder builder, FieldHeader fieldHeader, String fieldName) {
        int dimIndex = DataSetSerialiser.getDimIndex(fieldName, EN_PREFIX);
        if (dimIndex >= 0) {
            readBuffer.position(fieldHeader.getDataBufferPosition());
            builder.setPosError(dimIndex, BinarySerialiser.getDoubleArray(readBuffer, fieldHeader.getDataType()));
        }
    }

    private static int getDimIndex(String fieldName, String prefix) {
        try {
            return Integer.parseInt(fieldName.substring(prefix.length()));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            LOGGER.atWarn().addArgument((Object)fieldName).log("Invalid field name: {}");
            return -1;
        }
    }

    public static DataSet readDataSetFromByteArray(IoBuffer readBuffer) {
        DataSetBuilder builder = new DataSetBuilder();
        long initialPosition = readBuffer.position();
        BinarySerialiser.HeaderInfo bufferHeader = BinarySerialiser.checkHeaderInfo(readBuffer);
        LOGGER.atTrace().addArgument((Object)bufferHeader).log("read header = {}");
        readBuffer.position(initialPosition);
        FieldHeader fieldRoot = BinarySerialiser.parseIoStream(readBuffer);
        fieldRoot = fieldRoot.getChildren().get(0);
        DataSetSerialiser.parseHeaders(readBuffer, builder, fieldRoot.getChildren());
        if (DataSetSerialiser.isMetaDataSerialised()) {
            DataSetSerialiser.parseMetaData(readBuffer, builder, fieldRoot.getChildren());
        }
        if (DataSetSerialiser.isDataLablesSerialised()) {
            DataSetSerialiser.parseDataLabels(readBuffer, builder, fieldRoot.getChildren());
        }
        DataSetSerialiser.parseNumericData(readBuffer, builder, fieldRoot.getChildren());
        return builder.build();
    }

    public static void setDataLablesSerialised(boolean state) {
        transmitDataLabels = state;
    }

    public static void setMetaDataSerialised(boolean state) {
        transmitMetaData = state;
    }

    private static float[] toFloats(double[] input) {
        float[] floatArray = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floatArray[i] = (float)input[i];
        }
        return floatArray;
    }

    protected static void writeDataLabelsToStream(IoBuffer buffer, DataSet dataSet) {
        int dataCount = dataSet.getDataCount(0);
        ConcurrentHashMap<Integer, String> labelMap = new ConcurrentHashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String label = dataSet.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            labelMap.put(index, label);
        }
        if (!labelMap.isEmpty()) {
            BinarySerialiser.put(buffer, DATA_LABELS, labelMap);
        }
        ConcurrentHashMap<Integer, String> styleMap = new ConcurrentHashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String style = dataSet.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            styleMap.put(index, style);
        }
        if (!styleMap.isEmpty()) {
            BinarySerialiser.put(buffer, DATA_STYLES, styleMap);
        }
    }

    public static void writeDataSetToByteArray(DataSet dataSet, IoBuffer buffer, boolean asFloat) {
        AssertUtils.notNull("dataSet", dataSet);
        AssertUtils.notNull("buffer", buffer);
        dataSet.lock();
        BinarySerialiser.putHeaderInfo(buffer);
        DataSetSerialiser.writeHeaderDataToStream(buffer, dataSet);
        if (DataSetSerialiser.isMetaDataSerialised()) {
            DataSetSerialiser.writeMetaDataToStream(buffer, dataSet);
        }
        if (DataSetSerialiser.isDataLablesSerialised()) {
            DataSetSerialiser.writeDataLabelsToStream(buffer, dataSet);
        }
        if (asFloat) {
            DataSetSerialiser.writeNumericBinaryDataToBufferFloat(buffer, dataSet);
        } else {
            DataSetSerialiser.writeNumericBinaryDataToBufferDouble(buffer, dataSet);
        }
        BinarySerialiser.putEndMarker(buffer, "OBJ_ROOT_END");
    }

    protected static void writeHeaderDataToStream(IoBuffer buffer, DataSet dataSet) {
        BinarySerialiser.put(buffer, DATA_SET_NAME, dataSet.getName());
        BinarySerialiser.put(buffer, DIMENSIONS, dataSet.getDimension());
        List<AxisDescription> axisDescriptions = dataSet.getAxisDescriptions();
        StringBuilder builder = new StringBuilder(60);
        for (int i = 0; i < axisDescriptions.size(); ++i) {
            builder.setLength(0);
            String prefix = builder.append(AXIS).append(Integer.toString(i)).append('.').toString();
            builder.setLength(0);
            String name = builder.append(prefix).append(NAME).toString();
            builder.setLength(0);
            String unit = builder.append(prefix).append(UNIT).toString();
            builder.setLength(0);
            String minName = builder.append(prefix).append(MIN).toString();
            builder.setLength(0);
            String maxName = builder.append(prefix).append(MAX).toString();
            BinarySerialiser.put(buffer, name, dataSet.getAxisDescription(i).getName());
            BinarySerialiser.put(buffer, unit, dataSet.getAxisDescription(i).getUnit());
            BinarySerialiser.put(buffer, minName, dataSet.getAxisDescription(i).getMin());
            BinarySerialiser.put(buffer, maxName, dataSet.getAxisDescription(i).getMax());
        }
    }

    protected static void writeMetaDataToStream(IoBuffer buffer, DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            return;
        }
        DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
        BinarySerialiser.put(buffer, INFO_LIST, metaDataSet.getInfoList().toArray(new String[0]));
        BinarySerialiser.put(buffer, WARNING_LIST, metaDataSet.getWarningList().toArray(new String[0]));
        BinarySerialiser.put(buffer, ERROR_LIST, metaDataSet.getErrorList().toArray(new String[0]));
        BinarySerialiser.put(buffer, META_INFO, metaDataSet.getMetaInfo());
    }

    protected static void writeNumericBinaryDataToBufferFloat(IoBuffer buffer, DataSet dataSet) {
        int nDim = dataSet.getDimension();
        for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount(dimIndex);
            BinarySerialiser.put(buffer, ARRAY_PREFIX + dimIndex, DataSetSerialiser.toFloats(dataSet.getValues(dimIndex)), new int[]{nsamples});
        }
        if (!(dataSet instanceof DataSetError)) {
            return;
        }
        DataSetError ds = (DataSetError)dataSet;
        block5: for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount(dimIndex);
            switch (ds.getErrorType(dimIndex)) {
                default: {
                    continue block5;
                }
                case SYMMETRIC: {
                    BinarySerialiser.put(buffer, EP_PREFIX + dimIndex, DataSetSerialiser.toFloats(ds.getErrorsPositive(dimIndex)), new int[]{nsamples});
                    continue block5;
                }
                case ASYMMETRIC: {
                    BinarySerialiser.put(buffer, EN_PREFIX + dimIndex, DataSetSerialiser.toFloats(ds.getErrorsNegative(dimIndex)), new int[]{nsamples});
                    BinarySerialiser.put(buffer, EP_PREFIX + dimIndex, DataSetSerialiser.toFloats(ds.getErrorsPositive(dimIndex)), new int[]{nsamples});
                }
            }
        }
    }

    protected static void writeNumericBinaryDataToBufferDouble(IoBuffer buffer, DataSet dataSet) {
        int nDim = dataSet.getDimension();
        for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount(dimIndex);
            BinarySerialiser.put(buffer, ARRAY_PREFIX + dimIndex, dataSet.getValues(dimIndex), new int[]{nsamples});
        }
        if (!(dataSet instanceof DataSetError)) {
            return;
        }
        DataSetError ds = (DataSetError)dataSet;
        block5: for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount(dimIndex);
            switch (ds.getErrorType(dimIndex)) {
                case SYMMETRIC: {
                    BinarySerialiser.put(buffer, EP_PREFIX + dimIndex, ds.getErrorsPositive(dimIndex), new int[]{nsamples});
                    continue block5;
                }
                case ASYMMETRIC: {
                    BinarySerialiser.put(buffer, EN_PREFIX + dimIndex, ds.getErrorsNegative(dimIndex), new int[]{nsamples});
                    BinarySerialiser.put(buffer, EP_PREFIX + dimIndex, ds.getErrorsPositive(dimIndex), new int[]{nsamples});
                    continue block5;
                }
            }
        }
    }
}

