/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.serializer.DataType;
import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.AbstractSerialiser;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.iobuffer.DataSetSerialiser;
import de.gsi.dataset.serializer.spi.iobuffer.FieldListAxisDescription;
import de.gsi.dataset.serializer.spi.iobuffer.IoBufferFieldSerialiser;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public final class FieldDataSetHelper {
    private FieldDataSetHelper() {
    }

    public static void register(AbstractSerialiser serialiser, IoBuffer ioBuffer) {
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, DoubleArrayList.wrap((double[])BinarySerialiser.getDoubleArray(ioBuffer))), (obj, field) -> {
            DoubleArrayList retVal = (DoubleArrayList)field.getField().get(obj);
            BinarySerialiser.put(ioBuffer, field.getFieldName(), retVal.elements(), new int[]{retVal.size()});
        }, DoubleArrayList.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> {
            String dataSetType = ioBuffer.getString();
            if (!DataSet.class.getName().equals(dataSetType)) {
                throw new IllegalArgumentException("unknown DataSet type = " + dataSetType);
            }
            field.getField().set(obj, DataSetSerialiser.readDataSetFromByteArray(ioBuffer));
        }, (obj, field) -> {
            DataSet retVal = (DataSet)(field.getField() == null ? obj : field.getField().get(obj));
            long sizeMarkerStart = BinarySerialiser.putArrayHeader(ioBuffer, field.getFieldName(), DataType.OTHER, new int[]{1}, 1);
            ioBuffer.putString(DataSet.class.getName());
            DataSetSerialiser.writeDataSetToByteArray(retVal, ioBuffer, false);
            BinarySerialiser.adjustDataByteSizeBlock(ioBuffer, sizeMarkerStart);
        }, DataSet.class, new Class[0]));
        serialiser.addClassDefinition(new FieldListAxisDescription(ioBuffer));
    }
}

