/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.serializer.DataType;
import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.ClassFieldDescription;
import de.gsi.dataset.serializer.spi.iobuffer.IoBufferFieldSerialiser;
import de.gsi.dataset.spi.DefaultAxisDescription;
import java.util.Collection;
import java.util.List;

public class FieldListAxisDescription
extends IoBufferFieldSerialiser {
    public FieldListAxisDescription(IoBuffer buffer) {
        super(buffer, (Object obj, ClassFieldDescription field) -> {}, (Object obj, ClassFieldDescription field) -> {}, List.class, AxisDescription.class);
        this.readerFunction = this::execFieldReader;
        this.writerFunction = this::execFieldWriter;
    }

    protected final void execFieldReader(Object obj, ClassFieldDescription field) throws IllegalAccessException {
        Collection setVal = (Collection)field.getField().get(obj);
        setVal.clear();
        int nElements = this.ioBuffer.getInt();
        for (int i = 0; i < nElements; ++i) {
            BinarySerialiser.getFieldHeader(this.ioBuffer);
            byte startMarker = this.ioBuffer.getByte();
            if (startMarker != DataType.START_MARKER.getAsByte()) {
                throw new IllegalStateException("corrupt start marker, value is " + startMarker + " vs. should " + DataType.START_MARKER.getAsByte());
            }
            BinarySerialiser.getFieldHeader(this.ioBuffer);
            String axisName = this.ioBuffer.getString();
            BinarySerialiser.getFieldHeader(this.ioBuffer);
            String axisUnit = this.ioBuffer.getString();
            BinarySerialiser.getFieldHeader(this.ioBuffer);
            double min = this.ioBuffer.getDouble();
            BinarySerialiser.getFieldHeader(this.ioBuffer);
            double max = this.ioBuffer.getDouble();
            DefaultAxisDescription ad = new DefaultAxisDescription(null, axisName, axisUnit, min, max);
            BinarySerialiser.getFieldHeader(this.ioBuffer);
            byte endMarker = this.ioBuffer.getByte();
            if (endMarker != DataType.END_MARKER.getAsByte()) {
                throw new IllegalStateException("corrupt end marker, value is " + endMarker + " vs. should " + DataType.END_MARKER.getAsByte());
            }
            setVal.add(ad);
        }
        field.getField().set(obj, setVal);
    }

    protected void execFieldWriter(Object obj, ClassFieldDescription field) throws IllegalAccessException {
        String fieldName = field.getFieldName();
        List axisDescriptions = (List)field.getField().get(obj);
        int nElements = axisDescriptions.size();
        int entrySize = 50;
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(this.ioBuffer, fieldName, DataType.LIST, new int[]{nElements}, nElements * 50 + 9);
        this.ioBuffer.putInt(nElements);
        for (AxisDescription axis : axisDescriptions) {
            BinarySerialiser.putStartMarker(this.ioBuffer, axis.getName());
            BinarySerialiser.put(this.ioBuffer, fieldName, axis.getName());
            BinarySerialiser.put(this.ioBuffer, fieldName, axis.getUnit());
            BinarySerialiser.put(this.ioBuffer, fieldName, axis.getMin());
            BinarySerialiser.put(this.ioBuffer, fieldName, axis.getMax());
            BinarySerialiser.putEndMarker(this.ioBuffer, axis.getName());
        }
        BinarySerialiser.adjustDataByteSizeBlock(this.ioBuffer, sizeMarkerStart);
    }
}

