/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class MultiDimDoubleDataSet
extends AbstractDataSet<MultiDimDoubleDataSet>
implements EditableDataSet {
    private static final long serialVersionUID = -493232313124620828L;
    protected DoubleArrayList[] values;

    public MultiDimDoubleDataSet(DataSet another) {
        this(another.getName(), another.getDimension());
        this.set(another);
    }

    public MultiDimDoubleDataSet(String name, int nDim) {
        this(name, nDim, 0);
    }

    public MultiDimDoubleDataSet(String name, boolean deepCopy, double[] ... values) {
        this(name, values.length);
        this.values = new DoubleArrayList[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (deepCopy) {
                this.values[i] = new DoubleArrayList(values[i].length);
                this.values[i].addElements(0, values[i]);
            } else {
                this.values[i] = DoubleArrayList.wrap((double[])values[i]);
            }
            this.getAxisDescription(i).add(values[i]);
        }
    }

    public MultiDimDoubleDataSet(String name, int nDims, int ... initialSizes) {
        super(name, nDims);
        AssertUtils.gtThanZero("nDims", nDims);
        AssertUtils.nonEmptyArray("initialSizes", initialSizes);
        this.values = new DoubleArrayList[nDims];
        int acumulatedSize = 1;
        for (int i = 0; i < nDims; ++i) {
            if (initialSizes.length > i) {
                this.values[i] = new DoubleArrayList(initialSizes[i]);
                this.values[i].size(initialSizes[i]);
                acumulatedSize *= initialSizes[i];
                continue;
            }
            this.values[i] = new DoubleArrayList(acumulatedSize);
            this.values[i].size(acumulatedSize);
        }
    }

    public MultiDimDoubleDataSet add(double ... newValues) {
        return this.add(this.getDataCount(), newValues, null);
    }

    public MultiDimDoubleDataSet add(double[] newValues, String label) {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].add(newValues[i]);
                this.getAxisDescription(i).add(newValues[i]);
            }
            if (label != null) {
                this.addDataLabel(this.values[0].size() - 1, label);
            }
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "add"));
    }

    public MultiDimDoubleDataSet add(double[][] valuesNew) {
        int nPoints = valuesNew[0].length;
        for (int i = 0; i < this.values.length; ++i) {
            AssertUtils.notNull("coordinates dim " + i, valuesNew[i]);
            AssertUtils.checkArrayDimension("New Data for dim " + i, valuesNew[i], nPoints);
        }
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].addElements(this.values[i].size(), valuesNew[i], 0, nPoints);
                this.getAxisDescription(i).add(valuesNew[i]);
            }
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public MultiDimDoubleDataSet add(int index, double ... newValues) {
        return this.add(index, newValues, null);
    }

    public MultiDimDoubleDataSet add(int index, double[] newValues, String label) {
        if (newValues.length != this.getDimension()) {
            throw new IllegalArgumentException("Dimensionality of new point is different from dataset");
        }
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount()));
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].add(indexAt, newValues[i]);
                this.getAxisDescription(i).add(newValues[i]);
            }
            this.getDataLabelMap().addValueAndShiftKeys(indexAt, this.values[0].size(), label);
            this.getDataStyleMap().shiftKeys(indexAt, this.values[0].size());
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public MultiDimDoubleDataSet add(int index, double[][] newValues) {
        int nPoints = Integer.MAX_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            AssertUtils.notNull("coordinates in dim " + i, newValues[i]);
            nPoints = Math.min(nPoints, newValues[i].length);
        }
        int nPointsFinal = nPoints;
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].addElements(indexAt, newValues[i], 0, nPointsFinal);
                this.getAxisDescription(0).add(newValues[i], nPointsFinal);
            }
            this.getDataLabelMap().shiftKeys(indexAt, this.values[0].size());
            this.getDataStyleMap().shiftKeys(indexAt, this.values[0].size());
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public MultiDimDoubleDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].clear();
            }
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public final double get(int dimIndex, int index) {
        return this.values[dimIndex].elements()[index];
    }

    public int getCapacity() {
        int cap = Integer.MAX_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            cap = Math.min(cap, this.values[i].elements().length);
        }
        return cap;
    }

    @Override
    public final double[] getValues(int dimIndex) {
        return this.values[dimIndex].elements();
    }

    public MultiDimDoubleDataSet increaseCapacity(int amount) {
        this.lock().writeLockGuard(() -> {
            int size = this.getDataCount();
            this.resize(this.getCapacity() + amount);
            this.resize(size);
        });
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public MultiDimDoubleDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].removeElements(fromIndex, toIndex);
            }
            this.getDataLabelMap().remove(fromIndex, toIndex);
            this.getDataStyleMap().remove(fromIndex, toIndex);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public MultiDimDoubleDataSet resize(int size) {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].size(size);
            }
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public MultiDimDoubleDataSet set(DataSet other) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            int index;
            double[][] data = new double[other.getDimension()][];
            for (int i = 0; i < other.getDimension(); ++i) {
                data[i] = other.getValues(i);
            }
            this.set(data, false);
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null) continue;
                this.addDataLabel(index, label);
            }
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(other.getStyle());
        }));
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public MultiDimDoubleDataSet set(double[][] values) {
        return this.set(values, true);
    }

    public MultiDimDoubleDataSet set(double[][] values, boolean copy) {
        int dataMaxIndex = Integer.MAX_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            AssertUtils.notNull("X coordinates", values[i]);
            dataMaxIndex = Math.min(dataMaxIndex, values[i].length);
        }
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (copy) {
                this.resize(0);
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i].addElements(0, values[i]);
                }
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = DoubleArrayList.wrap((double[])values[i]);
                }
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public MultiDimDoubleDataSet setValues(int dimIndex, double[] values, boolean copy) {
        AssertUtils.notNull("X coordinates", values);
        AssertUtils.gtOrEqual("Available dimensions", dimIndex, this.values.length);
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (copy) {
                this.values[dimIndex].clear();
                this.values[dimIndex].addElements(0, values);
            } else {
                this.values[dimIndex] = DoubleArrayList.wrap((double[])values);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public MultiDimDoubleDataSet set(int index, double ... newValue) {
        this.lock().writeLockGuard(() -> {
            int dataCount = Math.max(index + 1, this.getDataCount());
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].size(dataCount);
                this.values[i].elements()[index] = newValue[i];
            }
            this.getDataLabelMap().remove(index);
            this.getDataStyleMap().remove(index);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - single"));
    }

    public MultiDimDoubleDataSet set(int index, double[][] values) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(index + values[0].length, this.values[0].size()));
            for (int i = 0; i < this.values.length; ++i) {
                System.arraycopy(values[i], 0, this.values[i].elements(), index, values[i].length);
            }
            this.getDataLabelMap().remove(index, index + values[0].length);
            this.getDataStyleMap().remove(index, index + values[0].length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - via arrays"));
    }

    public MultiDimDoubleDataSet trim() {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].trim(i);
            }
        });
        return (MultiDimDoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    @Override
    public int getDataCount(int dimIndex) {
        if (this.values.length <= dimIndex) {
            return 0;
        }
        return this.values[dimIndex].size();
    }

    @Override
    public double getValue(int dimIndex, double x) {
        int index1 = this.getIndex(0, x);
        double x1 = this.get(0, index1);
        double y1 = this.get(dimIndex, index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.get(dimIndex, index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.get(0, index2);
        if (x1 == x2) {
            return y1;
        }
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }
}

