/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.DataSetUtilsHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtils
extends DataSetUtilsHelper {
    private static final String CACHED_META_DATA_STRING_BUILDER = "metaDataCacheBuilder";
    private static final String CACHED_STRING_BUILDER = "numericDataCacheBuilder";
    private static final String CACHED_WRITE_BYTE_BUFFER = "writeByteBuffer";
    private static final int SWITCH_TO_BINARY_KEY = 254;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetUtils.class);
    private static final String DEFAULT_TIME_FORMAT = "yyyyMMdd_HHmmss";
    protected static boolean useFloat32BinaryStandard = true;
    protected static boolean exportMetaDataByDefault = true;
    private static final List<Character> AXIS_ID = Arrays.asList(Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('a'), Character.valueOf('b'));

    private DataSetUtils() {
    }

    public static AbstractDataSet<?> copyDataSet(DataSet2D ds) {
        DefaultDataSet d = new DefaultDataSet(ds.getName());
        d.set(ds);
        return d;
    }

    protected static double[] cropToLength(double[] in, int length) {
        if (in.length == length) {
            return in;
        }
        return Arrays.copyOf(in, length);
    }

    public static double error(DataSet dataSet, ErrType eType, double x) {
        return DataSetUtils.error(dataSet, eType, -1, x, true);
    }

    public static double error(DataSet dataSet, ErrType eType, int index) {
        return DataSetUtils.error(dataSet, eType, index, 0.0, false);
    }

    protected static double error(DataSet dataSet, ErrType eType, int index, double x, boolean interpolate) {
        if (!(dataSet instanceof DataSetError)) {
            return 0.0;
        }
        DataSetError ds = (DataSetError)dataSet;
        if (interpolate) {
            switch (eType) {
                case EXN: {
                    return ds.getErrorNegative(0, x);
                }
                case EXP: {
                    return ds.getErrorPositive(0, x);
                }
                case EYN: {
                    return ds.getErrorNegative(1, x);
                }
                case EYP: {
                    return ds.getErrorPositive(1, x);
                }
            }
        } else {
            switch (eType) {
                case EXN: {
                    return ds.getErrorNegative(0, index);
                }
                case EXP: {
                    return ds.getErrorPositive(0, index);
                }
                case EYN: {
                    return ds.getErrorNegative(1, index);
                }
                case EYP: {
                    return ds.getErrorPositive(1, index);
                }
            }
        }
        return 0.0;
    }

    public static double[] errors(DataSet dataSet, ErrType eType) {
        int nDim = dataSet.getDataCount(0);
        if (!(dataSet instanceof DataSetError)) {
            return new double[nDim];
        }
        DataSetError ds = (DataSetError)dataSet;
        switch (eType) {
            case EXN: {
                return DataSetUtils.cropToLength(ds.getErrorsNegative(0), nDim);
            }
            case EXP: {
                return DataSetUtils.cropToLength(ds.getErrorsPositive(0), nDim);
            }
            case EYN: {
                return DataSetUtils.cropToLength(ds.getErrorsNegative(1), nDim);
            }
        }
        return DataSetUtils.cropToLength(ds.getErrorsPositive(1), nDim);
    }

    protected static Compression evaluateAutoCompression(String fileName) {
        if (fileName.toLowerCase(Locale.UK).endsWith(".gz")) {
            return Compression.GZIP;
        }
        if (fileName.toLowerCase(Locale.UK).endsWith(".zip")) {
            return Compression.ZIP;
        }
        return Compression.NONE;
    }

    public static String getFileName(DataSet dataSet, String fileName) {
        Pattern placeholder = Pattern.compile("\\{([^\\{\\}]*)\\}");
        Matcher matcher = placeholder.matcher(fileName);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String value;
            boolean valueValid = true;
            String[] substitutionparams = matcher.group(1).split(";");
            if (substitutionparams.length == 0) {
                valueValid = false;
            }
            switch (substitutionparams[0]) {
                case "systemTime": {
                    value = Long.toString(System.currentTimeMillis());
                    break;
                }
                case "dataSetName": {
                    value = dataSet == null ? "noDataset" : dataSet.getName();
                    break;
                }
                case "xMin": {
                    value = dataSet == null ? "noDataset" : Double.toString(dataSet.getAxisDescription(0).getMin());
                    break;
                }
                case "xMax": {
                    value = dataSet == null ? "noDataset" : Double.toString(dataSet.getAxisDescription(0).getMax());
                    break;
                }
                case "yMin": {
                    value = dataSet == null ? "noDataset" : Double.toString(dataSet.getAxisDescription(1).getMin());
                    break;
                }
                case "yMax": {
                    value = dataSet == null ? "noDataset" : Double.toString(dataSet.getAxisDescription(1).getMax());
                    break;
                }
                default: {
                    if (!(dataSet instanceof DataSetMetaData)) {
                        value = "metaDataMissing";
                        valueValid = false;
                        break;
                    }
                    DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
                    value = metaDataSet.getMetaInfo().get(substitutionparams[0]);
                    if (value != null) break;
                    value = "metaDataFieldMissing";
                    valueValid = false;
                }
            }
            if (valueValid && substitutionparams.length != 1 && !substitutionparams[1].equals("string")) {
                switch (substitutionparams[1]) {
                    case "date": {
                        String format = substitutionparams.length < 3 ? DEFAULT_TIME_FORMAT : substitutionparams[2];
                        value = DataSetUtils.getISODate(Long.valueOf(value), format);
                        break;
                    }
                    case "int": 
                    case "long": {
                        String format = substitutionparams.length < 3 ? "%d" : substitutionparams[2];
                        value = String.format(Locale.US, format, Long.valueOf(value));
                        break;
                    }
                    case "float": 
                    case "double": {
                        String format = substitutionparams.length < 3 ? "%e" : substitutionparams[2];
                        value = String.format(Locale.US, format, Double.valueOf(value));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("fileName contains placeholder with illegal type: " + substitutionparams[1]);
                    }
                }
            }
            matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String getISODate(long timeMillis, String format) {
        long time = TimeUnit.MILLISECONDS.toMillis(timeMillis);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.UK);
        df.setTimeZone(tz);
        return df.format(new Date(time));
    }

    protected static String getKey(String line, String replace) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" : ");
        if (split.length < 2) {
            return null;
        }
        return split[0].replaceAll(replace, "");
    }

    protected static String getValue(String line) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" : ");
        if (split.length < 2) {
            return null;
        }
        return split[1];
    }

    private static SplitCharByteInputStream openDatasetFileInput(File file, Compression compression) throws IOException {
        InputStream istream;
        switch (compression) {
            case ZIP: {
                ZipInputStream zipIStream = new ZipInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                if (zipIStream.getNextEntry() == null) {
                    zipIStream.close();
                    throw new ZipException("Corrupt zip archive has no entries");
                }
                istream = zipIStream;
                break;
            }
            case GZIP: {
                istream = new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                break;
            }
            case NONE: {
                istream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                break;
            }
            default: {
                throw new IOException("Unimplemented Compression");
            }
        }
        return new SplitCharByteInputStream(new PushbackInputStream(istream, 8192));
    }

    private static OutputStream openDatasetFileOutput(File file, Compression compression) throws IOException {
        switch (compression) {
            case NONE: {
                return Files.newOutputStream(file.toPath(), new OpenOption[0]);
            }
            case GZIP: {
                return new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
            case ZIP: {
                ZipOutputStream zipOStream = new ZipOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
                String filename = file.getName();
                String zipentryname = filename.toLowerCase(Locale.UK).endsWith(".zip") ? filename.substring(0, filename.length() - 4) : filename;
                zipOStream.putNextEntry(new ZipEntry(zipentryname));
                return zipOStream;
            }
        }
        throw new IllegalArgumentException("Unknown Compression format: " + compression.toString());
    }

    public static DataSet readDataSetFromByteArray(byte[] byteArray) {
        DataSet dataSet;
        block9: {
            if (byteArray == null) {
                throw new IllegalArgumentException("null byteArray");
            }
            if (byteArray.length == 0) {
                throw new IllegalArgumentException("byteArray with zero length");
            }
            dataSet = null;
            try (SplitCharByteInputStream inputFile = new SplitCharByteInputStream(new PushbackInputStream(new ByteArrayInputStream(byteArray), 8192));){
                dataSet = DataSetUtils.readDataSetFromStream(inputFile);
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block9;
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)byteArray.length).log("could not open/parse byte array size = {}");
            }
        }
        return dataSet;
    }

    public static DataSet readDataSetFromFile(String fileName) {
        return DataSetUtils.readDataSetFromFile(fileName, Compression.AUTO);
    }

    public static DataSet readDataSetFromFile(String fileName, Compression compression) {
        DataSet dataSet;
        block9: {
            if (fileName == null || fileName.isEmpty()) {
                throw new IllegalArgumentException("fileName must not be null or empty");
            }
            dataSet = null;
            try (SplitCharByteInputStream inputFile = DataSetUtils.openDatasetFileInput(new File(fileName), compression == Compression.AUTO ? DataSetUtils.evaluateAutoCompression(fileName) : compression);){
                dataSet = DataSetUtils.readDataSetFromStream(inputFile);
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block9;
                LOGGER.error("could not open/parse file: '" + fileName + "'", (Throwable)e);
            }
        }
        return dataSet;
    }

    public static DataSet readDataSetFromStream(SplitCharByteInputStream inputStream) {
        boolean binary = false;
        DataSet dataSet = null;
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));){
            String dataSetName = "unknown data set";
            int nDataCountEstimate = 0;
            ArrayList<String> info = new ArrayList<String>();
            ArrayList<String> warning = new ArrayList<String>();
            ArrayList<String> error = new ArrayList<String>();
            ConcurrentHashMap<String, String> metaInfoMap = new ConcurrentHashMap<String, String>();
            ArrayList<DefaultAxisDescription> axisDesc = new ArrayList<DefaultAxisDescription>();
            boolean is3D = false;
            String line = inputReader.readLine();
            while ((line = inputReader.readLine()) != null) {
                if (line.startsWith("$")) {
                    if (line.startsWith("$binary")) {
                        binary = true;
                    }
                    if (!line.contains("z")) break;
                    is3D = true;
                    break;
                }
                if (line.matches("^#.Min.*")) {
                    int dim = AXIS_ID.indexOf(Character.valueOf(line.charAt(1)));
                    if (dim < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(line.charAt(1)));
                    }
                    while (axisDesc.size() < dim + 1) {
                        axisDesc.add(new DefaultAxisDescription());
                    }
                    ((AxisDescription)axisDesc.get(dim)).setMin(Double.parseDouble(DataSetUtils.getValue(line)));
                    continue;
                }
                if (line.matches("^#.Max.*")) {
                    int dim = AXIS_ID.indexOf(Character.valueOf(line.charAt(1)));
                    if (dim < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(line.charAt(1)));
                    }
                    while (axisDesc.size() < dim + 1) {
                        axisDesc.add(new DefaultAxisDescription());
                    }
                    ((AxisDescription)axisDesc.get(dim)).setMax(Double.parseDouble(DataSetUtils.getValue(line)));
                    continue;
                }
                if (line.matches("^#.Name.*")) {
                    int dim = AXIS_ID.indexOf(Character.valueOf(line.charAt(1)));
                    if (dim < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(line.charAt(1)));
                    }
                    while (axisDesc.size() < dim + 1) {
                        axisDesc.add(new DefaultAxisDescription());
                    }
                    ((AxisDescription)axisDesc.get(dim)).set(DataSetUtils.getValue(line) == null ? "" : DataSetUtils.getValue(line), new String[0]);
                    continue;
                }
                if (line.matches("^#.Unit.*")) {
                    int dim = AXIS_ID.indexOf(Character.valueOf(line.charAt(1)));
                    if (dim < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(line.charAt(1)));
                    }
                    while (axisDesc.size() < dim + 1) {
                        axisDesc.add(new DefaultAxisDescription());
                    }
                    ((AxisDescription)axisDesc.get(dim)).set(((AxisDescription)axisDesc.get(dim)).getName(), DataSetUtils.getValue(line) == null ? "" : DataSetUtils.getValue(line));
                    continue;
                }
                if (line.contains("#dataSetName")) {
                    dataSetName = DataSetUtils.getValue(line);
                    continue;
                }
                if (line.contains("#nSamples")) {
                    nDataCountEstimate = Integer.parseInt(DataSetUtils.getValue(line));
                    continue;
                }
                if (line.contains("#info")) {
                    info.add(DataSetUtils.getValue(line));
                    continue;
                }
                if (line.contains("#warning")) {
                    warning.add(DataSetUtils.getValue(line));
                    continue;
                }
                if (line.contains("#error")) {
                    error.add(DataSetUtils.getValue(line));
                    continue;
                }
                if (!line.contains("#metaKey -")) continue;
                String key = DataSetUtils.getKey(line, "#metaKey -");
                String string = DataSetUtils.getValue(line);
                if (key == null || string == null) {
                    LOGGER.warn("Could not add meta information from file: {}", (Object)line);
                    continue;
                }
                metaInfoMap.put(key, string);
            }
            if ((dataSet = binary ? DataSetUtils.readNumericDataFromBinaryFile(inputReader, inputStream, dataSetName) : DataSetUtils.readNumericDataFromFile(inputReader, dataSetName, is3D, nDataCountEstimate)) == null) {
                throw new IllegalStateException("dataSet is null for branch binary = " + binary);
            }
            ((DataSetMetaData)((Object)dataSet)).getMetaInfo().putAll(metaInfoMap);
            ((DataSetMetaData)((Object)dataSet)).getInfoList().addAll(info);
            ((DataSetMetaData)((Object)dataSet)).getWarningList().addAll(warning);
            ((DataSetMetaData)((Object)dataSet)).getErrorList().addAll(error);
            dataSet.getAxisDescriptions().clear();
            for (AxisDescription axisDescription : axisDesc) {
                dataSet.getAxisDescriptions().add(new DefaultAxisDescription(dataSet, axisDescription));
            }
        }
        catch (IOException e) {
            LOGGER.error("could not open/parse inputStream", (Throwable)e);
            return dataSet;
        }
        return dataSet;
    }

    private static DataSet readNumericDataFromBinaryFile(BufferedReader inputReader, SplitCharByteInputStream inputFile, String dataSetName) throws IOException {
        DataSetBuilder builder = new DataSetBuilder();
        List toRead = inputReader.lines().collect(Collectors.toList());
        if (inputFile.reachedSplit()) {
            inputFile.switchToBinary();
            block14: for (int i = 0; i < toRead.size(); ++i) {
                int alreadyRead;
                String[] dataentry = ((String)toRead.get(i)).substring(1).split(";");
                String name = dataentry[0];
                String type = dataentry[1];
                int nSamples = Integer.parseInt(dataentry[2]);
                boolean isFloat32 = type.toLowerCase(Locale.UK).contains("float32");
                ByteBuffer byteData = isFloat32 ? ByteBuffer.allocate(nSamples * 4) : ByteBuffer.allocate(nSamples * 8);
                DoubleBuffer data64 = null;
                FloatBuffer data32 = null;
                if (isFloat32) {
                    data32 = byteData.asFloatBuffer();
                    for (alreadyRead = 0; alreadyRead < nSamples * 4; alreadyRead += inputFile.read(byteData.array(), alreadyRead, nSamples * 4 - alreadyRead)) {
                    }
                } else {
                    data64 = byteData.asDoubleBuffer();
                    while (alreadyRead < nSamples * 8) {
                        alreadyRead += inputFile.read(byteData.array(), alreadyRead, nSamples * 8 - alreadyRead);
                    }
                }
                switch (name) {
                    case "x": {
                        builder.setValuesNoCopy(0, DataSetUtils.readDoubleArrayFromBuffer(data32, data64));
                        continue block14;
                    }
                    case "y": {
                        builder.setValuesNoCopy(1, DataSetUtils.readDoubleArrayFromBuffer(data32, data64));
                        continue block14;
                    }
                    case "eyn": {
                        builder.setNegErrorNoCopy(1, DataSetUtils.readDoubleArrayFromBuffer(data32, data64));
                        continue block14;
                    }
                    case "eyp": {
                        builder.setPosErrorNoCopy(1, DataSetUtils.readDoubleArrayFromBuffer(data32, data64));
                        continue block14;
                    }
                    case "z": {
                        builder.setValuesNoCopy(2, DataSetUtils.readDoubleArrayFromBuffer(data32, data64));
                        continue block14;
                    }
                    default: {
                        if (!LOGGER.isDebugEnabled()) continue block14;
                        LOGGER.atDebug().addArgument((Object)name).addArgument((Object)type).log("Got unused variable {} of type {}");
                    }
                }
            }
            return builder.setName(dataSetName).build();
        }
        LOGGER.error("File seems to be corrupted, Split marker not found");
        return builder.setName("CorruptedDataSet").setMetaErrorList("Error reading file").build();
    }

    protected static DataSet readNumericDataFromFile(BufferedReader inputFile, String dataSetName, boolean is3D, int nSamplesGuessed) {
        DataSet result;
        block11: {
            result = null;
            try {
                if (is3D) {
                    int i = 0;
                    DoubleBuffer x = DoubleBuffer.allocate(nSamplesGuessed);
                    DoubleBuffer y = DoubleBuffer.allocate(nSamplesGuessed);
                    DoubleBuffer z = DoubleBuffer.allocate(nSamplesGuessed);
                    String line = inputFile.readLine();
                    while (line != null) {
                        String[] parse = line.split(",");
                        if (parse.length != 0) {
                            double yNew = Double.parseDouble(parse[2]);
                            if (y.position() == 0 || yNew != y.get(y.position() - 1)) {
                                y.put(yNew);
                            }
                            if (y.position() < 2) {
                                x.put(Double.parseDouble(parse[1]));
                            }
                            z.put(Double.parseDouble(parse[3]));
                            ++i;
                        }
                        line = inputFile.readLine();
                    }
                    double[] xArray = new double[x.position()];
                    x.position(0);
                    x.get(xArray);
                    double[] yArray = new double[y.position()];
                    y.position(0);
                    y.get(yArray);
                    double[][] zArray = new double[yArray.length][xArray.length];
                    z.position(0);
                    for (i = 0; i < zArray.length; ++i) {
                        z.get(zArray[i]);
                    }
                    result = new DataSetBuilder(dataSetName).setValues(0, xArray).setValues(1, yArray).setValues(2, zArray).build();
                } else {
                    result = new DoubleErrorDataSet(dataSetName);
                    String line = inputFile.readLine();
                    while (line != null) {
                        String[] parse = line.split(",");
                        if (parse.length != 0) {
                            double x = Double.parseDouble(parse[1]);
                            double y = Double.parseDouble(parse[2]);
                            double eyn = parse.length < 5 ? 0.0 : Double.parseDouble(parse[3]);
                            double eyp = parse.length < 5 ? 0.0 : Double.parseDouble(parse[4]);
                            result.add(x, y, eyn, eyp);
                        }
                        line = inputFile.readLine();
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block11;
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)(result == null ? "null" : result.getName())).log("readNumericDataFrom File could not parse numeric data for: '{}'");
            }
        }
        return result;
    }

    public static void setExportMetaDataByDefault(boolean state) {
        exportMetaDataByDefault = state;
    }

    public static void setUseFloat32BinaryStandard(boolean state) {
        useFloat32BinaryStandard = state;
    }

    public static boolean useExportMetaDataByDefault() {
        return exportMetaDataByDefault;
    }

    public static boolean useFloat32BinaryStandard() {
        return useFloat32BinaryStandard;
    }

    public static void writeDataSetToByteArray(DataSet dataSet, ByteArrayOutputStream byteOutput, boolean binary, boolean asFloat) {
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet must not be null or empty");
        }
        if (byteOutput == null) {
            throw new IllegalArgumentException("byteOutput must not be null or empty");
        }
        byteOutput.reset();
        dataSet.lock().readLockGuard(() -> {
            try {
                byteOutput.write(("#file producer : " + DataSetUtils.class.getCanonicalName() + "\n").getBytes());
                DataSetUtils.writeHeaderDataToStream(byteOutput, dataSet);
                if (DataSetUtils.useExportMetaDataByDefault()) {
                    DataSetUtils.writeMetaDataToStream(byteOutput, dataSet);
                }
                if (binary) {
                    DataSetUtils.writeNumericBinaryDataToStream(byteOutput, dataSet, asFloat);
                } else {
                    DataSetUtils.writeNumericDataToStream(byteOutput, dataSet);
                }
            }
            catch (IOException e) {
                LOGGER.error("could not write to ByteArrayOutputStream", (Throwable)e);
                byteOutput.reset();
            }
        });
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, fileName, Compression.AUTO, false);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName, boolean binary) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, fileName, Compression.AUTO, binary);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName, Compression compression) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, fileName, compression, false);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName, Compression compression, boolean binary) {
        AssertUtils.notNull("dataSet", dataSet);
        AssertUtils.notNull("path", path);
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName must not be null or empty");
        }
        try {
            String longFileName;
            block14: {
                String realFileName = DataSetUtils.getFileName(dataSet, fileName);
                longFileName = new File(path.toFile(), realFileName).getAbsolutePath();
                File file = new File(longFileName);
                if (file.getParentFile() != null && file.getParentFile().mkdirs() && LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().addArgument((Object)longFileName).log("needed to create directory for file: {}");
                }
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(8192);
                try (OutputStream outputfile = DataSetUtils.openDatasetFileOutput(file, compression == Compression.AUTO ? DataSetUtils.evaluateAutoCompression(fileName) : compression);){
                    DataSetUtils.writeDataSetToByteArray(dataSet, byteOutput, binary, DataSetUtils.useFloat32BinaryStandard());
                    byteOutput.writeTo(outputfile);
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block14;
                    LOGGER.error("could not write to file: '" + fileName + "'", (Throwable)e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().addArgument((Object)dataSet.getName()).addArgument((Object)longFileName).log("write data set '{}' to {}");
            }
            return longFileName;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("could not write to file: '" + fileName + "'", (Throwable)e);
            }
            return null;
        }
    }

    protected static void writeHeaderDataToStream(OutputStream outputStream, DataSet dataSet) {
        block8: {
            try {
                StringBuilder buffer;
                block7: {
                    buffer = DataSetUtils.getCachedStringBuilder("headerDataCacheBuilder", 250);
                    buffer.append("#dataSetName : ").append(dataSet.getName()).append('\n');
                    int i = 0;
                    for (AxisDescription axisDesc : dataSet.getAxisDescriptions()) {
                        buffer.append('#').append(AXIS_ID.get(i)).append("Min : ").append(axisDesc.getMin()).append('\n');
                        buffer.append('#').append(AXIS_ID.get(i)).append("Max : ").append(axisDesc.getMax()).append('\n');
                        buffer.append('#').append(AXIS_ID.get(i)).append("Name : ").append(axisDesc.getName()).append('\n');
                        buffer.append('#').append(AXIS_ID.get(i)).append("Unit : ").append(axisDesc.getUnit()).append('\n');
                        if (++i < 26) continue;
                        LOGGER.atWarn().log("Writing Axis Metadata for more than 26 dimensional data is currently not supported, sorry");
                        break;
                    }
                    if (dataSet.getDimension() > 2) {
                        buffer.append("## statistics disabled for DataSet3D, not yet implemented\n");
                    } else {
                        try {
                            buffer.append("#integral : ").append(DataSetUtils.integralSimple(dataSet)).append("\n#mean : ").append(DataSetUtils.mean(dataSet.getValues(1))).append("\n#rms : ").append(DataSetUtils.rootMeanSquare(dataSet.getValues(1))).append('\n');
                        }
                        catch (Exception e) {
                            if (!LOGGER.isErrorEnabled()) break block7;
                            LOGGER.atError().addArgument((Object)dataSet.getName()).setCause((Throwable)e).log("writeHeaderDataToFile - compute Math error for dataSet = '{}'");
                        }
                    }
                }
                outputStream.write(buffer.toString().getBytes());
                DataSetUtils.release("headerDataCacheBuilder", buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block8;
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)dataSet.getName()).log("writeHeaderDataToFile - error for dataSet = '{}'");
            }
        }
    }

    protected static void writeMetaDataToStream(OutputStream outputStream, DataSet dataSet) {
        block7: {
            if (!(dataSet instanceof DataSetMetaData)) {
                return;
            }
            DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
            try {
                StringBuilder buffer = DataSetUtils.getCachedStringBuilder(CACHED_META_DATA_STRING_BUILDER, 1000);
                for (String info : metaDataSet.getInfoList()) {
                    buffer.append("#info : ").append(info).append('\n');
                }
                for (String warning : metaDataSet.getWarningList()) {
                    buffer.append("#warning : ").append(warning).append('\n');
                }
                for (String error : metaDataSet.getErrorList()) {
                    buffer.append("#error : ").append(error).append('\n');
                }
                Map<String, String> map = metaDataSet.getMetaInfo();
                for (String key : metaDataSet.getMetaInfo().keySet()) {
                    buffer.append("#metaKey -").append(key).append(" : ").append(map.get(key)).append('\n');
                }
                outputStream.write(buffer.toString().getBytes());
                DataSetUtils.release(CACHED_META_DATA_STRING_BUILDER, buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block7;
                LOGGER.error("writeMetaDataToFile - error for dataSet = '" + dataSet.getName() + "'", (Throwable)e);
            }
        }
    }

    private static void writeNumericBinaryDataToStream(OutputStream outputStream, DataSet dataSet, boolean asFloat) {
        boolean is3D;
        StringBuilder buffer = DataSetUtils.getCachedStringBuilder("binaryDataCacheBuilder", 250);
        buffer.append("$binary\n");
        String dataType = asFloat ? "float32[]" : "float64[]";
        boolean bl = is3D = dataSet.getDimension() > 2 && dataSet.getDataCount(0) * dataSet.getDataCount(1) == dataSet.getDataCount(2);
        if (is3D) {
            buffer.append("$x;").append(dataType).append(';').append(dataSet.getDataCount(0));
            buffer.append("\n$y;").append(dataType).append(';').append(dataSet.getDataCount(1));
            buffer.append("\n$z;").append(dataType).append(';').append(dataSet.getDataCount(2)).append('\n');
        } else {
            buffer.append("$x;").append(dataType).append(';').append(dataSet.getDataCount(0));
            buffer.append("\n$y;").append(dataType).append(';').append(dataSet.getDataCount(1));
            buffer.append("\n$eyn;").append(dataType).append(';').append(dataSet.getDataCount(0));
            buffer.append("\n$eyp;").append(dataType).append(';').append(dataSet.getDataCount(1)).append('\n');
        }
        try {
            outputStream.write(buffer.toString().getBytes());
        }
        catch (IOException e) {
            LOGGER.atError().setCause((Throwable)e).log("WriteNumericDataToBinaryFile failed to write header description");
        }
        DataSetUtils.release("binaryDataCacheBuilder", buffer);
        try {
            outputStream.write(254);
            if (asFloat && !is3D) {
                int nSamples = dataSet.getDataCount(0);
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 4 * nSamples);
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, dataSet.getValues(0), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, dataSet.getValues(1), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYN), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYP), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            } else if (!asFloat && !is3D) {
                int nSamples = dataSet.getDataCount();
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 8 * nSamples);
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, dataSet.getValues(0), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, dataSet.getValues(1), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYN), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYP), nSamples);
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            } else if (asFloat) {
                int nX = dataSet.getDataCount(0);
                int nY = dataSet.getDataCount(1);
                int nZ = dataSet.getDataCount(2);
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 4 * (nX + nY + nZ));
                for (int ix = 0; ix < nX; ++ix) {
                    byteBuffer.putFloat((float)dataSet.get(0, ix));
                }
                for (int iy = 0; iy < nY; ++iy) {
                    byteBuffer.putFloat((float)dataSet.get(1, iy));
                }
                for (int iz = 0; iz < nZ; ++iz) {
                    byteBuffer.putFloat((float)dataSet.get(2, iz));
                }
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            } else {
                int nX = dataSet.getDataCount(0);
                int nY = dataSet.getDataCount(1);
                int nZ = dataSet.getDataCount(2);
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 8 * (nX + nY + nZ));
                for (int ix = 0; ix < nX; ++ix) {
                    byteBuffer.putDouble(dataSet.get(0, ix));
                }
                for (int iy = 0; iy < nY; ++iy) {
                    byteBuffer.putDouble(dataSet.get(1, iy));
                }
                for (int iz = 0; iz < nZ; ++iz) {
                    byteBuffer.putDouble(dataSet.get(2, iz));
                }
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            }
        }
        catch (IOException e) {
            LOGGER.error("WriteNumericDataToBinaryFile failed to write binary body: ", (Throwable)e);
        }
    }

    protected static void writeNumericDataToStream(OutputStream outputFile, DataSet dataSet) {
        block7: {
            try {
                boolean is3D;
                boolean bl = is3D = dataSet.getDimension() == 3 && dataSet.getDataCount(0) * dataSet.getDataCount(1) == dataSet.getDataCount(2);
                if (is3D) {
                    int nX = dataSet.getDataCount(0);
                    int nY = dataSet.getDataCount(1);
                    int nZ = dataSet.getDataCount(2);
                    StringBuilder buffer = DataSetUtils.getCachedStringBuilder(CACHED_STRING_BUILDER, Math.max(100, nZ * 45));
                    buffer.append("#nSamples : ").append(Integer.toString(nZ)).append("\n$index, x, y, z\n");
                    for (int iY = 0; iY < nY; ++iY) {
                        for (int iX = 0; iX < nX; ++iX) {
                            buffer.append(iY * nX + iX);
                            buffer.append(',');
                            buffer.append(dataSet.get(0, iX));
                            buffer.append(',');
                            buffer.append(dataSet.get(1, iY));
                            buffer.append(',');
                            buffer.append(dataSet.get(2, iX + iY * nX));
                            buffer.append('\n');
                        }
                    }
                    outputFile.write(buffer.toString().getBytes());
                } else {
                    int nSamples = dataSet.getDataCount(0);
                    StringBuilder buffer = DataSetUtils.getCachedStringBuilder(CACHED_STRING_BUILDER, Math.max(100, nSamples * 45));
                    buffer.append("#nSamples : ").append(Integer.toString(nSamples)).append("\n$index, x, y, eyn, eyp\n");
                    for (int i = 0; i < nSamples; ++i) {
                        buffer.append(i);
                        buffer.append(',');
                        buffer.append(dataSet.get(0, i));
                        buffer.append(',');
                        buffer.append(dataSet.get(1, i));
                        buffer.append(',');
                        buffer.append(DataSetUtils.error(dataSet, ErrType.EYN, i));
                        buffer.append(',');
                        buffer.append(DataSetUtils.error(dataSet, ErrType.EYP, i));
                        buffer.append('\n');
                    }
                    outputFile.write(buffer.toString().getBytes());
                    DataSetUtils.release(CACHED_STRING_BUILDER, buffer);
                }
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block7;
                LOGGER.error("writeNumericDataToFile - error for dataSet = '" + dataSet.getName() + "'", (Throwable)e);
            }
        }
    }

    protected static class SplitCharByteInputStream
    extends FilterInputStream {
        protected static final byte MARKER = -2;
        private boolean binary;
        private boolean hasMarker;
        private final PushbackInputStream pbin;

        public SplitCharByteInputStream(PushbackInputStream in) {
            super(in);
            this.pbin = in;
        }

        public boolean reachedSplit() {
            return this.hasMarker && !this.binary;
        }

        @Override
        public int read() throws IOException {
            if (this.hasMarker && !this.binary) {
                return -1;
            }
            byte b = (byte)this.in.read();
            if (!this.binary && b == -2) {
                this.hasMarker = true;
                return -1;
            }
            return b == -1 ? -1 : b & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int nread;
            if (this.hasMarker) {
                if (!this.binary) {
                    return -1;
                }
                nread = this.in.read(b, 0, b.length);
            } else {
                nread = this.in.read(b, 0, b.length);
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != -2) continue;
                    this.pbin.unread(b, i + 1, nread - i - 1);
                    this.hasMarker = true;
                    return i;
                }
            }
            return nread;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nread;
            if (this.hasMarker) {
                if (!this.binary) {
                    return -1;
                }
                nread = this.in.read(b, off, len);
            } else {
                nread = this.in.read(b, off, len);
                for (int i = off; i < off + nread; ++i) {
                    if (b[i] != -2) continue;
                    this.pbin.unread(b, i + 1, off + nread - i - 1);
                    this.hasMarker = true;
                    return i - off;
                }
            }
            return nread;
        }

        public void switchToBinary() {
            if (this.hasMarker) {
                if (this.binary) {
                    LOGGER.warn("Allready in binary mode");
                } else {
                    this.binary = true;
                }
            } else {
                LOGGER.warn("Char/Byte split marker not reached yet");
            }
        }
    }

    public static enum ErrType {
        EXN,
        EXP,
        EYN,
        EYP;

    }

    public static enum Compression {
        AUTO,
        GZIP,
        ZIP,
        NONE;

    }
}

