/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.Histogram;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import java.util.Arrays;

public abstract class AbstractHistogram
extends AbstractDataSet<AbstractHistogram>
implements Histogram {
    private static final long serialVersionUID = -6455271782865323112L;
    protected final int[] nAxisBins;
    protected double[][] axisBins;
    private final boolean equidistant;
    protected final double[] data;

    public AbstractHistogram(String name, double[] xBins) {
        super(name, 2);
        int nBins = xBins.length - 1;
        this.nAxisBins = new int[1];
        this.nAxisBins[0] = nBins + 2;
        this.data = new double[this.nAxisBins[0]];
        this.axisBins = new double[1][];
        this.axisBins[0] = new double[this.nAxisBins[0]];
        this.axisBins[0][0] = -1.7976931348623157E308;
        this.axisBins[0][this.nAxisBins[0] - 1] = Double.MAX_VALUE;
        double[] xBinsSorted = Arrays.copyOf(xBins, xBins.length);
        Arrays.sort(xBinsSorted);
        System.arraycopy(xBinsSorted, 0, this.axisBins[0], 1, xBinsSorted.length);
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][nBins + 1]);
        this.getAxisDescription(1).clear();
        this.equidistant = false;
    }

    public AbstractHistogram(String name, int nBins, double minX, double maxX, HistogramOuterBounds boundsType) {
        super(name, 2);
        this.nAxisBins = new int[2];
        this.nAxisBins[0] = nBins + 2;
        this.nAxisBins[1] = nBins + 2;
        this.data = new double[this.nAxisBins[0]];
        switch (boundsType) {
            case BINS_CENTERED_ON_BOUNDARY: {
                double halfBin = (maxX - minX) / (double)((nBins - 1) * 2);
                this.getAxisDescription(0).set(minX - halfBin, maxX + halfBin);
                break;
            }
            case BINS_ALIGNED_WITH_BOUNDARY: {
                this.getAxisDescription(0).set(minX, maxX);
            }
        }
        this.getAxisDescription(1).clear();
        this.equidistant = true;
    }

    public AbstractHistogram(String name, int nBinsX, double minX, double maxX, int nBinsY, double minY, double maxY, HistogramOuterBounds boundsType) {
        super(name, 3);
        this.nAxisBins = new int[3];
        this.nAxisBins[0] = nBinsX + 2;
        this.nAxisBins[1] = nBinsY + 2;
        this.nAxisBins[2] = nBinsX * nBinsY + 2;
        this.data = new double[this.nAxisBins[2]];
        switch (boundsType) {
            case BINS_CENTERED_ON_BOUNDARY: {
                double halfBinX = (maxX - minX) / (double)((nBinsX - 1) * 2);
                this.getAxisDescription(0).set(minX - halfBinX, maxX + halfBinX);
                double halfBinY = (maxY - minY) / (double)((nBinsY - 1) * 2);
                this.getAxisDescription(1).set(minY - halfBinY, maxY + halfBinY);
                break;
            }
            case BINS_ALIGNED_WITH_BOUNDARY: {
                this.getAxisDescription(0).set(minX, maxX);
                this.getAxisDescription(0).set(minY, maxY);
            }
        }
        this.getAxisDescription(2).clear();
        this.equidistant = true;
    }

    @Override
    public void addBinContent(int bin) {
        this.addBinContent(bin, 1.0);
    }

    @Override
    public void addBinContent(int bin, double w) {
        this.lock().writeLockGuard(() -> {
            this.data[bin] = this.data[bin] + w;
            this.getAxisDescription(this.getDimension() - 1).add(this.data[bin]);
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "addBinContent()"));
    }

    @Override
    public int findBin(double x, double y) {
        int indexX = this.findBin(0, x);
        int indexY = this.findBin(1, y);
        return this.getDataCount() * indexY + indexX;
    }

    @Override
    public int findBin(double x, double y, double z) {
        int indexX = this.findBin(0, x);
        int indexY = this.findBin(1, y);
        int indexZ = this.findBin(2, z);
        return this.getDataCount() * (indexY + this.getDataCount() * indexZ) + indexX;
    }

    @Override
    public int findBin(int dimIndex, double x) {
        if (this.getAxisDescription(dimIndex).getLength() == 0.0) {
            return 0;
        }
        if (!this.getAxisDescription(dimIndex).contains(x)) {
            if (x < this.getAxisDescription(dimIndex).getMin()) {
                return 0;
            }
            return this.getDataCount() - 1;
        }
        if (this.isEquiDistant()) {
            double diff = x - this.getAxisDescription(dimIndex).getMin();
            double delta = this.getAxisDescription(dimIndex).getLength() / (double)(this.getDataCount() - 2);
            return (int)Math.floor(diff / delta);
        }
        return this.findNextLargerIndex(this.axisBins[dimIndex], x);
    }

    protected int findNextLargerIndex(double[] bin, double value) {
        for (int i = 1; i < bin.length; ++i) {
            if (!(value < bin[i])) continue;
            return i - 1;
        }
        return bin.length - 1;
    }

    @Override
    public double getBinCenter(int dimIndex, int binIndex) {
        if (this.getAxisDescription(dimIndex).getLength() == 0.0) {
            return this.getAxisDescription(dimIndex).getMin();
        }
        if (this.isEquiDistant()) {
            double delta = this.getAxisDescription(dimIndex).getLength() / (double)this.getDataCount();
            return this.getAxisDescription(dimIndex).getMin() + ((double)binIndex - 0.5) * delta;
        }
        return this.axisBins[dimIndex][binIndex] + 0.5 * (this.axisBins[dimIndex][binIndex + 1] - this.axisBins[dimIndex][binIndex]);
    }

    @Override
    public double getBinContent(int bin) {
        return this.data[bin];
    }

    @Override
    public int getDataCount() {
        return this.nAxisBins[0] - 2;
    }

    @Override
    public boolean isEquiDistant() {
        return this.equidistant;
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, 0.0);
        this.getDataStyleMap().clear();
        this.getDataLabelMap().clear();
        this.getAxisDescription(this.getDimension() - 1).clear();
    }

    public static enum HistogramOuterBounds {
        BINS_CENTERED_ON_BOUNDARY,
        BINS_ALIGNED_WITH_BOUNDARY;

    }
}

