/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.spi.utils.DoublePointError;
import de.gsi.dataset.utils.LimitedQueue;
import java.util.ArrayList;

public class FifoDoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError,
DataSet2D {
    private static final int SAFE_BET = 1;
    private static final long serialVersionUID = -7153702141838930486L;
    protected final transient LimitedQueue<DataBlob> data;
    protected double maxDistance = Double.MAX_VALUE;

    public FifoDoubleErrorDataSet(String name, int initalSize) {
        this(name, initalSize, Double.MAX_VALUE);
    }

    public FifoDoubleErrorDataSet(String name, int initalSize, double maxDistance) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.SYMMETRIC);
        if (initalSize <= 0) {
            throw new IllegalArgumentException("negative or zero initalSize = " + initalSize);
        }
        if (maxDistance <= 0.0) {
            throw new IllegalArgumentException("negative or zero maxDistance = " + maxDistance);
        }
        this.maxDistance = maxDistance;
        this.data = new LimitedQueue(initalSize);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag) {
        return this.add(x, y, yErrorNeg, yErrorPos, tag, null);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag, String style) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DataBlob(x, y, yErrorNeg, yErrorPos, tag, style));
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
            this.expire(x);
        });
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public FifoDoubleErrorDataSet add(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < xValues.length; ++i) {
                this.add(xValues[i], yValues[i], yErrorsNeg[i], yErrorsPos[i]);
            }
        });
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public int expire(double now) {
        int dataPointsToRemove = this.lock().writeLockGuard(() -> {
            ArrayList<DataBlob> toRemoveList = new ArrayList<DataBlob>(1);
            for (DataBlob blob : this.data) {
                double x = blob.getX();
                if (Double.isFinite(x) && !(Math.abs(now - x) > this.maxDistance)) continue;
                toRemoveList.add(blob);
            }
            if (!toRemoveList.isEmpty()) {
                this.data.removeAll(toRemoveList);
                this.getAxisDescriptions().forEach(AxisDescription::clear);
            }
            return toRemoveList.size();
        });
        if (dataPointsToRemove != 0) {
            this.fireInvalidated(new RemovedDataEvent(this, "expired data"));
        }
        return dataPointsToRemove;
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? ((DataBlob)this.data.get(index)).getX() : ((DataBlob)this.data.get(index)).getY();
    }

    public LimitedQueue<DataBlob> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int index) {
        return ((DataBlob)this.data.get(index)).getDataLabel();
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : ((DataBlob)this.data.get(index)).getErrorX();
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : ((DataBlob)this.data.get(index)).getErrorY();
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public String getStyle(int index) {
        return ((DataBlob)this.data.get(index)).getStyle();
    }

    public void reset() {
        this.data.clear();
        this.fireInvalidated(new RemovedDataEvent(this, "reset"));
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }

    protected class DataBlob
    extends DoublePointError {
        protected String style;
        protected String tag;

        protected DataBlob(double x, double y, double errorYNeg, double errorYPos, String tag, String style) {
            super(x, y, errorYNeg, errorYPos);
            this.tag = tag;
            this.style = style;
        }

        public String getDataLabel() {
            return this.tag;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

