/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.Histogram1D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram
extends AbstractHistogram
implements Histogram1D,
DataSet2D {
    private static final long serialVersionUID = -8609726961834745312L;
    protected final boolean isHorizontal;

    public Histogram(String name, double[] xBins) {
        this(name, xBins, true);
    }

    public Histogram(String name, double[] xBins, boolean horizontal) {
        super(name, xBins);
        this.isHorizontal = horizontal;
    }

    public Histogram(String name, int nBins, double minX, double maxX, AbstractHistogram.HistogramOuterBounds boundsType) {
        this(name, nBins, minX, maxX, true, boundsType);
    }

    public Histogram(String name, int nBins, double minX, double maxX, boolean horizontal, AbstractHistogram.HistogramOuterBounds boundsType) {
        super(name, nBins, minX, maxX, boundsType);
        this.isHorizontal = horizontal;
        if (!this.isHorizontal) {
            this.getAxisDescription(1).set(this.getAxisDescription(0));
            this.getAxisDescription(0).clear();
        }
    }

    @Override
    public void addBinContent(int bin, double w) {
        this.lock().writeLockGuard(() -> {
            this.data[bin] = this.data[bin] + w;
            if (this.getDimension() == 2) {
                this.getAxisDescription(this.isHorizontal ? 1 : 0).add(this.data[bin]);
            } else {
                this.getAxisDescription(this.getDimension() - 1).add(this.data[bin]);
            }
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "addBinContent()"));
    }

    @Override
    public int fill(double x, double w) {
        int retVal = this.lock().writeLockGuard(() -> {
            int bin = this.findBin(this.isHorizontal ? 0 : 1, x);
            this.addBinContent(bin, w);
            return bin;
        });
        this.fireInvalidated(new AddedDataEvent(this, "fill(double x, double w)"));
        return retVal;
    }

    @Override
    public void fillN(double[] x, double[] w, int stepSize) {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < x.length; ++i) {
                this.fill(x[i], w[i]);
            }
        });
        this.fireInvalidated(new AddedDataEvent(this, "fillN"));
    }

    @Override
    public int findBin(int dimIndex, double x) {
        if (this.getAxisDescription(dimIndex).getLength() == 0.0) {
            return 0;
        }
        if (!this.getAxisDescription(dimIndex).contains(x)) {
            if (x < this.getAxisDescription(dimIndex).getMin()) {
                return 0;
            }
            return this.getDataCount() - 1;
        }
        if (this.isEquiDistant()) {
            double diff = x - this.getAxisDescription(dimIndex).getMin();
            double len = this.getAxisDescription(dimIndex).getLength();
            int count = this.getDataCount();
            double delta = len / (double)count;
            return (int)Math.round(diff / delta);
        }
        return this.findNextLargerIndex(this.axisBins[0], x);
    }

    @Override
    public double get(int dimIndex, int index) {
        if (dimIndex == 0) {
            return this.isHorizontal ? this.getBinCenter(0, index + 1) : this.getBinContent(index + 1);
        }
        if (dimIndex == 1) {
            return this.isHorizontal ? this.getBinContent(index + 1) : this.getBinCenter(1, index + 1);
        }
        return dimIndex + 1 < this.getDimension() ? this.getBinCenter(0, index + 1) : this.getBinContent(index + 1);
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }

    @Override
    public int getIndex(int dimIndex, double ... value) {
        AssertUtils.checkArrayDimension("value", value, 1);
        return this.findBin(dimIndex, value[0]) - 1;
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    public double getValue(int dimIndex, double x) {
        int index1 = this.getIndex(0, x);
        double x1 = this.get(0, index1);
        double y1 = this.get(1, index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.get(1, index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.get(0, index2);
        if (x1 == x2) {
            return y1;
        }
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    @Override
    public List<String> getWarningList() {
        LinkedList<String> retVal = new LinkedList<String>();
        if (this.getBinContent(0) > 0.0) {
            retVal.add("under-range");
        }
        if (this.getBinContent(this.getDataCount() - 1) > 0.0) {
            retVal.add("over-range");
        }
        return retVal;
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, 0.0);
        this.getDataStyleMap().clear();
        this.getDataLabelMap().clear();
        if (this.getDimension() == 2) {
            this.getAxisDescription(this.isHorizontal ? 1 : 0).clear();
        } else {
            this.getAxisDescription(this.getDimension() - 1).clear();
        }
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }
}

