/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayFloat
extends MultiArray<float[]> {
    public static MultiArrayFloat wrap(float[] elements) {
        return MultiArrayFloat.wrap(elements, 0, elements.length);
    }

    public static MultiArrayFloat wrap(float[] elements, int offset, int length) {
        return new MultiArray1DFloat(elements, new int[]{length}, offset);
    }

    public static MultiArrayFloat wrap(float[] elements, int[] dimensions) {
        return MultiArrayFloat.wrap(elements, 0, dimensions);
    }

    public static MultiArrayFloat wrap(float[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DFloat(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DFloat(elements, dimensions, offset);
            }
        }
        return new MultiArrayFloat(elements, dimensions, offset);
    }

    public static MultiArrayFloat allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DFloat(new float[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DFloat(new float[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayFloat(new float[nElements], dimensions, 0);
    }

    protected MultiArrayFloat(float[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, float value) {
        ((float[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, float value) {
        ((float[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public float getStrided(int index) {
        return ((float[])this.elements)[index + this.offset];
    }

    public float get(int[] indices) {
        return ((float[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayFloat)) {
            return false;
        }
        MultiArrayFloat that = (MultiArrayFloat)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((float[])this.elements, this.offset, this.offset + this.getElementsCount(), (float[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Float.hashCode(((float[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DFloat
    extends MultiArrayFloat {
        private final int stride;

        protected MultiArray2DFloat(float[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public float get(int column, int row) {
            return ((float[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, float value) {
            ((float[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public float[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((float[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DFloat
    extends MultiArrayFloat {
        protected MultiArray1DFloat(float[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public float get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, float value) {
            this.setStrided(index, value);
        }
    }
}

