/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class MultiArrayObject<U>
extends MultiArray<U[]> {
    public static <T> MultiArrayObject wrap(T[] elements) {
        return MultiArrayObject.wrap(elements, 0, elements.length);
    }

    public static <T> MultiArrayObject wrap(T[] elements, int offset, int length) {
        return new MultiArray1DObject<T>(elements, new int[]{length}, offset);
    }

    public static <T> MultiArrayObject wrap(T[] elements, int[] dimensions) {
        return MultiArrayObject.wrap(elements, 0, dimensions);
    }

    public static <T> MultiArrayObject wrap(T[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DObject<T>(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DObject<T>(elements, dimensions, offset);
            }
        }
        return new MultiArrayObject<T>(elements, dimensions, offset);
    }

    public static <T> MultiArrayObject allocate(int[] dimensions, Class<T[]> clazz) {
        switch (dimensions.length) {
            case 1: {
                try {
                    return new MultiArray1DObject<T>(clazz.getConstructor(Integer.TYPE).newInstance(dimensions[0]), dimensions, 0);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Could not allocate array for given type", e);
                }
            }
            case 2: {
                try {
                    return new MultiArray2DObject<T>(clazz.getConstructor(Integer.TYPE).newInstance(dimensions[0] * dimensions[1]), dimensions, 0);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Could not allocate array for given type", e);
                }
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        try {
            return new MultiArrayObject<T>(clazz.getConstructor(Integer.TYPE).newInstance(nElements), dimensions, 0);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not allocate array for given type", e);
        }
    }

    protected MultiArrayObject(U[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, U value) {
        ((Object[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, U value) {
        ((Object[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public U getStrided(int index) {
        return (U)((Object[])this.elements)[index + this.offset];
    }

    public U get(int[] indices) {
        return (U)((Object[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayObject)) {
            return false;
        }
        MultiArrayObject that = (MultiArrayObject)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((Object[])this.elements, this.offset, this.offset + this.getElementsCount(), (Object[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + ((Object[])this.elements)[i].hashCode();
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DObject<U>
    extends MultiArrayObject<U> {
        private final int stride;

        protected MultiArray2DObject(U[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public U get(int column, int row) {
            return (U)((Object[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, U value) {
            ((Object[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public U[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((Object[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DObject<U>
    extends MultiArrayObject<U> {
        protected MultiArray1DObject(U[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public U get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, U value) {
            this.setStrided(index, value);
        }
    }
}

