/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayShort
extends MultiArray<short[]> {
    public static MultiArrayShort wrap(short[] elements) {
        return MultiArrayShort.wrap(elements, 0, elements.length);
    }

    public static MultiArrayShort wrap(short[] elements, int offset, int length) {
        return new MultiArray1DShort(elements, new int[]{length}, offset);
    }

    public static MultiArrayShort wrap(short[] elements, int[] dimensions) {
        return MultiArrayShort.wrap(elements, 0, dimensions);
    }

    public static MultiArrayShort wrap(short[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DShort(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DShort(elements, dimensions, offset);
            }
        }
        return new MultiArrayShort(elements, dimensions, offset);
    }

    public static MultiArrayShort allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DShort(new short[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DShort(new short[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayShort(new short[nElements], dimensions, 0);
    }

    protected MultiArrayShort(short[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, short value) {
        ((short[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, short value) {
        ((short[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public short getStrided(int index) {
        return ((short[])this.elements)[index + this.offset];
    }

    public short get(int[] indices) {
        return ((short[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayShort)) {
            return false;
        }
        MultiArrayShort that = (MultiArrayShort)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((short[])this.elements, this.offset, this.offset + this.getElementsCount(), (short[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Short.hashCode(((short[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DShort
    extends MultiArrayShort {
        private final int stride;

        protected MultiArray2DShort(short[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public short get(int column, int row) {
            return ((short[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, short value) {
            ((short[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public short[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((short[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DShort
    extends MultiArrayShort {
        protected MultiArray1DShort(short[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public short get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, short value) {
            this.setStrided(index, value);
        }
    }
}

