// This file has been generated automatically by chartfx-generate. Do not modify!
// autogenerated code for U - U from double
//// codegen container: U -> U, float, char, short, int, long, boolean, byte, U
package de.gsi.dataset.spi.utils;

import java.util.Arrays;

import de.gsi.dataset.utils.AssertUtils;

/**
 * Implementation of MultiArray for U values. Also contains subtypes for 1D and 2D Arrays which allow more convenient and more efficient access.
 * <p>
 * The data is stored in row-major in a flat U array.
 * <p>
 *
 * @author Alexander Krimm
 */
public class MultiArrayObject<U> extends MultiArray<U[]> { //// codegen: subst:U:Object<U>:Object<U><U>
    /**
     * @param elements Elements for the new MultiArray
     * @return A MultiArrayU1D with the supplied elements
     */
    public static <T> MultiArrayObject wrap(final T[] elements) { //// codegen: subst:U:T[]:T[] //// subst:U:static <T>:static <T> <T>
        return wrap(elements, 0, elements.length);
    }

    /**
     * @param elements Elements for the new MultiArray
     * @param offset where in the backing array the element data starts
     * @param length number of elements to use from the elements array
     * @return A MultiArrayU1D with the supplied elements
     */
    public static <T> MultiArrayObject wrap(final T[] elements, final int offset, final int length) { //// codegen: subst:U:T[]:T[] //// subst:U:static <T>:static <T> <T>
        return new MultiArray1DObject(elements, new int[] { length }, offset);
    }

    /**
     * @param dimensions The size of the new MultiArrayU
     * @param elements   The element data of the MultiArrayU in row-major storage
     * @return A MultiArrayU or specialisation of it for the 1D and 2D case
     */
    public static <T> MultiArrayObject wrap(final T[] elements, final int[] dimensions) { //// codegen: subst:U:T[]:T[] //// subst:U:static <T>:static <T> <T>
        return wrap(elements, 0, dimensions);
    }

    /**
     * @param elements   The element data of the MultiArrayU in row-major storage
     * @param offset where in the backing array the element data starts
     * @param dimensions The size of the new MultiArrayU
     * @return A MultiArrayU or specialisation of it for the 1D and 2D case
     */
    public static <T> MultiArrayObject wrap(final T[] elements, final int offset, final int[] dimensions) { //// codegen: subst:U:T[]:T[] //// subst:U:static <T>:static <T> <T>
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
        case 1:
            return new MultiArray1DObject(elements, dimensions, offset);
        case 2:
            return new MultiArray2DObject(elements, dimensions, offset);
        default:
            return new MultiArrayObject(elements, dimensions, offset);
        }
    }

    /**
     * @param dimensions Dimensions for the new MultiArray
     * @return A new MultiArrayU with a new empty backing array
     */
    public static <T> MultiArrayObject allocate(final int[] dimensions, final Class<T[]> clazz) { //// codegen: subst:U:, final Class<T[]> clazz) {:, final Class<T[]> clazz, final Class<T[]> clazz) { //// subst:U:static <T>:static <T> <T>
        switch (dimensions.length) {
        case 1:
            try { //// codegen: subst:U::
                return new MultiArray1DObject(clazz.getConstructor(int.class).newInstance(dimensions[0]), dimensions, 0); //// codegen: subst:U::
            } catch (InstantiationException | NoSuchMethodException | IllegalAccessException | java.lang.reflect.InvocationTargetException e) { //// codegen: subst:U::
                throw new IllegalArgumentException("Could not allocate array for given type", e); //// codegen: subst:U::
            } //// codegen: subst:U::
            //*// return new MultiArray1DObject(new U[dimensions[0]], dimensions, 0); //// codegen: subst:U://*// return://*// //*// return
        case 2:
            try { //// codegen: subst:U::
                return new MultiArray2DObject(clazz.getConstructor(int.class).newInstance(dimensions[0] * dimensions[1]), dimensions, 0); //// codegen: subst:U::
            } catch (InstantiationException | NoSuchMethodException | IllegalAccessException | java.lang.reflect.InvocationTargetException e) { //// codegen: subst:U::
                throw new IllegalArgumentException("Could not allocate array for given type", e); //// codegen: subst:U::
            } //// codegen: subst:U::
            //*// try {
            //*// return new MultiArray2DObject(new U[dimensions[1] * dimensions[0]], dimensions, 0); //// codegen: subst:U://*// return://*// //*// return
        default:
            int nElements = 1;
            for (int ni : dimensions) {
                nElements *= ni;
            }
            try { //// codegen: subst:U::
                return new MultiArrayObject(clazz.getConstructor(int.class).newInstance(nElements), dimensions, 0); //// codegen: subst:U::
            } catch (InstantiationException | NoSuchMethodException | IllegalAccessException | java.lang.reflect.InvocationTargetException e) { //// codegen: subst:U::
                throw new IllegalArgumentException("Could not allocate array for given type", e); //// codegen: subst:U::
            } //// codegen: subst:U::
            //*// return new MultiArrayObject(new U[nElements], dimensions, 0); //// codegen: subst:U://*// return://*// //*// return
        }
    }

    protected MultiArrayObject(final U[] elements, final int[] dimensions, final int offset) { //// codegen: subst:U:U[]:U[]
        super(elements, dimensions, offset);
    }

    /**
     * Set a value in the backing array using linear indexing.
     *
     * @param value the new value for the element
     * @param index the index of the element to set
     */
    public void setStrided(final int index, final U value) {
        elements[index + offset] = value; //// codegen: subst:U:U:U
    }

    /**
     * Set a value in the MultiArray for given indices
     *
     * @param value   The new value for the element
     * @param indices Indices for every dimension of the MultiArray
     */
    public void set(final int[] indices, final U value) {
        elements[getIndex(indices)] = value;
    }

    /**
     * Get a value in the backing array using linear indexing.
     *
     * @param index the index of the element to set
     * @return The element value
     */
    public U getStrided(final int index) {
        return elements[index + offset];
    }

    /**
     * Get a value in the MultiArray.
     *
     * @param indices the indices of the element to set
     * @return The element value
     */
    public U get(final int[] indices) {
        return elements[getIndex(indices)];
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o)
            return true;
        if (!(o instanceof MultiArrayObject)) //// codegen: subst:U:MultiArrayObject:MultiArrayObject
            return false;
        final MultiArrayObject<U> that = (MultiArrayObject<U>) o; //// codegen: subst:U:MultiArrayObject<U>:MultiArrayObject<U>
        return Arrays.equals(dimensions, that.dimensions) && Arrays.equals(elements, offset, offset + getElementsCount(), that.elements, that.offset, that.offset + getElementsCount());
    }

    @Override
    public int hashCode() {
        // hash of relevant subsection of the array
        int result = 1;
        for (int i = offset; i < offset + getElementsCount(); i++) {
            result = 31 * result + elements[i].hashCode(); //// codegen: subst:int:Int:Integer //// subst:char:Char:Character //// subst:U:elements[i].hashCode():elements[i].hashCode()
        }
        // hash of the dimensions
        result = 31 * result + Arrays.hashCode(dimensions);
        return result;
    }

    /**
     * Specialisation for the 1D case to allow for easier and more efficient usage
     */
    public static class MultiArray1DObject<U> extends MultiArrayObject<U> { //// codegen: subst:U:Object<U>:Object<U><U>
        protected MultiArray1DObject(final U[] elements, final int[] dimensions, final int offset) { //// codegen: subst:U:U[]:U[]
            super(elements, dimensions, offset);
        }

        public U get(final int index) {
            return getStrided(index);
        }

        public void set(final int index, final U value) {
            setStrided(index, value);
        }
    }

    /**
     * Specialisation for the 2D case to allow for easier and more efficient usage
     */
    public static class MultiArray2DObject<U> extends MultiArrayObject<U> { //// codegen: subst:U:Object<U>:Object<U><U>
        private final int stride;

        protected MultiArray2DObject(final U[] elements, final int[] dimensions, final int offset) { //// codegen: subst:U:U[]:U[]
            super(elements, dimensions, offset);
            stride = dimensions[0];
        }

        public U get(final int column, final int row) {
            return elements[offset + column + row * stride];
        }

        public void set(final int column, final int row, final U value) {
            elements[offset + column + row * stride] = value;
        }

        public U[] getRow(final int row) {
            final int index = row * stride + offset;
            return Arrays.copyOfRange(elements, index, index + stride);
        }
    }
}
