/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.AxisNameChangeEvent;
import de.gsi.dataset.event.AxisRangeChangeEvent;
import de.gsi.dataset.event.AxisRecomputationEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.spi.DataRange;
import de.gsi.dataset.spi.utils.MathUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultAxisDescription
extends DataRange
implements AxisDescription {
    private final transient AtomicBoolean autoNotification = new AtomicBoolean(true);
    private final transient List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final int dimIndex;
    private String name;
    private String unit;

    public DefaultAxisDescription(int dimIndex) {
        this.dimIndex = dimIndex;
        this.name = "unknown axis";
        this.unit = "a.u.";
    }

    public DefaultAxisDescription(AxisDescription axisDesc) {
        this.dimIndex = axisDesc.getDimIndex();
        this.set(axisDesc.getName(), axisDesc.getUnit(), axisDesc.getMin(), axisDesc.getMax());
    }

    public DefaultAxisDescription(int dimIndex, String axisName, String ... axisUnit) {
        this.dimIndex = dimIndex;
        this.set(axisName, axisUnit);
    }

    public DefaultAxisDescription(int dimIndex, String axisName, String axisUnit, double rangeMin, double rangeMax) {
        this.dimIndex = dimIndex;
        this.set(axisName, axisUnit, rangeMin, rangeMax);
    }

    @Override
    public boolean add(double value) {
        if (!super.add(value)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean add(double[] values, int length) {
        if (!super.add(values, length)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AxisDescription)) {
            return false;
        }
        return this.equals(obj, 1.0E-6);
    }

    public boolean equals(Object obj, double epsilon) {
        if (!(obj instanceof AxisDescription)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AxisDescription other = (AxisDescription)obj;
        if (this.hashCode() == other.hashCode()) {
            return true;
        }
        if (epsilon <= 0.0) {
            return false;
        }
        if (!DefaultAxisDescription.strEqual(this.getName(), other.getName())) {
            return false;
        }
        if (!DefaultAxisDescription.strEqual(this.getUnit(), other.getUnit())) {
            return false;
        }
        if (epsilon <= 0.0) {
            if (this.getMin() != other.getMin()) {
                return false;
            }
            return this.getMax() == other.getMax();
        }
        if (!MathUtils.nearlyEqual(this.getMin(), other.getMin(), epsilon)) {
            return false;
        }
        return MathUtils.nearlyEqual(this.getMax(), other.getMax(), epsilon);
    }

    @Override
    public final int getDimIndex() {
        return this.dimIndex;
    }

    @Override
    public final double getMax() {
        if (this.isMaxDefined()) {
            return super.getMax();
        }
        boolean oldNotifyState = this.autoNotification.getAndSet(true);
        this.invokeListener(new AxisRecomputationEvent((EventSource)this, this.updateMessage(), this.getDimIndex()));
        this.autoNotification.getAndSet(oldNotifyState);
        return super.getMax();
    }

    @Override
    public final double getMin() {
        if (this.isMinDefined()) {
            return super.getMin();
        }
        boolean oldNotifyState = this.autoNotification.getAndSet(true);
        this.invokeListener(new AxisRecomputationEvent((EventSource)this, this.updateMessage(), this.getDimIndex()));
        this.autoNotification.getAndSet(oldNotifyState);
        return super.getMin();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getUnit() {
        return this.unit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + Double.hashCode(this.getMin());
        result = 31 * result + Double.hashCode(this.getMax());
        return result;
    }

    @Override
    public boolean set(DataRange range) {
        if (!super.set(range)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean set(double min, double max) {
        boolean a = super.setMin(min);
        boolean b = super.setMax(max);
        if (a || b) {
            this.notifyRangeChange();
            return true;
        }
        return false;
    }

    @Override
    public final boolean set(String axisName, String ... axisUnit) {
        boolean namesHaveChanged = !DefaultAxisDescription.strEqual(this.name, axisName);
        this.name = axisName;
        if (axisUnit != null && axisUnit.length > 0 && !DefaultAxisDescription.strEqual(this.unit, axisUnit[0])) {
            this.unit = axisUnit[0];
            namesHaveChanged = true;
            if (axisUnit.length > 1) {
                throw new IllegalArgumentException("more than one unit is not allowed");
            }
        }
        if (namesHaveChanged) {
            this.notifyNameChange();
        }
        return false;
    }

    @Override
    public final boolean set(String axisName, String axisUnit, double rangeMin, double rangeMax) {
        boolean namesHaveChanged = !DefaultAxisDescription.strEqual(this.name, axisName) || !DefaultAxisDescription.strEqual(this.unit, axisUnit);
        this.name = axisName;
        this.unit = axisUnit;
        boolean rangeHasChanged = false;
        if (this.getMin() != rangeMin || this.getMax() != rangeMax) {
            rangeHasChanged = true;
            this.set(rangeMin, rangeMax);
        }
        if (namesHaveChanged && rangeHasChanged) {
            this.notifyFullChange();
        } else if (namesHaveChanged) {
            this.notifyNameChange();
        } else if (rangeHasChanged) {
            this.notifyRangeChange();
        }
        return true;
    }

    @Override
    public boolean setMax(double max) {
        if (!super.setMax(max)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean setMin(double min) {
        if (!super.setMin(min)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + ", axisName = '" + this.getName() + "', axisUnit = '" + this.getUnit() + "'";
    }

    @Override
    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    private void notifyFullChange() {
        this.invokeListener(new AxisChangeEvent((EventSource)this, "updated axis for '" + this.name + "' '[" + this.unit + "]'", this.getDimIndex()));
    }

    private void notifyNameChange() {
        this.invokeListener(new AxisNameChangeEvent((EventSource)this, "updated axis names for '" + this.name + "' '[" + this.unit + "]'", this.getDimIndex()));
    }

    private void notifyRangeChange() {
        this.invokeListener(new AxisRangeChangeEvent((EventSource)this, this.updateMessage(), this.getDimIndex()));
    }

    private String updateMessage() {
        return "updated axis range for '" + this.name + "' '[" + this.unit + "]'";
    }

    private static boolean strEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }
}

