/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayBoolean
extends MultiArray<boolean[]> {
    public static MultiArrayBoolean wrap(boolean[] elements) {
        return MultiArrayBoolean.wrap(elements, 0, elements.length);
    }

    public static MultiArrayBoolean wrap(boolean[] elements, int offset, int length) {
        return new MultiArray1DBoolean(elements, new int[]{length}, offset);
    }

    public static MultiArrayBoolean wrap(boolean[] elements, int[] dimensions) {
        return MultiArrayBoolean.wrap(elements, 0, dimensions);
    }

    public static MultiArrayBoolean wrap(boolean[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DBoolean(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DBoolean(elements, dimensions, offset);
            }
        }
        return new MultiArrayBoolean(elements, dimensions, offset);
    }

    public static MultiArrayBoolean allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DBoolean(new boolean[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DBoolean(new boolean[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayBoolean(new boolean[nElements], dimensions, 0);
    }

    protected MultiArrayBoolean(boolean[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, boolean value) {
        ((boolean[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, boolean value) {
        ((boolean[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public boolean getStrided(int index) {
        return ((boolean[])this.elements)[index + this.offset];
    }

    public boolean get(int[] indices) {
        return ((boolean[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayBoolean)) {
            return false;
        }
        MultiArrayBoolean that = (MultiArrayBoolean)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((boolean[])this.elements, this.offset, this.offset + this.getElementsCount(), (boolean[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Boolean.hashCode(((boolean[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DBoolean
    extends MultiArrayBoolean {
        private final int stride;

        protected MultiArray2DBoolean(boolean[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public boolean get(int column, int row) {
            return ((boolean[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, boolean value) {
            ((boolean[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public boolean[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((boolean[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DBoolean
    extends MultiArrayBoolean {
        protected MultiArray1DBoolean(boolean[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public boolean get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, boolean value) {
            this.setStrided(index, value);
        }
    }
}

