/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayInt
extends MultiArray<int[]> {
    public static MultiArrayInt wrap(int[] elements) {
        return MultiArrayInt.wrap(elements, 0, elements.length);
    }

    public static MultiArrayInt wrap(int[] elements, int offset, int length) {
        return new MultiArray1DInt(elements, new int[]{length}, offset);
    }

    public static MultiArrayInt wrap(int[] elements, int[] dimensions) {
        return MultiArrayInt.wrap(elements, 0, dimensions);
    }

    public static MultiArrayInt wrap(int[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DInt(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DInt(elements, dimensions, offset);
            }
        }
        return new MultiArrayInt(elements, dimensions, offset);
    }

    public static MultiArrayInt allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DInt(new int[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DInt(new int[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayInt(new int[nElements], dimensions, 0);
    }

    protected MultiArrayInt(int[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, int value) {
        ((int[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, int value) {
        ((int[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public int getStrided(int index) {
        return ((int[])this.elements)[index + this.offset];
    }

    public int get(int[] indices) {
        return ((int[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayInt)) {
            return false;
        }
        MultiArrayInt that = (MultiArrayInt)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((int[])this.elements, this.offset, this.offset + this.getElementsCount(), (int[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Integer.hashCode(((int[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DInt
    extends MultiArrayInt {
        private final int stride;

        protected MultiArray2DInt(int[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public int get(int column, int row) {
            return ((int[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, int value) {
            ((int[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public int[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((int[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DInt
    extends MultiArrayInt {
        protected MultiArray1DInt(int[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public int get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, int value) {
            this.setStrided(index, value);
        }
    }
}

