/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CacheCollection<T>
extends AbstractCollection<T> {
    protected final List<Reference<T>> contents = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T recoveredObject) {
        if (recoveredObject != null) {
            List<Reference<T>> list = this.contents;
            synchronized (list) {
                if (this.contains(recoveredObject)) {
                    return false;
                }
                return this.contents.add(new SoftReference<T>(recoveredObject));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            this.contents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object != null) {
            List<Reference<T>> list = this.contents;
            synchronized (list) {
                for (Reference<T> weakReference : this.contents) {
                    if (!object.equals(weakReference.get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            return new CacheCollectionIterator<T>(this.contents.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            Iterator<Reference<T>> iter = this.contents.iterator();
            while (iter.hasNext()) {
                Reference<T> candidate = iter.next();
                T test = candidate.get();
                if (test == null) {
                    iter.remove();
                    continue;
                }
                if (!o.equals(test)) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            this.cleanup();
            return this.contents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            LinkedList<Reference<T>> toRemove = new LinkedList<Reference<T>>();
            for (Reference<T> weakReference : this.contents) {
                if (weakReference.get() != null) continue;
                toRemove.add(weakReference);
            }
            this.contents.removeAll(toRemove);
        }
    }

    private static class CacheCollectionIterator<T>
    implements Iterator<T> {
        private final Iterator<Reference<T>> iterator;
        private T next;

        private CacheCollectionIterator(Iterator<Reference<T>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                T t = this.iterator.next().get();
                if (t == null) continue;
                this.next = t;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            T result = this.next;
            this.next = null;
            while (result == null) {
                result = this.iterator.next().get();
            }
            return result;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

