/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

public final class GenericsHelper {
    private GenericsHelper() {
    }

    private static void checkForNonConformity(Object[] array, Class<?> prototype) {
        if (array == null) {
            throw new IllegalArgumentException("null array pointer ");
        }
        if (array.length == 0) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("array class element " + i + " is null, should be of type'" + prototype.getName() + "'");
        }
        if (!prototype.isAssignableFrom(array[0].getClass())) {
            throw new IllegalArgumentException("array class type '" + array[0].getClass().getName() + "' mismatch with '" + prototype.getName() + "'");
        }
    }

    public static boolean[] toBoolPrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Boolean.class);
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] != null && (Boolean)array[i] != false;
        }
        return result;
    }

    public static byte[] toBytePrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Byte.class);
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == null ? (byte)0 : (Byte)array[i];
        }
        return result;
    }

    public static char[] toCharPrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Character.class);
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == null ? (char)'\u0000' : ((Character)array[i]).charValue();
        }
        return result;
    }

    public static double[] toDoublePrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Double.class);
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == null ? Double.NaN : (Double)array[i];
        }
        return result;
    }

    public static float[] toFloatPrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Float.class);
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == null ? Float.NaN : ((Float)array[i]).floatValue();
        }
        return result;
    }

    public static int[] toIntegerPrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Integer.class);
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == null ? 0 : (Integer)array[i];
        }
        return result;
    }

    public static long[] toLongPrimitive(Object[] array) {
        GenericsHelper.checkForNonConformity(array, Long.class);
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == null ? 0L : (Long)array[i];
        }
        return result;
    }

    public static Boolean[] toObject(boolean[] array) {
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] toObject(byte[] array) {
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Character[] toObject(char[] array) {
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] toObject(double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] toObject(float[] array) {
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Integer[] toObject(int[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] toObject(long[] array) {
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Short[] toObject(short[] array) {
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static char[] toPrimitive(Character[] array) {
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toShortPrimitive(Object[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (Short)array[i];
        }
        return result;
    }

    public static String[] toStringPrimitive(Object[] array) {
        String[] result;
        block6: {
            block8: {
                block7: {
                    block5: {
                        result = new String[array.length];
                        if (array.length == 0) {
                            return result;
                        }
                        if (!(array[0] instanceof String)) break block5;
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = (String)array[i];
                        }
                        break block6;
                    }
                    if (!(array[0] instanceof Boolean)) break block7;
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = ((Boolean)array[i]).toString();
                    }
                    break block6;
                }
                if (!(array[0] instanceof Character)) break block8;
                for (int i = 0; i < array.length; ++i) {
                    result[i] = array[i].toString();
                }
                break block6;
            }
            if (!(array[0] instanceof Number)) break block6;
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i].toString();
            }
        }
        return result;
    }

    public static double[] toDoublePrimitive(boolean[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i] ? 1.0 : 0.0;
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(byte[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(char[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(float[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(int[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(long[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(short[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static double[] toDoublePrimitive(String[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i] == null ? Double.NaN : Double.parseDouble(input[i]);
        }
        return doubleArray;
    }
}

