/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.CircularBuffer;
import de.gsi.dataset.utils.DoubleCircularBuffer;

public class CircularDoubleErrorDataSet
extends AbstractErrorDataSet<CircularDoubleErrorDataSet>
implements DataSetError,
DataSet2D {
    private static final long serialVersionUID = -8010355203980379253L;
    protected DoubleCircularBuffer xValues;
    protected DoubleCircularBuffer yValues;
    protected DoubleCircularBuffer yErrorsPos;
    protected DoubleCircularBuffer yErrorsNeg;
    protected CircularBuffer<String> dataLabels;
    protected CircularBuffer<String> dataStyles;

    public CircularDoubleErrorDataSet(String name, int initalSize) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleCircularBuffer(initalSize);
        this.yValues = new DoubleCircularBuffer(initalSize);
        this.yErrorsPos = new DoubleCircularBuffer(initalSize);
        this.yErrorsNeg = new DoubleCircularBuffer(initalSize);
        this.dataLabels = new CircularBuffer(initalSize);
        this.dataStyles = new CircularBuffer(initalSize);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label) {
        return this.add(x, y, yErrorNeg, yErrorPos, label, null);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label, String style) {
        this.lock().writeLockGuard(() -> {
            this.xValues.put(x);
            this.yValues.put(y);
            this.yErrorsPos.put(yErrorPos);
            this.yErrorsNeg.put(yErrorNeg);
            this.dataLabels.put(label);
            this.dataStyles.put(style);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (CircularDoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public CircularDoubleErrorDataSet add(double[] xVals, double[] yVals, double[] yErrNeg, double[] yErrPos) {
        AssertUtils.notNull("X coordinates", xVals);
        AssertUtils.notNull("Y coordinates", yVals);
        AssertUtils.notNull("Y error neg", yErrNeg);
        AssertUtils.notNull("Y error pos", yErrPos);
        AssertUtils.equalDoubleArrays(xVals, yVals);
        AssertUtils.equalDoubleArrays(xVals, yErrNeg);
        AssertUtils.equalDoubleArrays(xVals, yErrPos);
        this.lock().writeLockGuard(() -> {
            this.xValues.put(xVals, xVals.length);
            this.yValues.put(yVals, yVals.length);
            this.yErrorsNeg.put(yErrNeg, yErrNeg.length);
            this.yErrorsPos.put(yErrPos, yErrPos.length);
            this.dataLabels.put((String[])new String[yErrPos.length], yErrPos.length);
            this.dataStyles.put((String[])new String[yErrPos.length], yErrPos.length);
            this.getAxisDescription(0).add(xVals);
            for (int i = 0; i < yVals.length; ++i) {
                this.getAxisDescription(1).add(yVals[i] + yErrPos[i]);
                this.getAxisDescription(1).add(yVals[i] - yErrNeg[i]);
            }
        });
        return (CircularDoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public int getDataCount() {
        return this.xValues.available();
    }

    @Override
    public String getDataLabel(int index) {
        return this.dataLabels.get(index);
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsNeg.get(index);
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsPos.get(index);
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.xValues.get(index) : this.yValues.get(index);
    }

    @Override
    public String addDataLabel(int index, String label) {
        throw new UnsupportedOperationException("Adding data labels later is not supported, supply labels to add()");
    }

    @Override
    public String addDataStyle(int index, String style) {
        throw new UnsupportedOperationException("Adding data styles later is not supported, supply labels to add()");
    }

    @Override
    public String removeStyle(int index) {
        throw new UnsupportedOperationException("Removing data styles is not supported for this type of DataSet");
    }

    @Override
    public String removeDataLabel(int index) {
        throw new UnsupportedOperationException("Removing data labels is not supported for this type of DataSet");
    }

    public CircularDoubleErrorDataSet reset() {
        this.lock().writeLockGuard(() -> {
            this.xValues.reset();
            this.yValues.reset();
            this.yErrorsNeg.reset();
            this.yErrorsPos.reset();
            this.dataLabels.reset();
            this.dataStyles.reset();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (CircularDoubleErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }
}

