/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.locks;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.locks.DataSetLock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;

public class DefaultDataSetLock<D extends DataSet>
implements DataSetLock<D> {
    private static final long serialVersionUID = 1L;
    private final transient StampedLock stampedLock = new StampedLock();
    private final AtomicLong lastReadStamp = new AtomicLong(-1L);
    private final AtomicLong lastWriteStamp = new AtomicLong(-1L);
    private final AtomicLong writerLockedByThreadId = new AtomicLong(-1L);
    private final AtomicInteger readerCount = new AtomicInteger(0);
    private final AtomicInteger writerCount = new AtomicInteger(0);
    private final transient AtomicBoolean autoNotifyState = new AtomicBoolean(true);
    private final transient D dataSet;

    public DefaultDataSetLock(D dataSet) {
        this.dataSet = dataSet;
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet must not be null");
        }
    }

    @Deprecated(since="still under test")
    public D downGradeWriteLock() {
        if (!this.stampedLock.isWriteLocked()) {
            throw new IllegalStateException("cannot down-convert lock - lock is not write locked");
        }
        if (this.getWriterCount() > 1) {
            throw new IllegalStateException("cannot down-convert lock - holding n write locks = " + this.getWriterCount());
        }
        long result = this.stampedLock.tryConvertToReadLock(this.lastWriteStamp.get());
        if (result == 0L) {
            throw new IllegalStateException("cannot down-convert lock - tryConvertToReadLock return '0'");
        }
        this.readerCount.incrementAndGet();
        this.writerCount.decrementAndGet();
        if (this.lastReadStamp.get() == 0L && this.stampedLock.isReadLocked() && this.readerCount.get() > 1) {
            this.stampedLock.unlockRead(this.lastReadStamp.get());
        }
        this.lastReadStamp.set(result);
        return this.dataSet;
    }

    public int getReaderCount() {
        return this.readerCount.get();
    }

    public int getWriterCount() {
        return this.writerCount.get();
    }

    @Override
    public D readLock() {
        long stamp;
        if (this.lastReadStamp.get() == -1L && this.readerCount.get() == 0 && this.lastReadStamp.compareAndExchange(-1L, stamp = this.stampedLock.readLock()) != -1L) {
            this.stampedLock.unlockRead(stamp);
        }
        this.readerCount.getAndIncrement();
        return this.dataSet;
    }

    @Override
    public D readLockGuard(Runnable reading) {
        this.readLock();
        try {
            reading.run();
        }
        finally {
            this.readUnLock();
        }
        return this.dataSet;
    }

    @Override
    public <R> R readLockGuard(Supplier<R> reading) {
        R result;
        this.readLock();
        try {
            result = reading.get();
        }
        finally {
            this.readUnLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D readLockGuardOptimistic(Runnable reading) {
        long stamp = this.stampedLock.tryOptimisticRead();
        reading.run();
        if (this.stampedLock.validate(stamp)) {
            return this.dataSet;
        }
        this.readLock();
        try {
            reading.run();
        }
        finally {
            this.readUnLock();
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R readLockGuardOptimistic(Supplier<R> reading) {
        R result = reading.get();
        long stamp = this.stampedLock.tryOptimisticRead();
        if (this.stampedLock.validate(stamp)) {
            return result;
        }
        this.readLock();
        try {
            result = reading.get();
        }
        finally {
            this.readUnLock();
        }
        return result;
    }

    @Override
    public D readUnLock() {
        long lastReadStampLocal;
        if (this.readerCount.get() == 1 && this.lastReadStamp.get() != -1L && this.lastReadStamp.compareAndExchange(lastReadStampLocal = this.lastReadStamp.get(), -1L) == lastReadStampLocal) {
            this.stampedLock.unlockRead(lastReadStampLocal);
        }
        if (this.readerCount.decrementAndGet() < 0) {
            throw new IllegalStateException("read lock/unlock mismatch - already unlocked");
        }
        return this.dataSet;
    }

    @Override
    public D writeLock() {
        long callingThreadId = Thread.currentThread().getId();
        if (this.writerLockedByThreadId.get() != callingThreadId) {
            long stamp;
            while ((stamp = this.stampedLock.writeLock()) == 0L) {
            }
            this.writerLockedByThreadId.set(callingThreadId);
            this.lastWriteStamp.set(stamp);
            this.autoNotifyState.set(this.dataSet.autoNotification().getAndSet(false));
        }
        this.writerCount.incrementAndGet();
        return this.dataSet;
    }

    @Override
    public D writeLockGuard(Runnable writing) {
        this.writeLock();
        boolean oldAutoNotificationState = this.dataSet.autoNotification().getAndSet(false);
        try {
            writing.run();
        }
        finally {
            this.dataSet.autoNotification().set(oldAutoNotificationState);
            this.writeUnLock();
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R writeLockGuard(Supplier<R> writing) {
        R result;
        this.writeLock();
        boolean oldAutoNotificationState = this.dataSet.autoNotification().getAndSet(false);
        try {
            result = writing.get();
        }
        finally {
            this.dataSet.autoNotification().set(oldAutoNotificationState);
            this.writeUnLock();
        }
        return result;
    }

    @Override
    public D writeUnLock() {
        if (this.writerCount.decrementAndGet() == 0) {
            long callingThreadId = Thread.currentThread().getId();
            if (this.writerLockedByThreadId.get() != callingThreadId) {
                throw new IllegalStateException("unlock attempt by tid = " + callingThreadId + " (" + Thread.currentThread() + ") - but locked by " + this.writerLockedByThreadId.get());
            }
            this.dataSet.autoNotification().set(this.autoNotifyState.get());
            this.writerLockedByThreadId.set(-1L);
            this.stampedLock.unlockWrite(this.lastWriteStamp.getAndSet(-1L));
        }
        return this.dataSet;
    }
}

