/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.remote;

import de.gsi.dataset.remote.Data;
import de.gsi.dataset.remote.MimeType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DataContainer
implements Serializable {
    private static final long serialVersionUID = -4443375672892579564L;
    private String selector;
    private final String exportName;
    private final String category;
    private final long updatePeriod;
    private final List<Data> data;
    private String rbacToken;
    private final long timeStampCreation;
    private long timeStampLastAccess;

    public DataContainer(String exportNameData, long updatePeriod, byte[] imageByteArray, int imageByteArraySize) {
        this(DataContainer.genExportName(exportNameData), DataContainer.getCategory(exportNameData), updatePeriod, new Data(DataContainer.genExportNameData(exportNameData), MimeType.getEnumByFileName(exportNameData).toString(), imageByteArray, imageByteArraySize));
    }

    public DataContainer(String exportName, String category, long updatePeriod, Data ... data) {
        this.exportName = DataContainer.checkField("exportName", exportName);
        this.category = DataContainer.fixPreAndPost(DataContainer.checkField("category", category));
        this.updatePeriod = updatePeriod;
        this.data = List.of(data);
        this.timeStampLastAccess = this.timeStampCreation = System.currentTimeMillis();
    }

    public String getCategory() {
        this.updateAccess();
        return this.category;
    }

    public List<Data> getData() {
        this.updateAccess();
        return this.data;
    }

    public byte[] getDataByteArray() {
        return this.getData().get(0).getDataByteArray();
    }

    public int getDataByteArraySize() {
        return this.getData().get(0).getDataByteArraySize();
    }

    public String getExportName() {
        return this.exportName;
    }

    public String getExportNameData() {
        return this.getData().get(0).getExportNameData();
    }

    public String getMimeType() {
        return this.getData().get(0).getMimeType();
    }

    public String getRbacToken() {
        return this.rbacToken;
    }

    public String getSelector() {
        return this.selector;
    }

    public long getTimeStampCreation() {
        return this.timeStampCreation;
    }

    public String getTimeStampCreationString() {
        TimeZone utcTz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.UK);
        formatter.setTimeZone(utcTz);
        return formatter.format(new Date(this.timeStampCreation));
    }

    public long getTimeStampLastAccess() {
        return this.timeStampLastAccess;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setRbacToken(String rbacToken) {
        this.updateAccess();
        this.rbacToken = rbacToken;
    }

    public void setSelector(String selector) {
        this.updateAccess();
        this.selector = selector;
    }

    public void updateAccess() {
        this.timeStampLastAccess = System.currentTimeMillis();
    }

    protected static String fixPreAndPost(String name) {
        String nonNullName = name == null ? "/" : name.trim();
        Object fixedPrefix = nonNullName.startsWith("/") ? nonNullName : "/" + nonNullName;
        return ((String)fixedPrefix).endsWith("/") ? fixedPrefix : (String)fixedPrefix + "/";
    }

    protected static String genExportName(String name) {
        int e;
        DataContainer.checkField("genExportName(name)", name);
        int p = name.lastIndexOf(47);
        if (p < 0) {
            p = 0;
        }
        if ((e = name.lastIndexOf(46)) < 0) {
            e = name.length();
        }
        return name.substring(p, e).replace("/", "");
    }

    protected static String genExportNameData(String name) {
        DataContainer.checkField("genExportNameData(name)", name);
        int p = name.lastIndexOf(47);
        if (p < 0) {
            p = 0;
        }
        return name.substring(p).replace("/", "");
    }

    protected static String getCategory(String name) {
        DataContainer.checkField("getCategory(name)", name);
        int p = name.lastIndexOf(47);
        if (p < 0) {
            return DataContainer.fixPreAndPost("");
        }
        return DataContainer.fixPreAndPost(name.substring(0, p + 1));
    }

    private static String checkField(String field, String category) {
        if (category == null) {
            throw new IllegalArgumentException(field + "category not be null");
        }
        if (category.isBlank()) {
            throw new IllegalArgumentException(field + "must not be blank");
        }
        return category;
    }
}

