/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class FragmentedDataSet
extends AbstractDataSet<FragmentedDataSet>
implements DataSet2D {
    private static final long serialVersionUID = 2540953806461866839L;
    protected int dataCount;
    protected final ArrayList<DataSet> list = new ArrayList();

    public FragmentedDataSet(String name) {
        super(name, 2);
    }

    public void add(DataSet set) {
        this.lock().writeLockGuard(() -> {
            this.list.add(set);
            this.list.sort(Comparator.comparingDouble(o -> o.getAxisDescription(0).getMin()));
            this.dataCount += set.getDataCount();
            this.getAxisDescription(0).add(set.getAxisDescription(0).getMax());
            this.getAxisDescription(0).add(set.getAxisDescription(0).getMin());
            this.getAxisDescription(1).add(set.getAxisDescription(1).getMax());
            this.getAxisDescription(1).add(set.getAxisDescription(1).getMin());
        });
        this.fireInvalidated(new AddedDataEvent(this, "added data set"));
    }

    public void add(double[] xValues, double[] yValues) {
        DoubleDataSet set = new DoubleDataSet(String.format("Fragment #%d", this.list.size() + 1), xValues, yValues, xValues.length, false);
        this.add(set);
    }

    public void clear() {
        this.lock().writeLockGuard(() -> {
            this.dataCount = 0;
            this.list.clear();
            this.fireInvalidated(new UpdatedDataEvent(this, "clear()"));
        });
    }

    @Override
    public int getDataCount() {
        return this.dataCount;
    }

    public int getDatasetCount() {
        return this.list.size();
    }

    public Collection<DataSet> getDatasets() {
        return this.list;
    }

    @Override
    public String getStyle(int i) {
        for (DataSet dataset : this.list) {
            if (i < dataset.getDataCount()) {
                return dataset.getStyle(i);
            }
            i -= dataset.getDataCount();
        }
        return "";
    }

    @Override
    public double get(int dimIndex, int index) {
        int i = index;
        for (DataSet dataset : this.list) {
            if (i < dataset.getDataCount()) {
                return dataset.get(dimIndex, i);
            }
            i -= dataset.getDataCount();
        }
        return Double.NaN;
    }

    @Override
    public double[] getValues(int dimIndex) {
        return this.lock().readLockGuard(() -> {
            double[] tmp = new double[this.dataCount];
            int index = 0;
            for (DataSet dataset : this.list) {
                for (int i = 0; i < dataset.getDataCount(); ++i) {
                    tmp[index++] = dataset.get(dimIndex, i);
                }
            }
            return tmp;
        });
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            this.clear();
            this.add(other);
            this.copyMetaData(other);
            this.copyDataLabelsAndStyles(other, copy);
            this.copyAxisDescription(other);
        }));
        return this.fireInvalidated(new UpdatedDataEvent(this, "set(DataSet, boolean=" + copy + ")"));
    }
}

