/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.financial.api.attrs;

import de.gsi.dataset.spi.financial.api.attrs.AttributeKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AttributeModel
implements Cloneable {
    private Map<AttributeKey<?>, Object> attributes;

    public AttributeModel() {
        this.attributes = new LinkedHashMap();
    }

    public AttributeModel(Map<AttributeKey<?>, Object> attributes) {
        this.attributes = attributes;
    }

    public static AttributeModel configure() {
        return new AttributeModel();
    }

    public static AttributeModel configure(AttributeModel template) {
        return template.deepCopyAttributes();
    }

    public <T> T getAttribute(AttributeKey<T> key) {
        return (T)this.attributes.get(key);
    }

    public <T> T getRequiredAttribute(AttributeKey<T> key) {
        T value = this.getAttribute(key);
        if (value == null) {
            throw new IllegalArgumentException("The attribute " + key + " is required!");
        }
        return value;
    }

    public <T> T getAttribute(AttributeKey<T> key, T defaultValue) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T> T getAttributeAndSet(AttributeKey<T> key, T defaultValue) {
        Object value = this.attributes.get(key);
        if (value == null) {
            this.setAttribute(key, defaultValue);
            return defaultValue;
        }
        return (T)value;
    }

    public <T, E extends T> E getAttribute(AttributeKey<T> key, Class<E> clazz) {
        Object value = this.attributes.get(key);
        return (E)value;
    }

    public <T, E extends T> E getAttribute(AttributeKey<T> key, Class<E> clazz, E defaultValue) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (E)value;
    }

    public <T> AttributeModel setAttribute(AttributeKey<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("The attribute key hasn't be null");
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    public boolean containsAttribute(AttributeKey<?> key) {
        return this.attributes.containsKey(key);
    }

    public Set<AttributeKey<?>> getAttributes() {
        return this.attributes.keySet();
    }

    public synchronized void merge(AttributeModel model) {
        AttributeModel copiedModel = (AttributeModel)model.clone();
        for (AttributeKey<?> attributeKey : copiedModel.getAttributes()) {
            if (AttributeModel.class.isAssignableFrom(attributeKey.getType())) {
                AttributeModel attributeModel = (AttributeModel)copiedModel.getAttribute(attributeKey);
                attributeModel = attributeModel.deepCopyAttributes();
                this.setAttribute(attributeKey, attributeModel);
                continue;
            }
            this.setAttribute(attributeKey, copiedModel.getAttribute(attributeKey));
        }
    }

    public synchronized AttributeModel deepCopyAttributes() {
        AttributeModel copiedModel = (AttributeModel)this.clone();
        for (AttributeKey<?> attributeKey : new HashSet(copiedModel.getAttributes())) {
            if (!AttributeModel.class.isAssignableFrom(attributeKey.getType())) continue;
            AttributeModel attributeModel = (AttributeModel)copiedModel.getAttribute(attributeKey);
            attributeModel = attributeModel.deepCopyAttributes();
            copiedModel.setAttribute(attributeKey, attributeModel);
        }
        return copiedModel;
    }

    public Object clone() {
        try {
            AttributeModel model = (AttributeModel)super.clone();
            model.attributes = (HashMap)((HashMap)this.attributes).clone();
            return model;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "AttributeModel [attributes=" + this.attributes + "]";
    }
}

