/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.AbstractStylable;
import de.gsi.dataset.spi.DataRange;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSet<D extends AbstractStylable<D>>
extends AbstractStylable<D>
implements DataSet,
DataSetMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSet.class);
    protected String name;
    protected final List<EventListener> updateListeners = new LinkedList<EventListener>();
    protected final ReentrantLock lock = new ReentrantLock();
    boolean autoNotification = true;
    protected DataRange xRange = new DataRange();
    protected DataRange yRange = new DataRange();
    private final Map<String, String> metaInfoMap = new ConcurrentHashMap<String, String>();

    public AbstractDataSet(String name) {
        this.name = name;
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public D lock() {
        this.lock.lock();
        return (D)this.getThis();
    }

    public D unlock() {
        this.lock.unlock();
        return (D)this.getThis();
    }

    @Override
    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    public D setAutoNotifaction(boolean flag) {
        this.autoNotification = flag;
        return (D)this.getThis();
    }

    @Override
    public boolean isAutoNotification() {
        return this.autoNotification;
    }

    @Override
    public Double getUndefValue() {
        return Double.NaN;
    }

    @Override
    public double getXMin() {
        if (!this.getXRange().isDefined()) {
            this.computeLimits();
        }
        return this.getXRange().getMin();
    }

    @Override
    public double getXMax() {
        if (!this.getXRange().isDefined()) {
            this.computeLimits();
        }
        return this.getXRange().getMax();
    }

    @Override
    public double getYMin() {
        if (!this.getYRange().isDefined()) {
            this.computeLimits();
        }
        return this.getYRange().getMin();
    }

    @Override
    public double getYMax() {
        if (!this.getYRange().isDefined()) {
            this.computeLimits();
        }
        return this.getYRange().getMax();
    }

    public DataRange getXRange() {
        if (!this.xRange.isDefined()) {
            this.computeLimits();
        }
        return this.xRange;
    }

    public DataRange getYRange() {
        if (!this.yRange.isDefined()) {
            this.computeLimits();
        }
        return this.yRange;
    }

    protected D computeLimits() {
        this.lock();
        this.xRange.empty();
        this.yRange.empty();
        int dataCount = this.getDataCount();
        for (int i = 0; i < dataCount; ++i) {
            this.xRange.add(this.getX(i));
            this.yRange.add(this.getY(i));
        }
        return (D)this.unlock();
    }

    @Override
    public int getDataCount(double xmin, double xmax) {
        this.lock();
        int count = 0;
        for (int i = 0; i < this.getDataCount(); ++i) {
            double x = this.getX(i);
            if (!(x >= xmin) || !(x <= xmax)) continue;
            ++count;
        }
        this.unlock();
        return count;
    }

    @Override
    public int getXIndex(double x) {
        if (this.getDataCount() == 0) {
            return 0;
        }
        if (!Double.isFinite(x)) {
            return 0;
        }
        if (x < this.getXMin()) {
            return 0;
        }
        int lastIndex = this.getDataCount() - 1;
        if (x > this.getXMax()) {
            return lastIndex;
        }
        return this.binarySearchX(x, 0, lastIndex);
    }

    @Override
    public int getYIndex(double y) {
        if (this.getDataCount() == 0) {
            return 0;
        }
        boolean startedAbove = y < this.getY(0);
        for (int i = 0; i < this.getDataCount(); ++i) {
            double val = this.getY(i);
            if (!Double.isFinite(val) || !(startedAbove ? val <= y : val >= y)) continue;
            return i;
        }
        return this.getDataCount() - 1;
    }

    protected int binarySearchX(double search, int indexMin, int indexMax) {
        if (indexMin == indexMax) {
            return indexMin;
        }
        if (indexMax - indexMin == 1) {
            if (Math.abs(this.getX(indexMin) - search) < Math.abs(this.getX(indexMax) - search)) {
                return indexMin;
            }
            return indexMax;
        }
        int middle = (indexMax + indexMin) / 2;
        double valMiddle = this.getX(middle);
        if (valMiddle == search) {
            return middle;
        }
        if (search < valMiddle) {
            return this.binarySearchX(search, indexMin, middle);
        }
        return this.binarySearchX(search, middle, indexMax);
    }

    protected int binarySearchY(double search, int indexMin, int indexMax) {
        if (indexMin == indexMax) {
            return indexMin;
        }
        if (indexMax - indexMin == 1) {
            if (Math.abs(this.getY(indexMin) - search) < Math.abs(this.getY(indexMax) - search)) {
                return indexMin;
            }
            return indexMax;
        }
        int middle = (indexMax + indexMin) / 2;
        double valMiddle = this.getY(middle);
        if (valMiddle == search) {
            return middle;
        }
        if (search < valMiddle) {
            return this.binarySearchY(search, indexMin, middle);
        }
        return this.binarySearchY(search, middle, indexMax);
    }

    protected int minNeigbourSearchX(double search, int indexMin, int indexMax) {
        double b;
        double minAbsDiff = Double.MAX_VALUE;
        int searchIndex = indexMin;
        double a = this.getX(indexMin);
        String eq = a < (b = this.getX(indexMax)) ? " < " : " > ";
        LOGGER.error("- new searchIndex  getX(indexMin)= " + a + eq + " getX(indexMax)= " + b);
        for (int i = indexMin; i <= indexMax; ++i) {
            double valX = this.getX(i);
            if (!Double.isFinite(valX)) {
                LOGGER.error("non-finite value - autsch = " + valX + " index = " + i);
                throw new IllegalStateException("check");
            }
            double absDiff = Math.abs(search - valX);
            if (!Double.isFinite(absDiff) || !(absDiff < minAbsDiff)) continue;
            searchIndex = i;
            minAbsDiff = absDiff;
        }
        LOGGER.error("- new searchIndex Range = " + indexMin + " for " + indexMax);
        LOGGER.error("- new searchIndex = " + searchIndex + " for " + minAbsDiff);
        return searchIndex;
    }

    public D fireInvalidated(UpdateEvent event) {
        if (!this.autoNotification || this.updateEventListener().isEmpty()) {
            return (D)this.getThis();
        }
        if (!this.xRange.isDefined() || !this.yRange.isDefined()) {
            this.computeLimits();
        }
        if (Platform.isFxApplicationThread()) {
            this.invokeListener(event);
        } else {
            Platform.runLater(() -> this.invokeListener(event));
        }
        return (D)this.getThis();
    }

    @Override
    public String getDataLabel(int index) {
        return this.getName() + "(" + index + "," + this.getX(index) + "," + this.getY(index) + ")";
    }

    public String toString() {
        return this.getClass().getName() + " [dataCnt=" + this.getDataCount() + ", xRange=" + this.getXRange() + ", yRange=" + this.getYRange() + "]";
    }

    @Override
    public Map<String, String> getMetaInfo() {
        return this.metaInfoMap;
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getWarningList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }
}

