/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.spi.AbstractDataSet;

public abstract class AbstractErrorDataSet<D extends AbstractDataSet<D>>
extends AbstractDataSet<D>
implements DataSetError {
    private DataSetError.ErrorType errorType = DataSetError.ErrorType.NO_ERROR;

    protected AbstractErrorDataSet(String name) {
        super(name);
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    @Override
    public DataSetError.ErrorType getErrorType() {
        return this.errorType;
    }

    public D setErrorType(DataSetError.ErrorType errorType) {
        this.errorType = errorType;
        return (D)this.getThis();
    }

    @Override
    protected D computeLimits() {
        this.lock();
        this.xRange.empty();
        this.yRange.empty();
        int dataCount = this.getDataCount();
        switch (this.getErrorType()) {
            case NO_ERROR: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    this.xRange.add(xData);
                    this.yRange.add(yData);
                }
                break;
            }
            case X: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    double xDataError = this.getXErrorPositive(i);
                    this.xRange.add(xData - xDataError);
                    this.xRange.add(xData + xDataError);
                    this.yRange.add(yData);
                }
                break;
            }
            case Y: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    double yDataError = this.getYErrorPositive(i);
                    this.xRange.add(xData);
                    this.yRange.add(yData - yDataError);
                    this.yRange.add(yData + yDataError);
                }
                break;
            }
            case XY: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    double xDataError = this.getXErrorPositive(i);
                    double yDataError = this.getYErrorPositive(i);
                    this.xRange.add(xData - xDataError);
                    this.xRange.add(xData + xDataError);
                    this.yRange.add(yData - yDataError);
                    this.yRange.add(yData + yDataError);
                }
                break;
            }
            case X_ASYMMETRIC: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    this.xRange.add(xData - this.getXErrorNegative(i));
                    this.xRange.add(xData + this.getXErrorPositive(i));
                    this.yRange.add(yData);
                }
                break;
            }
            case Y_ASYMMETRIC: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    this.xRange.add(xData);
                    this.yRange.add(yData - this.getYErrorNegative(i));
                    this.yRange.add(yData + this.getYErrorPositive(i));
                }
                break;
            }
            default: {
                for (int i = 0; i < dataCount; ++i) {
                    double xData = this.getX(i);
                    double yData = this.getY(i);
                    this.xRange.add(xData - this.getXErrorNegative(i));
                    this.xRange.add(xData + this.getXErrorPositive(i));
                    this.yRange.add(yData - this.getYErrorNegative(i));
                    this.yRange.add(yData + this.getYErrorPositive(i));
                }
            }
        }
        this.unlock();
        return (D)this.getThis();
    }
}

