/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import java.util.Objects;

public class DataRange
implements Cloneable {
    private static final double MIN_VALUE = -1.7976931348623157E308;
    private static final double MAX_VALUE = Double.MAX_VALUE;
    protected double min = 0.0;
    protected double max = 0.0;

    public DataRange() {
        this(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public DataRange(double min, double max) {
        this.set(min, max);
    }

    public DataRange(DataRange range) {
        this.set(range.min, range.max);
    }

    public boolean isDefined() {
        return this.isMinDefined() && this.isMaxDefined();
    }

    public boolean isMinDefined() {
        return this.min < Double.MAX_VALUE;
    }

    public boolean isMaxDefined() {
        return this.max > -1.7976931348623157E308;
    }

    public double getMax() {
        if (this.isMaxDefined()) {
            return this.max;
        }
        return Double.NaN;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        if (this.isMinDefined()) {
            return this.min;
        }
        return Double.NaN;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void set(DataRange range) {
        this.set(range.min, range.max);
    }

    public void set(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getLength() {
        if (this.isDefined()) {
            return this.max - this.min;
        }
        return 0.0;
    }

    public boolean add(double value) {
        if (!Double.isFinite(value)) {
            return false;
        }
        boolean retVal = false;
        if (value < this.min) {
            this.min = value;
            retVal = true;
        }
        if (value > this.max) {
            this.max = value;
            retVal = true;
        }
        return retVal;
    }

    public void add(DataRange range) {
        this.add(range.min);
        this.add(range.max);
    }

    public DataRange substract(DataRange range) {
        if (range.min > this.max || range.max < this.min) {
            return range;
        }
        return new DataRange(this.min, range.max);
    }

    public void expand(double value) {
        if (!this.isDefined()) {
            throw new UnsupportedOperationException("Cannot expand not defined data range!");
        }
        this.add(this.getMin() - value / 2.0);
        this.add(this.getMax() + value / 2.0);
    }

    public void empty() {
        this.set(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public boolean contains(double value) {
        return this.isDefined() && value <= this.max && value >= this.min;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataRange)) {
            return false;
        }
        DataRange range = (DataRange)obj;
        return range.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataRange [min=");
        if (this.isMinDefined()) {
            sb.append(this.getMin());
        } else {
            sb.append("NotDefined");
        }
        sb.append(", max=");
        if (this.isMaxDefined()) {
            sb.append(this.getMax());
        } else {
            sb.append("NotDefined");
        }
        sb.append("]");
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

