/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDataSet
extends AbstractDataSet<DefaultDataSet>
implements DataSet {
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected ArrayList<DoublePoint> data = new ArrayList();

    public DefaultDataSet(String name) {
        super(name);
    }

    public DefaultDataSet(String name, double[] yValues) {
        this(name);
        AssertUtils.notNull("Y data", yValues);
        Integer i = 0;
        while (i < yValues.length) {
            this.data.add(new DoublePoint((double)i, yValues[i]));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public DefaultDataSet(String name, double[] xValues, double[] yValues) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        Integer i = 0;
        while (i < yValues.length) {
            this.data.add(new DoublePoint(xValues[i], yValues[i]));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public DefaultDataSet(String name, List<DoublePoint> values) {
        this(name);
        AssertUtils.notNull("values", values);
        this.data.clear();
        this.data.addAll(values);
    }

    public Map<Integer, String> getDataLabelMap() {
        return this.dataLabels;
    }

    public Map<Integer, String> getDataStyleMap() {
        return this.dataStyles;
    }

    public List<DoublePoint> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    public DefaultDataSet clearData() {
        ((DefaultDataSet)this.lock()).setAutoNotifaction(false);
        this.data.clear();
        this.xRange.empty();
        this.yRange.empty();
        return (DefaultDataSet)((DefaultDataSet)((DefaultDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public double getX(int index) {
        return this.data.get(index).getX();
    }

    @Override
    public double getY(int index) {
        return this.data.get(index).getY();
    }

    public DefaultDataSet set(List<DoublePoint> values) {
        AssertUtils.notNull("values", values);
        ((DefaultDataSet)this.lock()).setAutoNotifaction(false);
        this.data.clear();
        this.data.addAll(values);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        return (DefaultDataSet)((DefaultDataSet)((DefaultDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DefaultDataSet set(int index, double x, double y) {
        this.lock();
        AssertUtils.indexInBounds(index, this.getDataCount());
        this.data.get(index).set(x, y);
        this.xRange.add(x);
        this.yRange.add(y);
        return (DefaultDataSet)((DefaultDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DefaultDataSet add(double x, double y) {
        this.lock();
        this.data.add(new DoublePoint(x, y));
        this.xRange.add(x);
        this.yRange.add(y);
        return (DefaultDataSet)((DefaultDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DefaultDataSet remove(int fromIndex, int toIndex) {
        ((DefaultDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.data.subList(fromIndex, toIndex).clear();
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        return (DefaultDataSet)((DefaultDataSet)((DefaultDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    public DefaultDataSet remove(int[] indices) {
        this.lock();
        this.setAutoNotifaction(false);
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return (DefaultDataSet)this.unlock();
        }
        ArrayList<DoublePoint> tupleTobeRemovedReferences = new ArrayList<DoublePoint>();
        for (int indexToRemove : indices) {
            tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
        }
        this.data.removeAll(tupleTobeRemovedReferences);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        super.computeLimits();
        return (DefaultDataSet)((DefaultDataSet)((DefaultDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DefaultDataSet add(double[] xValues, double[] yValues) {
        ((DefaultDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        this.data.clear();
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        for (int i = 0; i < xValues.length; ++i) {
            this.data.add(new DoublePoint(xValues[i], yValues[i]));
            this.xRange.add(xValues[i]);
            this.yRange.add(yValues[i]);
        }
        return (DefaultDataSet)((DefaultDataSet)((DefaultDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public String addDataLabel(int index, String label) {
        String retVal = this.dataLabels.put(index, label);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    public String removeDataLabel(int index) {
        String retVal = this.dataLabels.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    public String addDataStyle(int index, String style) {
        String retVal = this.dataStyles.put(index, style);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    public String removeStyle(int index) {
        String retVal = this.dataStyles.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }
}

