/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.spi.utils.DoublePointError;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultErrorDataSet
extends AbstractErrorDataSet<DefaultErrorDataSet>
implements DataSetError {
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected ArrayList<DoublePointError> data = new ArrayList();

    public DefaultErrorDataSet(String name) {
        super(name);
        this.setErrorType(DataSetError.ErrorType.XY);
    }

    public DefaultErrorDataSet(String name, double[] yValues) {
        this(name);
        AssertUtils.notNull("Y data", yValues);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(i, yValues[i], 0.0, 0.0));
        }
    }

    public DefaultErrorDataSet(String name, double[] xValues, double[] yValues) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(xValues[i], yValues[i], 0.0, 0.0));
        }
    }

    public DefaultErrorDataSet(String name, double[] xValues, double[] yValues, double[] xErrors, double[] yErrors) {
        super(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("X error data", xErrors);
        AssertUtils.notNull("Y error data", yErrors);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        AssertUtils.equalDoubleArrays(xValues, xErrors);
        AssertUtils.equalDoubleArrays(xValues, yErrors);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(xValues[i], yValues[i], xErrors[i], yErrors[i]));
        }
    }

    public DefaultErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrors) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error data", yErrors);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        AssertUtils.equalDoubleArrays(xValues, yErrors);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(xValues[i], yValues[i], 0.0, yErrors[i]));
        }
    }

    public Map<Integer, String> getDataLabelMap() {
        return this.dataLabels;
    }

    public Map<Integer, String> getDataStyleMap() {
        return this.dataStyles;
    }

    public List<DoublePointError> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public double getX(int i) {
        return this.data.get(i).getX();
    }

    @Override
    public double getY(int i) {
        return this.data.get(i).getY();
    }

    @Override
    public double getXErrorNegative(int index) {
        return this.data.get(index).getErrorX();
    }

    @Override
    public double getXErrorPositive(int index) {
        return this.data.get(index).getErrorX();
    }

    @Override
    public double getYErrorNegative(int index) {
        return this.data.get(index).getErrorY();
    }

    @Override
    public double getYErrorPositive(int index) {
        return this.data.get(index).getErrorY();
    }

    public DefaultErrorDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    public DefaultErrorDataSet clearData() {
        ((DefaultErrorDataSet)this.lock()).setAutoNotifaction(false);
        this.data.clear();
        this.xRange.empty();
        this.yRange.empty();
        return (DefaultErrorDataSet)((DefaultErrorDataSet)((DefaultErrorDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    public DefaultErrorDataSet set(int index, double x, double y, double dx, double dy) {
        this.lock();
        this.data.get(index).set(x, y, dy, dy);
        this.xRange.add(x - dx);
        this.xRange.add(x + dx);
        this.yRange.add(y - dy);
        this.yRange.add(y + dy);
        return (DefaultErrorDataSet)((DefaultErrorDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DefaultErrorDataSet set(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors, int count) {
        ((DefaultErrorDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        if (xValues.length < count || yValues.length < count || xErrors.length < count || yErrors.length < count) {
            throw new IllegalArgumentException("Arrays with coordinates must have length >= count!");
        }
        for (int i = 0; i < xValues.length; ++i) {
            double x = xValues[i];
            double y = yValues[i];
            double dx = xErrors[i];
            double dy = yValues[i];
            this.xRange.add(x - dx);
            this.xRange.add(x + dx);
            this.yRange.add(y - dy);
            this.yRange.add(y + dy);
            this.data.add(new DoublePointError(x, y, dx, dy));
        }
        return (DefaultErrorDataSet)((DefaultErrorDataSet)((DefaultErrorDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DefaultErrorDataSet set(double[] xValues, double[] yValues, int count) {
        return this.set(xValues, yValues, new double[count], new double[count], count);
    }

    public DefaultErrorDataSet set(double[] xValues, double[] yValues, double[] yErrors, int count) {
        return this.set(xValues, yValues, new double[count], yErrors, count);
    }

    public DefaultErrorDataSet set(double[] xValues, double[] yValues) {
        int ndim = xValues.length;
        return this.set(xValues, yValues, new double[ndim], new double[ndim], ndim);
    }

    public DefaultErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0);
    }

    public DefaultErrorDataSet add(double x, double y, double ex, double ey) {
        this.lock();
        this.data.add(new DoublePointError(x, y, ex, ey));
        this.xRange.add(x - ex);
        this.xRange.add(x + ex);
        this.yRange.add(y - ey);
        this.yRange.add(y + ey);
        return (DefaultErrorDataSet)((DefaultErrorDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DefaultErrorDataSet add(double[] xValues, double[] yValues) {
        return this.add(xValues, yValues, new double[yValues.length], new double[yValues.length]);
    }

    public DefaultErrorDataSet add(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors) {
        ((DefaultErrorDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("X error data", xErrors);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error data", yValues);
        for (int i = 0; i < xValues.length; ++i) {
            double x = xValues[i];
            double y = yValues[i];
            double ex = xErrors[i];
            double ey = yErrors[i];
            this.data.add(new DoublePointError(x, y, ex, ey));
            this.xRange.add(x - ex);
            this.xRange.add(x + ex);
            this.yRange.add(y - ey);
            this.yRange.add(y + ey);
        }
        return (DefaultErrorDataSet)((DefaultErrorDataSet)((DefaultErrorDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DefaultErrorDataSet remove(int fromIndex, int toIndex) {
        ((DefaultErrorDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.data.subList(fromIndex, toIndex).clear();
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        return (DefaultErrorDataSet)((DefaultErrorDataSet)((DefaultErrorDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    public DefaultErrorDataSet remove(int[] indices) {
        ((DefaultErrorDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return (DefaultErrorDataSet)this.unlock();
        }
        ArrayList<DoublePointError> tupleTobeRemovedReferences = new ArrayList<DoublePointError>();
        for (int indexToRemove : indices) {
            tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
        }
        this.data.removeAll(tupleTobeRemovedReferences);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        super.computeLimits();
        return (DefaultErrorDataSet)((DefaultErrorDataSet)((DefaultErrorDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    public String addDataLabel(int index, String label) {
        String retVal = this.dataLabels.put(index, label);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    public String removeDataLabel(int index) {
        String retVal = this.dataLabels.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    public String addDataStyle(int index, String style) {
        String retVal = this.dataStyles.put(index, style);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    public String removeStyle(int index) {
        String retVal = this.dataStyles.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }
}

