/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DoubleDataSet
extends AbstractDataSet<DoubleDataSet>
implements EditableDataSet {
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected EditConstraints editConstraints;
    protected double[] xValues;
    protected double[] yValues;
    protected int dataMaxIndex;

    public DoubleDataSet(String name) {
        this(name, 0);
    }

    public DoubleDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new double[initalSize];
        this.yValues = new double[initalSize];
        this.dataMaxIndex = 0;
    }

    public DoubleDataSet(String name, double[] yValues) {
        this(name, yValues, true);
    }

    public DoubleDataSet(String name, double[] yValues, boolean copy) {
        super(name);
        AssertUtils.notNull("Y data", yValues);
        if (copy) {
            this.yValues = new double[yValues.length];
            System.arraycopy(yValues, 0, this.yValues, 0, yValues.length);
        } else {
            this.yValues = yValues;
        }
        this.xValues = new double[yValues.length];
        Integer i = 0;
        while (i < yValues.length) {
            this.xValues[i.intValue()] = i.intValue();
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.dataMaxIndex = yValues.length;
    }

    public DoubleDataSet(String name, double[] xValues, double[] yValues) {
        this(name, xValues, yValues, true);
    }

    public DoubleDataSet(String name, double[] xValues, double[] yValues, boolean copy) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        if (copy) {
            this.xValues = new double[yValues.length];
            this.yValues = new double[yValues.length];
            System.arraycopy(xValues, 0, this.xValues, 0, xValues.length);
            System.arraycopy(yValues, 0, this.yValues, 0, yValues.length);
        } else {
            this.xValues = xValues;
            this.yValues = yValues;
        }
        this.dataMaxIndex = xValues.length;
    }

    public Map<Integer, String> getDataLabelMap() {
        return this.dataLabels;
    }

    public Map<Integer, String> getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public double[] getXValues() {
        return this.xValues;
    }

    @Override
    public double[] getYValues() {
        return this.yValues;
    }

    @Override
    public int getDataCount() {
        return Math.min(this.dataMaxIndex, this.xValues.length);
    }

    public DoubleDataSet clearData() {
        this.lock();
        this.dataMaxIndex = 0;
        Arrays.fill(this.xValues, 0.0);
        Arrays.fill(this.yValues, 0.0);
        this.dataLabels.isEmpty();
        this.dataStyles.isEmpty();
        this.xRange.empty();
        this.yRange.empty();
        this.unlock();
        this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
        return this;
    }

    @Override
    public double getX(int index) {
        return this.xValues[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleDataSet set(int index, double x, double y) {
        this.lock();
        try {
            this.xValues[index] = x;
            this.yValues[index] = y;
            this.dataMaxIndex = Math.max(index, this.dataMaxIndex);
            this.xRange.add(x);
            this.yRange.add(y);
        }
        finally {
            this.unlock();
        }
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public DoubleDataSet add(double x, double y) {
        this.add(this.getDataCount(), x, y, null);
        return this;
    }

    public DoubleDataSet add(double x, double y, String label) {
        return this.add(this.getDataCount(), x, y, label);
    }

    @Override
    public DoubleDataSet add(int index, double x, double y) {
        return this.add(index, x, y, null);
    }

    public DoubleDataSet add(int index, double x, double y, String label) {
        this.lock();
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        int minArraySize = Math.min(this.xValues.length - 1, this.yValues.length - 1);
        if (this.dataMaxIndex > minArraySize) {
            double[] xValuesNew = new double[this.dataMaxIndex + 1];
            double[] yValuesNew = new double[this.dataMaxIndex + 1];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, indexAt);
            System.arraycopy(this.yValues, 0, yValuesNew, 0, indexAt);
            System.arraycopy(this.xValues, indexAt, xValuesNew, indexAt + 1, this.xValues.length - indexAt);
            System.arraycopy(this.yValues, indexAt, yValuesNew, indexAt + 1, this.yValues.length - indexAt);
            for (int i = this.xValues.length; i > indexAt; --i) {
                String oldStyleData;
                String oldLabelData = this.dataLabels.get(i);
                if (oldLabelData != null) {
                    this.dataLabels.put(i + 1, oldLabelData);
                    this.dataLabels.remove(i);
                }
                if ((oldStyleData = this.dataStyles.get(i)) == null) continue;
                this.dataStyles.put(i + 1, oldStyleData);
                this.dataStyles.remove(i);
            }
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
        }
        this.xValues[indexAt] = x;
        this.yValues[indexAt] = y;
        if (label != null && !label.isEmpty()) {
            this.addDataLabel(indexAt, label);
        }
        ++this.dataMaxIndex;
        this.xRange.add(x);
        this.yRange.add(y);
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public DoubleDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        int diffLength = toIndex - fromIndex;
        int newLength = this.xValues.length - diffLength;
        double[] xValuesNew = new double[newLength];
        double[] yValuesNew = new double[newLength];
        System.arraycopy(this.xValues, 0, xValuesNew, 0, fromIndex);
        System.arraycopy(this.yValues, 0, yValuesNew, 0, fromIndex);
        System.arraycopy(this.xValues, toIndex, xValuesNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yValues, toIndex, yValuesNew, fromIndex, newLength - fromIndex);
        this.xValues = xValuesNew;
        this.yValues = yValuesNew;
        for (int i = 0; i < diffLength; ++i) {
            String oldStyleData;
            String oldLabelData = this.dataLabels.get(toIndex + i);
            if (oldLabelData != null) {
                this.dataLabels.put(fromIndex + i, oldLabelData);
                this.dataLabels.remove(toIndex + i);
            }
            if ((oldStyleData = this.dataStyles.get(toIndex + i)) == null) continue;
            this.dataStyles.put(fromIndex + i, oldStyleData);
            this.dataStyles.remove(toIndex + i);
        }
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex - diffLength);
        this.xRange.empty();
        this.yRange.empty();
        this.unlock();
        this.fireInvalidated(new RemovedDataEvent(this));
        return this;
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleDataSet add(double[] xValuesNew, double[] yValuesNew) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        int newLength = this.getDataCount() + xValuesNew.length;
        if (newLength > this.xValues.length) {
            double[] xValuesNewAlloc = new double[newLength];
            double[] yValuesNewAlloc = new double[newLength];
            System.arraycopy(this.xValues, 0, xValuesNewAlloc, 0, this.getDataCount());
            System.arraycopy(this.yValues, 0, yValuesNewAlloc, 0, this.getDataCount());
            this.xValues = xValuesNewAlloc;
            this.yValues = yValuesNewAlloc;
        }
        System.arraycopy(xValuesNew, 0, this.xValues, this.getDataCount(), xValuesNew.length);
        System.arraycopy(yValuesNew, 0, this.yValues, this.getDataCount(), xValuesNew.length);
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex + xValuesNew.length);
        this.computeLimits();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public DoubleDataSet set(double[] xValues, double[] yValues, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        if (!copy) {
            this.xValues = xValues;
            this.yValues = yValues;
            this.dataMaxIndex = xValues.length;
            this.unlock();
            this.computeLimits();
            this.fireInvalidated(new UpdatedDataEvent(this));
            return this;
        }
        if (xValues.length == this.xValues.length) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.getDataCount());
            System.arraycopy(yValues, 0, this.yValues, 0, this.getDataCount());
        } else {
            this.xValues = Arrays.copyOf(xValues, xValues.length);
            this.yValues = Arrays.copyOf(yValues, xValues.length);
        }
        this.dataMaxIndex = xValues.length;
        this.unlock();
        this.computeLimits();
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public DoubleDataSet set(double[] xValues, double[] yValues) {
        return this.set(xValues, yValues, true);
    }

    public DoubleDataSet set(DataSet other) {
        return this.set(other, true);
    }

    public DoubleDataSet set(DataSet other, boolean copy) {
        this.set(other.getXValues(), other.getYValues(), copy);
        return this;
    }

    public String addDataLabel(int index, String label) {
        String retVal = this.dataLabels.put(index, label);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    public String removeDataLabel(int index) {
        String retVal = this.dataLabels.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    public String addDataStyle(int index, String style) {
        String retVal = this.dataStyles.put(index, style);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    public String removeStyle(int index) {
        String retVal = this.dataStyles.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }

    @Override
    public EditConstraints getEditConstraints() {
        return this.editConstraints;
    }

    @Override
    public DoubleDataSet setEditConstraints(EditConstraints constraints) {
        this.editConstraints = constraints;
        return this;
    }
}

