/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError {
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected double[] xValues;
    protected double[] yValues;
    protected double[] yErrorsPos;
    protected double[] yErrorsNeg;
    protected int dataMaxIndex;

    public DoubleErrorDataSet(String name) {
        this(name, 0);
    }

    public DoubleErrorDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new double[initalSize];
        this.yValues = new double[initalSize];
        this.yErrorsPos = new double[initalSize];
        this.yErrorsNeg = new double[initalSize];
        this.setErrorType(DataSetError.ErrorType.Y_ASYMMETRIC);
        this.dataMaxIndex = 0;
    }

    public DoubleErrorDataSet(String name, double[] yValues, int nData) {
        this(name, Math.min(yValues.length, nData));
        this.dataMaxIndex = Math.min(yValues.length, nData);
        System.arraycopy(yValues, 0, this.yValues, 0, this.dataMaxIndex);
        Integer i = 0;
        while (i < this.dataMaxIndex) {
            this.xValues[i.intValue()] = i.intValue();
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.computeLimits();
    }

    public DoubleErrorDataSet(String name, double[] yValues) {
        this(name, yValues, yValues.length);
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, int nData) {
        this(name, Math.min(xValues.length, Math.min(yValues.length, nData)));
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        int errorMin = Math.min(this.yErrorsPos.length, this.yErrorsNeg.length);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, this.dataMaxIndex);
        if (this.dataMaxIndex != 0) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.dataMaxIndex);
            System.arraycopy(yValues, 0, this.yValues, 0, this.dataMaxIndex);
        }
        this.computeLimits();
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues) {
        this(name, xValues, yValues, xValues.length);
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int nData) {
        this(name, Math.min(xValues.length, Math.min(yValues.length, nData)));
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        int errorMin = Math.min(Math.min(yErrorsPos.length, yErrorsNeg.length), nData);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, this.dataMaxIndex);
        if (this.dataMaxIndex != 0) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.dataMaxIndex);
            System.arraycopy(yValues, 0, this.yValues, 0, this.dataMaxIndex);
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos, 0, this.dataMaxIndex);
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, 0, this.dataMaxIndex);
        }
        this.computeLimits();
    }

    public Map<Integer, String> getDataLabelMap() {
        return this.dataLabels;
    }

    public Map<Integer, String> getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public double[] getXValues() {
        return this.xValues;
    }

    @Override
    public double[] getYValues() {
        return this.yValues;
    }

    @Override
    public double[] getYErrorsPositive() {
        return this.yErrorsPos;
    }

    @Override
    public double[] getYErrorsNegative() {
        return this.yErrorsNeg;
    }

    @Override
    public int getDataCount() {
        return Math.min(this.dataMaxIndex, this.xValues.length);
    }

    public DoubleErrorDataSet clearData() {
        this.lock();
        this.dataMaxIndex = 0;
        Arrays.fill(this.xValues, 0.0);
        Arrays.fill(this.yValues, 0.0);
        Arrays.fill(this.yErrorsPos, 0.0);
        Arrays.fill(this.yErrorsNeg, 0.0);
        this.dataLabels.isEmpty();
        this.dataStyles.isEmpty();
        this.xRange.empty();
        this.yRange.empty();
        this.unlock();
        this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
        return this;
    }

    @Override
    public double getX(int index) {
        return this.xValues[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues[index];
    }

    @Override
    public double getXErrorNegative(int index) {
        return 0.0;
    }

    @Override
    public double getXErrorPositive(int index) {
        return 0.0;
    }

    @Override
    public double getYErrorNegative(int index) {
        return this.yErrorsNeg[index];
    }

    @Override
    public double getYErrorPositive(int index) {
        return this.yErrorsPos[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleErrorDataSet set(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock();
        try {
            if (index < this.dataMaxIndex) {
                this.xValues[index] = x;
                this.yValues[index] = y;
                this.yErrorsPos[index] = yErrorPos;
                this.yErrorsNeg[index] = yErrorNeg;
            } else {
                this.add(x, y, yErrorNeg, yErrorPos);
            }
            this.xRange.add(x);
            this.yRange.add(y - yErrorNeg);
            this.yRange.add(y + yErrorPos);
        }
        finally {
            this.unlock();
        }
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock();
        if (this.dataMaxIndex > this.xValues.length - 1) {
            double[] xValuesNew = new double[this.xValues.length + 1];
            double[] yValuesNew = new double[this.yValues.length + 1];
            double[] yErrorsNegNew = new double[this.yValues.length + 1];
            double[] yErrorsPosNew = new double[this.yValues.length + 1];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, this.xValues.length);
            System.arraycopy(this.yValues, 0, yValuesNew, 0, this.yValues.length);
            System.arraycopy(this.yErrorsNeg, 0, yErrorsNegNew, 0, this.yValues.length);
            System.arraycopy(this.yErrorsPos, 0, yErrorsPosNew, 0, this.yValues.length);
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
            this.yErrorsPos = yErrorsPosNew;
            this.yErrorsNeg = yErrorsNegNew;
        }
        this.xValues[this.dataMaxIndex] = x;
        this.yValues[this.dataMaxIndex] = y;
        this.yErrorsPos[this.dataMaxIndex] = yErrorPos;
        this.yErrorsNeg[this.dataMaxIndex] = yErrorNeg;
        ++this.dataMaxIndex;
        this.xRange.add(x);
        this.yRange.add(y - yErrorNeg);
        this.yRange.add(y + yErrorPos);
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public DoubleErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        int diffLength = toIndex - fromIndex;
        int newLength = this.xValues.length - diffLength;
        double[] xValuesNew = new double[newLength];
        double[] yValuesNew = new double[newLength];
        double[] yErrorsNegNew = new double[newLength];
        double[] yErrorsPosNew = new double[newLength];
        System.arraycopy(this.xValues, 0, xValuesNew, 0, fromIndex);
        System.arraycopy(this.yValues, 0, yValuesNew, 0, fromIndex);
        System.arraycopy(this.yErrorsNeg, 0, yErrorsNegNew, 0, fromIndex);
        System.arraycopy(this.yErrorsPos, 0, yErrorsPosNew, 0, fromIndex);
        System.arraycopy(this.xValues, toIndex, xValuesNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yValues, toIndex, yValuesNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yErrorsNeg, toIndex, yErrorsNegNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yErrorsPos, toIndex, yErrorsPosNew, fromIndex, newLength - fromIndex);
        this.xValues = xValuesNew;
        this.yValues = yValuesNew;
        this.yErrorsPos = yErrorsPosNew;
        this.yErrorsNeg = yErrorsNegNew;
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex - diffLength);
        this.xRange.empty();
        this.yRange.empty();
        this.unlock();
        this.fireInvalidated(new RemovedDataEvent(this));
        return this;
    }

    public DoubleErrorDataSet add(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos);
        int newLength = this.getDataCount() + xValues.length;
        if (newLength > this.xValues.length) {
            double[] xValuesNew = new double[newLength];
            double[] yValuesNew = new double[newLength];
            double[] yErrorsNegNew = new double[newLength];
            double[] yErrorsPosNew = new double[newLength];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, this.getDataCount());
            System.arraycopy(this.yValues, 0, yValuesNew, 0, this.getDataCount());
            System.arraycopy(yErrorsNeg, 0, yErrorsNegNew, 0, this.getDataCount());
            System.arraycopy(yErrorsPos, 0, yErrorsPosNew, 0, this.getDataCount());
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
            this.yErrorsNeg = yErrorsNegNew;
            this.yErrorsPos = yErrorsPosNew;
        }
        System.arraycopy(xValues, 0, this.xValues, this.getDataCount(), newLength - this.getDataCount());
        System.arraycopy(yValues, 0, this.yValues, this.getDataCount(), newLength - this.getDataCount());
        System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, this.getDataCount(), newLength - this.getDataCount());
        System.arraycopy(yErrorsPos, 0, this.yErrorsPos, this.getDataCount(), newLength - this.getDataCount());
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex + xValues.length);
        this.computeLimits();
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        int errorMin = Math.min(yErrorsPos.length, yErrorsNeg.length);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, this.dataMaxIndex);
        if (!copy) {
            this.xValues = xValues;
            this.yValues = yValues;
            this.yErrorsNeg = yErrorsNeg;
            this.yErrorsPos = yErrorsPos;
            this.computeLimits();
            this.unlock();
            this.fireInvalidated(new UpdatedDataEvent(this));
            return this;
        }
        if (xValues.length == this.xValues.length) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.getDataCount());
            System.arraycopy(yValues, 0, this.yValues, 0, this.getDataCount());
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, 0, this.getDataCount());
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos, 0, this.getDataCount());
        } else {
            this.xValues = Arrays.copyOf(xValues, xValues.length);
            this.yValues = Arrays.copyOf(yValues, xValues.length);
            this.yErrorsNeg = Arrays.copyOf(yErrorsNeg, xValues.length);
            this.yErrorsPos = Arrays.copyOf(yErrorsPos, xValues.length);
        }
        this.computeLimits();
        this.unlock();
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, true);
    }

    public DoubleErrorDataSet set(DataSet other) {
        return this.set(other, true);
    }

    public DoubleErrorDataSet set(DataSet other, boolean copy) {
        if (other instanceof DataSetError) {
            this.set(other.getXValues(), other.getYValues(), ((DataSetError)other).getYErrorsNegative(), ((DataSetError)other).getYErrorsPositive(), copy);
        } else {
            int count = other.getDataCount();
            this.set(other.getXValues(), other.getYValues(), new double[count], new double[count], copy);
        }
        return this;
    }

    public String addDataLabel(int index, String label) {
        String retVal = this.dataLabels.put(index, label);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    public String removeDataLabel(int index) {
        String retVal = this.dataLabels.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    public String addDataStyle(int index, String style) {
        String retVal = this.dataStyles.put(index, style);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    public String removeStyle(int index) {
        String retVal = this.dataStyles.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }
}

