/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.util.ArrayList;
import java.util.Collections;

public class FragmentedDataSet
extends AbstractDataSet<FragmentedDataSet> {
    protected int dataCount;
    protected final ArrayList<DataSet> list = new ArrayList();

    public FragmentedDataSet(String name) {
        super(name);
    }

    @Deprecated
    public AbstractDataSet<?> shallowCopy() {
        FragmentedDataSet d = new FragmentedDataSet(this.getName());
        d.dataCount = this.dataCount;
        d.xRange = this.xRange;
        d.yRange = this.yRange;
        d.list.addAll(this.list);
        return d;
    }

    @Override
    public String toString() {
        return "FragmentedDataSet " + this.getXRange() + " " + this.getYRange() + " [" + this.dataCount + "]";
    }

    public void clear() {
        this.lock();
        try {
            this.dataCount = 0;
            this.list.clear();
            this.fireInvalidated(new UpdatedDataEvent(this, "clear()"));
        }
        finally {
            this.unlock();
        }
    }

    public void add(double[] xValues, double[] yValues) {
        DoubleDataSet set = new DoubleDataSet(String.format("Fragement #%d", this.list.size() + 1), xValues, yValues);
        this.add(set);
    }

    public void add(DataSet set) {
        this.lock();
        try {
            this.list.add(set);
            Collections.sort(this.list, (o1, o2) -> Double.compare(o1.getXMin(), o2.getXMin()));
            this.dataCount += set.getDataCount();
        }
        finally {
            this.unlock();
        }
        this.computeLimits();
        this.fireInvalidated(new AddedDataEvent(this, "added data set"));
    }

    public int getDatasetCount() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getYValues() {
        this.lock();
        try {
            double[] tmp = new double[this.dataCount];
            int index = 0;
            for (DataSet dataset : this.list) {
                for (int i = 0; i < dataset.getDataCount(); ++i) {
                    tmp[index++] = dataset.getY(i);
                }
            }
            Object object = tmp;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getXValues() {
        this.lock();
        try {
            double[] tmp = new double[this.dataCount];
            int index = 0;
            for (DataSet dataset : this.list) {
                for (int i = 0; i < dataset.getDataCount(); ++i) {
                    tmp[index++] = dataset.getX(i);
                }
            }
            Object object = tmp;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getDataCount() {
        return this.dataCount;
    }

    @Override
    public int getDataCount(double xmin, double xmax) {
        int to;
        int from = this.getXIndex(xmin);
        if (from < 0) {
            from = 0;
        }
        if ((to = this.getXIndex(xmax) + 1) > this.getDataCount()) {
            to = this.getDataCount();
        }
        return to - from;
    }

    @Override
    public double getX(int i) {
        for (DataSet dataset : this.list) {
            if (i < dataset.getDataCount()) {
                return dataset.getX(i);
            }
            i -= dataset.getDataCount();
        }
        return 0.0;
    }

    @Override
    public double getY(int i) {
        for (DataSet dataset : this.list) {
            if (i < dataset.getDataCount()) {
                return dataset.getY(i);
            }
            i -= dataset.getDataCount();
        }
        return 0.0;
    }

    @Override
    public String getStyle(int i) {
        for (DataSet dataset : this.list) {
            if (i < dataset.getDataCount()) {
                return dataset.getStyle(i);
            }
            i -= dataset.getDataCount();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getXIndex(double x) {
        this.lock();
        try {
            if (x < this.getXMin()) {
                int n = 0;
                return n;
            }
            int index = 0;
            for (DataSet dataset : this.list) {
                if (x >= dataset.getXMin() && x <= dataset.getXMax()) {
                    int n = index + dataset.getXIndex(x);
                    return n;
                }
                index += dataset.getDataCount();
            }
            int n = this.getDataCount();
            return n;
        }
        finally {
            this.unlock();
        }
    }
}

