/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.Histogram1D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.DataRange;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram
extends AbstractHistogram
implements Histogram1D {
    protected final boolean isHorizontal;

    public Histogram(String name, int nBins, double minX, double maxX, boolean horizontal) {
        super(name, nBins, minX, maxX);
        this.isHorizontal = horizontal;
    }

    public Histogram(String name, int nBins, double minX, double maxX) {
        this(name, nBins, minX, maxX, true);
    }

    public Histogram(String name, double[] xBins, boolean horizontal) {
        super(name, xBins);
        this.isHorizontal = horizontal;
    }

    public Histogram(String name, double[] xBins) {
        this(name, xBins, true);
    }

    @Override
    public int getDataCount() {
        return this.getXDataCount();
    }

    @Override
    public int getXDataCount() {
        return this.getNBinsX() - 2;
    }

    @Override
    public int getYDataCount() {
        return 0;
    }

    @Override
    public double getX(int i) {
        return this.isHorizontal ? this.getBinCenterX(i + 1) : this.getBinContent(i + 1);
    }

    @Override
    public double getY(int i) {
        return this.isHorizontal ? this.getBinContent(i + 1) : this.getBinCenterX(i + 1);
    }

    @Override
    public DataRange getYRange() {
        return this.isHorizontal ? this.getValueRange() : super.getYRange();
    }

    @Override
    public int fill(double x) {
        return this.fill(x, 1.0);
    }

    @Override
    public int fill(double x, double w) {
        int bin = this.findBinX(x);
        this.addBinContent(bin, w);
        this.fireInvalidated(new AddedDataEvent(this, "fill"));
        return bin;
    }

    @Override
    public int fill(String name) {
        return 0;
    }

    @Override
    public int fill(String name, double w) {
        return 0;
    }

    @Override
    public void fillN(double[] x, double[] w, int stepSize) {
        boolean oldFlag = this.isAutoNotification();
        this.setAutoNotifaction(false);
        for (int i = 0; i < x.length; ++i) {
            this.fill(x[i], w[i]);
        }
        this.setAutoNotifaction(oldFlag);
        this.fireInvalidated(new AddedDataEvent(this, "fillN"));
    }

    @Override
    public double getZ(int xIndex, int yIndex) {
        return 0.0;
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    @Override
    protected Histogram computeLimits() {
        return this;
    }

    @Override
    public List<String> getWarningList() {
        LinkedList<String> retVal = new LinkedList<String>();
        if (this.getBinContent(0) > 0.0) {
            retVal.add("under-range");
        }
        if (this.getBinContent(this.getNBinsX() - 1) > 0.0) {
            retVal.add("over-range");
        }
        return retVal;
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }
}

