/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.trees.IndexedNavigableSet;
import de.gsi.dataset.utils.trees.IndexedTreeSet;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class LimitedIndexedTreeDataSet
extends AbstractErrorDataSet<LimitedIndexedTreeDataSet> {
    protected IndexedNavigableSet<DataAtom> data = new IndexedTreeSet<DataAtom>();
    protected int maxQueueSize = Integer.MAX_VALUE;
    protected double maxLength = Double.MAX_VALUE;

    public LimitedIndexedTreeDataSet(String name, int maxQueueSize) {
        super(name);
        this.setErrorType(DataSetError.ErrorType.XY);
        this.maxQueueSize = maxQueueSize;
    }

    public LimitedIndexedTreeDataSet(String name, int maxQueueSize, double maxLength) {
        super(name);
        this.setErrorType(DataSetError.ErrorType.XY);
        this.maxQueueSize = maxQueueSize;
        this.maxLength = maxLength;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public LimitedIndexedTreeDataSet setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public LimitedIndexedTreeDataSet setMaxLength(double maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public LimitedIndexedTreeDataSet reset() {
        this.lock();
        this.getData().clear();
        this.unlock();
        return this;
    }

    public void expire() {
        this.lock();
        this.expire(((DataAtom)this.data.last()).getX());
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(double now) {
        this.lock();
        try {
            DataAtom first = (DataAtom)this.data.first();
            if (first == null) {
                return;
            }
            while (this.data.size() > this.maxQueueSize || now - first.getX() > this.maxLength) {
                this.data.remove(first);
                first = (DataAtom)this.data.first();
            }
            this.computeLimits();
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            this.unlock();
        }
    }

    public IndexedNavigableSet<DataAtom> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public double getX(int i) {
        return this.data.get(i).getX();
    }

    @Override
    public double getY(int i) {
        return this.data.get(i).getY();
    }

    @Override
    public double getXErrorNegative(int index) {
        return this.data.get(index).getErrorX();
    }

    @Override
    public double getXErrorPositive(int index) {
        return this.data.get(index).getErrorX();
    }

    @Override
    public double getYErrorNegative(int index) {
        return this.data.get(index).getErrorY();
    }

    @Override
    public double getYErrorPositive(int index) {
        return this.data.get(index).getErrorY();
    }

    public LimitedIndexedTreeDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    public LimitedIndexedTreeDataSet clearData() {
        ((LimitedIndexedTreeDataSet)this.lock()).setAutoNotifaction(false);
        this.data.clear();
        this.xRange.empty();
        this.yRange.empty();
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this, "clear"));
    }

    public LimitedIndexedTreeDataSet set(int index, double x, double y, double dx, double dy) {
        this.lock();
        this.data.get(index).set(x, y, dy, dy);
        this.xRange.add(x - dx);
        this.xRange.add(x + dx);
        this.yRange.add(y - dy);
        this.yRange.add(y + dy);
        this.expire();
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors, int count) {
        ((LimitedIndexedTreeDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        if (xValues.length < count || yValues.length < count || xErrors.length < count || yErrors.length < count) {
            throw new IllegalArgumentException("Arrays with coordinates must have length >= count!");
        }
        for (int i = 0; i < xValues.length; ++i) {
            double x = xValues[i];
            double y = yValues[i];
            double dx = xErrors[i];
            double dy = yValues[i];
            this.xRange.add(x - dx);
            this.xRange.add(x + dx);
            this.yRange.add(y - dy);
            this.yRange.add(y + dy);
            this.data.add(new DataAtom(x, y, dx, dy));
        }
        this.expire();
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues, int count) {
        return this.set(xValues, yValues, new double[count], new double[count], count);
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues, double[] yErrors, int count) {
        return this.set(xValues, yValues, new double[count], yErrors, count);
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues) {
        int ndim = xValues.length;
        return this.set(xValues, yValues, new double[ndim], new double[ndim], ndim);
    }

    public LimitedIndexedTreeDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0);
    }

    public LimitedIndexedTreeDataSet add(double x, double y, double ex, double ey) {
        this.lock();
        this.data.add(new DataAtom(x, y, ex, ey));
        this.xRange.add(x - ex);
        this.xRange.add(x + ex);
        this.yRange.add(y - ey);
        this.yRange.add(y + ey);
        this.expire();
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet add(double[] xValues, double[] yValues) {
        return this.add(xValues, yValues, new double[yValues.length], new double[yValues.length]);
    }

    public LimitedIndexedTreeDataSet add(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors) {
        ((LimitedIndexedTreeDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("X error data", xErrors);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error data", yValues);
        for (int i = 0; i < xValues.length; ++i) {
            double x = xValues[i];
            double y = yValues[i];
            double ex = xErrors[i];
            double ey = yErrors[i];
            this.data.add(new DataAtom(x, y, ex, ey));
            this.xRange.add(x - ex);
            this.xRange.add(x + ex);
            this.yRange.add(y - ey);
            this.yRange.add(y + ey);
        }
        this.expire();
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet remove(int fromIndex, int toIndex) {
        ((LimitedIndexedTreeDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        ArrayList<DataAtom> toRemove = new ArrayList<DataAtom>();
        for (int i = fromIndex; i < toIndex; ++i) {
            toRemove.add(this.data.get(i));
        }
        this.data.removeAll(toRemove);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet remove(int[] indices) {
        ((LimitedIndexedTreeDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return (LimitedIndexedTreeDataSet)this.unlock();
        }
        ArrayList<DataAtom> tupleTobeRemovedReferences = new ArrayList<DataAtom>();
        for (int indexToRemove : indices) {
            tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
        }
        this.data.removeAll(tupleTobeRemovedReferences);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        super.computeLimits();
        return (LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)((LimitedIndexedTreeDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    public String addDataLabel(int index, String label) {
        String old = this.data.get((int)index).dataLabel;
        this.data.get((int)index).dataLabel = label;
        return old;
    }

    public String removeDataLabel(int index) {
        String old = this.data.get((int)index).dataLabel;
        this.data.get((int)index).dataLabel = null;
        return old;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.data.get(index).getLabel();
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    public String addDataStyle(int index, String style) {
        String old = this.data.get((int)index).dataStyle;
        this.data.get((int)index).dataStyle = style;
        return old;
    }

    public String removeStyle(int index) {
        String old = this.data.get((int)index).dataStyle;
        this.data.get((int)index).dataStyle = null;
        return old;
    }

    @Override
    public String getStyle(int index) {
        return this.data.get(index).getStyle();
    }

    protected class DataAtom
    implements Comparable<DataAtom> {
        protected double x;
        protected double y;
        protected double ex;
        protected double ey;
        protected String dataLabel;
        protected String dataStyle;

        DataAtom(double x, double y, double ex, double ey) {
            this.x = x;
            this.y = y;
            this.ex = ex;
            this.ey = ey;
        }

        void set(double x, double y, double ex, double ey) {
            this.x = x;
            this.y = y;
            this.ex = ex;
            this.ey = ey;
        }

        double getX() {
            return this.x;
        }

        double getY() {
            return this.y;
        }

        double getErrorX() {
            return this.ex;
        }

        double getErrorY() {
            return this.ey;
        }

        String getLabel() {
            return this.dataLabel;
        }

        String getStyle() {
            return this.dataStyle;
        }

        @Override
        public int compareTo(DataAtom other) {
            if (this.getX() < other.getX()) {
                return -1;
            }
            if (this.getX() > other.getX()) {
                return 1;
            }
            return 0;
        }
    }
}

