/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.FragmentedDataSet;

public class RollingDataSet
extends FragmentedDataSet {
    private double lastLength;
    private int depth = 0;

    public RollingDataSet(String name) {
        super(name);
    }

    @Override
    public void add(DataSet set) {
        while (this.list.size() >= this.depth) {
            DataSet ds = (DataSet)this.list.remove(0);
            this.dataCount -= ds.getDataCount();
        }
        for (DataSet ds : this.list) {
            ((InternalDataSet)ds).shift(-this.lastLength);
        }
        this.list.add(new InternalDataSet(set));
        this.dataCount += set.getDataCount();
        this.lastLength = set.getXMax();
        this.computeLimits();
        this.fireInvalidated(new AddedDataEvent(this));
    }

    public double getLastLength() {
        return this.lastLength;
    }

    public void setDepth(int d) {
        this.depth = d;
    }

    public int getDepth() {
        return this.depth;
    }

    private class InternalDataSet
    extends DoubleDataSet {
        public InternalDataSet(DataSet ds) {
            super(ds.getName());
            this.xValues = new double[ds.getDataCount()];
            this.yValues = new double[ds.getDataCount()];
            for (int i = 0; i < this.yValues.length; ++i) {
                this.xValues[i] = ds.getX(i);
                this.yValues[i] = ds.getY(i);
            }
            this.computeLimits();
        }

        public void shift(double value) {
            int i = 0;
            while (i < this.xValues.length) {
                int n = i++;
                this.xValues[n] = this.xValues[n] + value;
            }
            this.computeLimits();
        }
    }
}

