/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import java.util.Random;
import java.util.SplittableRandom;

public final class RandomDataGenerator {
    private static final Random rndDeprecated = new Random(System.currentTimeMillis());
    private static final SplittableRandom rnd = new SplittableRandom(System.currentTimeMillis());
    private static final int numberOfPoints = 1000;
    private static final double xMax = 100.0;
    private static final double peak = 10.0;
    private static final double back = 1.0;
    private static final double yMax = 12.100000000000001;
    private static final double sarurationLevel = 15.0;
    private static double noiseLevel = 0.5;
    private static double slope;
    private static double width;
    private static double center;
    private static double background;
    private static double amplitude;
    private static double[] xValues;
    private static double[] yValues;
    private static double nextNextGaussian;
    private static boolean haveNextNextGaussian;

    public static double[] generateZeroOneArray(double firstValue, int size) {
        double[] data = new double[size];
        data[0] = firstValue;
        for (int i = 1; i < data.length; ++i) {
            data[i] = rnd.nextBoolean() ? 0.0 : 1.0;
        }
        return data;
    }

    public static double[] generateDoubleArray(double firstValue, double variance, int size) {
        double[] data = new double[size];
        data[0] = firstValue;
        for (int i = 1; i < data.length; ++i) {
            int sign = rnd.nextBoolean() ? 1 : -1;
            double val = (double)(rnd.nextInt() % 1000) / 1000.0;
            data[i] = data[i - 1] + variance * val * (double)sign;
        }
        return data;
    }

    public static float[] generateFloatArray(float firstValue, float variance, int size) {
        float[] data = new float[size];
        data[0] = firstValue;
        for (int i = 1; i < data.length; ++i) {
            int sign = rnd.nextBoolean() ? 1 : -1;
            float val = (float)((double)(rnd.nextInt() % 1000) / 1000.0);
            data[i] = data[i - 1] + variance * val * (float)sign;
        }
        return data;
    }

    public static int[] generateIntArray(int firstValue, int variance, int size) {
        int[] data = new int[size];
        data[0] = firstValue;
        for (int i = 1; i < data.length; ++i) {
            int sign = rnd.nextBoolean() ? 1 : -1;
            data[i] = data[i - 1] + (int)((double)variance * rnd.nextDouble()) * sign;
        }
        return data;
    }

    public static byte[] generateByteArray(int size) {
        byte[] data = new byte[size];
        rndDeprecated.nextBytes(data);
        return data;
    }

    public static synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (haveNextNextGaussian) {
            haveNextNextGaussian = false;
            return nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * rnd.nextDouble() - 1.0) * v1 + (v2 = 2.0 * rnd.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        nextNextGaussian = v2 * multiplier;
        haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public static double random() {
        return rnd.nextDouble();
    }

    public static double myRandom(double low, double high) {
        assert (high > low);
        return rnd.nextDouble() * (high - low) + low;
    }

    public static synchronized void getNew1DGaussian() {
        int i;
        slope = RandomDataGenerator.myRandom(-0.003, 0.003);
        width = 100.0 * RandomDataGenerator.myRandom(0.04, 0.07);
        center = 100.0 * RandomDataGenerator.myRandom(-0.02, 0.02);
        background = 1.0 * RandomDataGenerator.myRandom(0.5, 1.5);
        amplitude = 10.0 * RandomDataGenerator.myRandom(0.9, 1.1);
        noiseLevel = 0.3;
        if (xValues == null) {
            xValues = new double[1000];
            yValues = new double[1000];
            for (i = 0; i < 1000; ++i) {
                RandomDataGenerator.xValues[i] = 200.0 * (0.5 - (double)(1000 - i) / 1000.0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            RandomDataGenerator.yValues[i] = RandomDataGenerator.myRandom(0.0, noiseLevel) + background + slope * (xValues[i] - center) + amplitude * Math.exp(-(xValues[i] - center) * (xValues[i] - center) / width / width / 2.0);
        }
        for (i = 0; i < 1000; ++i) {
            RandomDataGenerator.yValues[i] = yValues[i] > 15.0 ? 15.0 : yValues[i];
        }
    }

    public static double[] getGaussianY() {
        if (yValues == null) {
            RandomDataGenerator.getNew1DGaussian();
        }
        return yValues;
    }

    public static double[] getGaussianX() {
        if (xValues == null) {
            RandomDataGenerator.getNew1DGaussian();
        }
        return xValues;
    }

    public static void main(String[] args) {
    }

    static {
        haveNextNextGaussian = false;
    }
}

