/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessingProfiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingProfiler.class);
    protected static boolean debugState = false;
    protected static boolean verboseOutput = true;
    protected static boolean loggerOutput = false;

    private ProcessingProfiler() {
    }

    public static void setDebugState(boolean state) {
        debugState = state;
    }

    public static boolean getDebugState() {
        return debugState;
    }

    public static void setVerboseOutputState(boolean state) {
        verboseOutput = state;
    }

    public static boolean getVerboseOutputState() {
        return verboseOutput;
    }

    public static void setLoggerOutputState(boolean state) {
        loggerOutput = state;
    }

    public static boolean getLoggerOutputState() {
        return loggerOutput;
    }

    public static long getTimeStamp() {
        if (debugState) {
            return System.nanoTime();
        }
        return 0L;
    }

    public static long getTimeDiff(long lastStamp) {
        return ProcessingProfiler.getTimeDiff(lastStamp, null);
    }

    public static String getCallingClassMethod(int recursionDepth) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int nLast = 2 + recursionDepth;
        StackTraceElement stackTraceElement = stacktrace[nLast];
        String fullClassName = stackTraceElement.getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        String methodName = stackTraceElement.getMethodName();
        int lineNumer = stackTraceElement.getLineNumber();
        String compoundName = simpleClassName + "::" + methodName + "(line:" + lineNumer + ")";
        return compoundName;
    }

    protected static String getCallingClassMethod(String msg) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int nLast = msg == null ? 4 : 3;
        StackTraceElement stackTraceElement = stacktrace[nLast];
        String fullClassName = stackTraceElement.getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        String methodName = stackTraceElement.getMethodName();
        int lineNumer = stackTraceElement.getLineNumber();
        String compoundName = simpleClassName + "::" + methodName + "(line:" + lineNumer + ")";
        return compoundName;
    }

    public static long getTimeDiff(long lastStamp, String msg) {
        if (!debugState) {
            return 0L;
        }
        long now = System.nanoTime();
        double diff = TimeUnit.NANOSECONDS.toMillis(now - lastStamp);
        if (verboseOutput) {
            String compoundName = ProcessingProfiler.getCallingClassMethod(msg);
            String message = String.format("%-55s - time diff = %8.3f [ms] msg: '%s'", compoundName, diff, msg == null ? "" : msg);
            if (loggerOutput) {
                LOGGER.info(message);
            } else {
                System.out.println(message);
            }
        }
        return now;
    }
}

