/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.DataSetUtilsHelper;
import de.gsi.dataset.utils.serializer.BinarySerialiser;
import de.gsi.dataset.utils.serializer.DataType;
import de.gsi.dataset.utils.serializer.FastByteBuffer;
import java.util.InputMismatchException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetSerialiser
extends DataSetUtilsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetSerialiser.class);
    private static final String DATA_SET_NAME = "dataSetName";
    private static final String Y_ARRAY_NAME = "y";
    private static final String X_ARRAY_NAME = "x";
    private static final String XEN = "xen";
    private static final String XEP = "xep";
    private static final String YEP = "yep";
    private static final String YEN = "yen";
    private static final String Y_MAX = "yMax";
    private static final String Y_MIN = "yMin";
    private static final String X_MAX = "xMax";
    private static final String X_MIN = "xMin";
    private static final String META_INFO = "metaInfo";
    private static final String ERROR_LIST = "errorList";
    private static final String WARNING_LIST = "warningList";
    private static final String INFO_LIST = "infoList";
    private static final String DATA_STYLES = "dataStyles";
    private static final String DATA_LABELS = "dataLabels";
    private static final String VAL_RMS = "rms";
    private static final String VAL_MEAN = "mean";
    private static final String VAL_INTEGRAL = "integral";
    private static boolean transmitDataLabels = true;
    private static boolean transmitMetaData = true;

    protected DataSetSerialiser() {
    }

    public static boolean isMetaDataSerialised() {
        return transmitMetaData;
    }

    public static void setMetaDataSerialised(boolean state) {
        transmitMetaData = state;
    }

    public static boolean isDataLablesSerialised() {
        return transmitDataLabels;
    }

    public static void setDataLablesSerialised(boolean state) {
        transmitDataLabels = state;
    }

    public static void writeDataSetToByteArray(DataSet dataSet, FastByteBuffer buffer, boolean asFloat) {
        AssertUtils.notNull("dataSet", dataSet);
        AssertUtils.notNull("buffer", buffer);
        dataSet.lock();
        BinarySerialiser.putHeaderInfo(buffer);
        DataSetSerialiser.writeHeaderDataToStream(buffer, dataSet);
        if (DataSetSerialiser.isMetaDataSerialised()) {
            DataSetSerialiser.writeMetaDataToStream(buffer, dataSet);
        }
        if (DataSetSerialiser.isDataLablesSerialised()) {
            DataSetSerialiser.writeDataLabelsToStream(buffer, dataSet);
        }
        DataSetSerialiser.writeNumericBinaryDataToBuffer(buffer, dataSet, asFloat);
        BinarySerialiser.putEndMarker(buffer);
    }

    protected static void writeHeaderDataToStream(FastByteBuffer buffer, DataSet dataSet) {
        BinarySerialiser.put(buffer, DATA_SET_NAME, dataSet.getName());
        BinarySerialiser.put(buffer, X_MIN, dataSet.getXMin());
        BinarySerialiser.put(buffer, X_MAX, dataSet.getXMax());
        BinarySerialiser.put(buffer, Y_MIN, dataSet.getYMin());
        BinarySerialiser.put(buffer, Y_MAX, dataSet.getYMax());
        BinarySerialiser.put(buffer, VAL_INTEGRAL, DataSetSerialiser.integralSimple(dataSet));
        BinarySerialiser.put(buffer, VAL_MEAN, DataSetSerialiser.mean(dataSet.getYValues()));
        BinarySerialiser.put(buffer, VAL_RMS, DataSetSerialiser.rootMeanSquare(dataSet.getYValues()));
    }

    protected static void writeMetaDataToStream(FastByteBuffer buffer, DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            return;
        }
        DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
        BinarySerialiser.put(buffer, INFO_LIST, metaDataSet.getInfoList().toArray(new String[0]));
        BinarySerialiser.put(buffer, WARNING_LIST, metaDataSet.getWarningList().toArray(new String[0]));
        BinarySerialiser.put(buffer, ERROR_LIST, metaDataSet.getErrorList().toArray(new String[0]));
        BinarySerialiser.put(buffer, META_INFO, metaDataSet.getMetaInfo());
    }

    protected static void writeDataLabelsToStream(FastByteBuffer buffer, DataSet dataSet) {
        int dataCount = dataSet.getDataCount();
        ConcurrentHashMap<Integer, String> labelMap = new ConcurrentHashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String label = dataSet.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            labelMap.put(index, label);
        }
        if (!labelMap.isEmpty()) {
            BinarySerialiser.put(buffer, DATA_LABELS, labelMap);
        }
        ConcurrentHashMap<Integer, String> styleMap = new ConcurrentHashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String style = dataSet.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            styleMap.put(index, style);
        }
        if (!styleMap.isEmpty()) {
            BinarySerialiser.put(buffer, DATA_STYLES, styleMap);
        }
    }

    protected static void writeNumericBinaryDataToBuffer(FastByteBuffer buffer, DataSet dataSet, boolean asFloat) {
        int nsamples = dataSet.getDataCount();
        if (asFloat) {
            BinarySerialiser.put(buffer, X_ARRAY_NAME, DataSetSerialiser.toFloats(dataSet.getXValues()), new int[]{nsamples});
            BinarySerialiser.put(buffer, Y_ARRAY_NAME, DataSetSerialiser.toFloats(dataSet.getYValues()), new int[]{nsamples});
            if (!(dataSet instanceof DataSetError)) {
                return;
            }
            DataSetError ds = (DataSetError)dataSet;
            switch (ds.getErrorType()) {
                case NO_ERROR: {
                    break;
                }
                case X: {
                    BinarySerialiser.put(buffer, XEP, DataSetSerialiser.toFloats(ds.getXErrorsPositive()), new int[]{nsamples});
                    break;
                }
                case X_ASYMMETRIC: {
                    BinarySerialiser.put(buffer, XEN, DataSetSerialiser.toFloats(ds.getXErrorsNegative()), new int[]{nsamples});
                    BinarySerialiser.put(buffer, XEP, DataSetSerialiser.toFloats(ds.getXErrorsPositive()), new int[]{nsamples});
                    break;
                }
                case Y: {
                    BinarySerialiser.put(buffer, YEP, DataSetSerialiser.toFloats(ds.getYErrorsPositive()), new int[]{nsamples});
                    break;
                }
                case XY: {
                    BinarySerialiser.put(buffer, XEP, DataSetSerialiser.toFloats(ds.getXErrorsPositive()), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEP, DataSetSerialiser.toFloats(ds.getYErrorsPositive()), new int[]{nsamples});
                    break;
                }
                case Y_ASYMMETRIC: {
                    BinarySerialiser.put(buffer, YEN, DataSetSerialiser.toFloats(ds.getYErrorsNegative()), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEP, DataSetSerialiser.toFloats(ds.getYErrorsPositive()), new int[]{nsamples});
                    break;
                }
                default: {
                    BinarySerialiser.put(buffer, XEN, DataSetSerialiser.toFloats(ds.getXErrorsNegative()), new int[]{nsamples});
                    BinarySerialiser.put(buffer, XEP, DataSetSerialiser.toFloats(ds.getXErrorsPositive()), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEN, DataSetSerialiser.toFloats(ds.getYErrorsNegative()), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEP, DataSetSerialiser.toFloats(ds.getYErrorsPositive()), new int[]{nsamples});
                    break;
                }
            }
        } else {
            BinarySerialiser.put(buffer, X_ARRAY_NAME, dataSet.getXValues(), new int[]{nsamples});
            BinarySerialiser.put(buffer, Y_ARRAY_NAME, dataSet.getYValues(), new int[]{nsamples});
            if (!(dataSet instanceof DataSetError)) {
                return;
            }
            DataSetError ds = (DataSetError)dataSet;
            switch (ds.getErrorType()) {
                case NO_ERROR: {
                    break;
                }
                case X: {
                    BinarySerialiser.put(buffer, XEP, ds.getXErrorsPositive(), new int[]{nsamples});
                    break;
                }
                case X_ASYMMETRIC: {
                    BinarySerialiser.put(buffer, XEN, ds.getXErrorsNegative(), new int[]{nsamples});
                    BinarySerialiser.put(buffer, XEP, ds.getXErrorsPositive(), new int[]{nsamples});
                    break;
                }
                case Y: {
                    BinarySerialiser.put(buffer, YEP, ds.getYErrorsPositive(), new int[]{nsamples});
                    break;
                }
                case XY: {
                    BinarySerialiser.put(buffer, XEP, ds.getXErrorsPositive(), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEP, ds.getYErrorsPositive(), new int[]{nsamples});
                    break;
                }
                case Y_ASYMMETRIC: {
                    BinarySerialiser.put(buffer, YEN, ds.getYErrorsNegative(), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEP, ds.getYErrorsPositive(), new int[]{nsamples});
                    break;
                }
                default: {
                    BinarySerialiser.put(buffer, XEN, ds.getXErrorsNegative(), new int[]{nsamples});
                    BinarySerialiser.put(buffer, XEP, ds.getXErrorsPositive(), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEN, ds.getYErrorsNegative(), new int[]{nsamples});
                    BinarySerialiser.put(buffer, YEP, ds.getYErrorsPositive(), new int[]{nsamples});
                }
            }
        }
    }

    protected static boolean checkFieldCompatibility(BinarySerialiser.FieldHeader fieldHeader, String fieldName, DataType requireDataType) {
        if (fieldHeader.getFieldName().equals(fieldName)) {
            if (!fieldHeader.getDataType().equals((Object)requireDataType)) {
                throw new InputMismatchException(fieldName + " is type " + (Object)((Object)fieldHeader.getDataType()) + " vs. required type " + (Object)((Object)requireDataType));
            }
            return true;
        }
        return false;
    }

    public static DataSet readDataSetFromByteArray(FastByteBuffer readBuffer) {
        BinarySerialiser.FieldHeader fieldHeader;
        DataSetBuilder builder = new DataSetBuilder();
        BinarySerialiser.HeaderInfo bufferHeader = BinarySerialiser.checkHeaderInfo(readBuffer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("read header = %s{}", (Object)bufferHeader);
        }
        while ((fieldHeader = BinarySerialiser.getFieldHeader(readBuffer)) != null) {
            ConcurrentHashMap<Integer, String> map;
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, DATA_SET_NAME, DataType.STRING)) {
                builder.setName(BinarySerialiser.getString(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, X_MIN, DataType.DOUBLE)) {
                builder.setXMin(BinarySerialiser.getDouble(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, X_MAX, DataType.DOUBLE)) {
                builder.setXMax(BinarySerialiser.getDouble(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, Y_MIN, DataType.DOUBLE)) {
                builder.setYMin(BinarySerialiser.getDouble(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, Y_MAX, DataType.DOUBLE)) {
                builder.setYMax(BinarySerialiser.getDouble(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, VAL_INTEGRAL, DataType.DOUBLE)) {
                BinarySerialiser.getDouble(readBuffer);
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, VAL_MEAN, DataType.DOUBLE)) {
                BinarySerialiser.getDouble(readBuffer);
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, VAL_RMS, DataType.DOUBLE)) {
                BinarySerialiser.getDouble(readBuffer);
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, INFO_LIST, DataType.STRING_ARRAY)) {
                builder.setMetaInfoList(BinarySerialiser.getStringArray(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, WARNING_LIST, DataType.STRING_ARRAY)) {
                builder.setMetaWarningList(BinarySerialiser.getStringArray(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, ERROR_LIST, DataType.STRING_ARRAY)) {
                builder.setMetaErrorList(BinarySerialiser.getStringArray(readBuffer));
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, META_INFO, DataType.MAP)) {
                map = new ConcurrentHashMap();
                map = BinarySerialiser.getMap(readBuffer, map);
                builder.setMetaInfoMap(map);
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, DATA_LABELS, DataType.MAP)) {
                map = new ConcurrentHashMap();
                map = BinarySerialiser.getMap(readBuffer, map);
                builder.setDataLabelMap(map);
                continue;
            }
            if (DataSetSerialiser.checkFieldCompatibility(fieldHeader, DATA_STYLES, DataType.MAP)) {
                map = new ConcurrentHashMap();
                map = BinarySerialiser.getMap(readBuffer, map);
                builder.setDataStyleMap(map);
                continue;
            }
            if (fieldHeader.getFieldName().equals(X_ARRAY_NAME)) {
                if (fieldHeader.getDataType().equals((Object)DataType.DOUBLE_ARRAY)) {
                    builder.setXValues(BinarySerialiser.getDoubleArray(readBuffer));
                    continue;
                }
                if (fieldHeader.getDataType().equals((Object)DataType.FLOAT_ARRAY)) {
                    builder.setXValues(DataSetSerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer)));
                    continue;
                }
                throw new InputMismatchException("x is not a [double, float]_array but " + (Object)((Object)fieldHeader.getDataType()));
            }
            if (fieldHeader.getFieldName().equals(Y_ARRAY_NAME)) {
                if (fieldHeader.getDataType().equals((Object)DataType.DOUBLE_ARRAY)) {
                    builder.setYValues(BinarySerialiser.getDoubleArray(readBuffer));
                    continue;
                }
                if (fieldHeader.getDataType().equals((Object)DataType.FLOAT_ARRAY)) {
                    builder.setYValues(DataSetSerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer)));
                    continue;
                }
                throw new InputMismatchException("y is not a [double, float]_array but " + (Object)((Object)fieldHeader.getDataType()));
            }
            if (fieldHeader.getFieldName().equals(XEN)) {
                if (fieldHeader.getDataType().equals((Object)DataType.DOUBLE_ARRAY)) {
                    builder.setXNegErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer));
                    continue;
                }
                if (fieldHeader.getDataType().equals((Object)DataType.FLOAT_ARRAY)) {
                    builder.setXNegErrorNoCopy(DataSetSerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer)));
                    continue;
                }
                throw new InputMismatchException("xen is not a [double, float]_array but " + (Object)((Object)fieldHeader.getDataType()));
            }
            if (fieldHeader.getFieldName().equals(XEP)) {
                if (fieldHeader.getDataType().equals((Object)DataType.DOUBLE_ARRAY)) {
                    builder.setXPosErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer));
                    continue;
                }
                if (fieldHeader.getDataType().equals((Object)DataType.FLOAT_ARRAY)) {
                    builder.setXPosErrorNoCopy(DataSetSerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer)));
                    continue;
                }
                throw new InputMismatchException("xep is not a [double, float]_array but " + (Object)((Object)fieldHeader.getDataType()));
            }
            if (fieldHeader.getFieldName().equals(YEN)) {
                if (fieldHeader.getDataType().equals((Object)DataType.DOUBLE_ARRAY)) {
                    builder.setYNegErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer));
                    continue;
                }
                if (fieldHeader.getDataType().equals((Object)DataType.FLOAT_ARRAY)) {
                    builder.setYNegErrorNoCopy(DataSetSerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer)));
                    continue;
                }
                throw new InputMismatchException("yen is not a [double, float]_array but " + (Object)((Object)fieldHeader.getDataType()));
            }
            if (fieldHeader.getFieldName().equals(YEP)) {
                if (fieldHeader.getDataType().equals((Object)DataType.DOUBLE_ARRAY)) {
                    builder.setYPosErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer));
                    continue;
                }
                if (fieldHeader.getDataType().equals((Object)DataType.FLOAT_ARRAY)) {
                    builder.setYPosErrorNoCopy(DataSetSerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer)));
                    continue;
                }
                throw new InputMismatchException("yep is not a [double, float]_array but " + (Object)((Object)fieldHeader.getDataType()));
            }
            DataSetSerialiser.swallowRest(readBuffer, fieldHeader);
        }
        return builder.build();
    }

    protected static void swallowRest(FastByteBuffer readBuffer, BinarySerialiser.FieldHeader fieldHeader) {
        Object leftOver = null;
        switch (fieldHeader.getDataType()) {
            case BOOL: {
                leftOver = BinarySerialiser.getBoolean(readBuffer);
                break;
            }
            case BYTE: {
                leftOver = BinarySerialiser.getByte(readBuffer);
                break;
            }
            case SHORT: {
                leftOver = BinarySerialiser.getShort(readBuffer);
                break;
            }
            case INT: {
                leftOver = BinarySerialiser.getInteger(readBuffer);
                break;
            }
            case LONG: {
                leftOver = BinarySerialiser.getLong(readBuffer);
                break;
            }
            case FLOAT: {
                leftOver = Float.valueOf(BinarySerialiser.getFloat(readBuffer));
                break;
            }
            case DOUBLE: {
                leftOver = BinarySerialiser.getDouble(readBuffer);
                break;
            }
            case STRING: {
                leftOver = BinarySerialiser.getString(readBuffer);
                break;
            }
            case BOOL_ARRAY: {
                leftOver = BinarySerialiser.getBooleanArray(readBuffer);
                break;
            }
            case BYTE_ARRAY: {
                leftOver = BinarySerialiser.getByteArray(readBuffer);
                break;
            }
            case SHORT_ARRAY: {
                leftOver = BinarySerialiser.getShortArray(readBuffer);
                break;
            }
            case INT_ARRAY: {
                leftOver = BinarySerialiser.getIntArray(readBuffer);
                break;
            }
            case LONG_ARRAY: {
                leftOver = BinarySerialiser.getLongArray(readBuffer);
                break;
            }
            case FLOAT_ARRAY: {
                leftOver = BinarySerialiser.getFloatArray(readBuffer);
                break;
            }
            case DOUBLE_ARRAY: {
                leftOver = BinarySerialiser.getDoubleArray(readBuffer);
                break;
            }
            case STRING_ARRAY: {
                leftOver = BinarySerialiser.getStringArray(readBuffer);
                break;
            }
            case MAP: {
                leftOver = BinarySerialiser.getMap(readBuffer, new ConcurrentHashMap());
                break;
            }
            case END_MARKER: {
                byte endMarker = BinarySerialiser.getByte(readBuffer);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("swallowed '{}'='{}'", (Object)fieldHeader, (Object)Byte.toString(endMarker));
                break;
            }
            default: {
                throw new IllegalArgumentException("encountered unknown format for " + fieldHeader.toString());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("swallowed unused element '%s{}'='%s{}'\n", (Object)fieldHeader, leftOver);
        }
    }

    protected static float[] toFloats(double[] input) {
        float[] floatArray = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floatArray[i] = (float)input[i];
        }
        return floatArray;
    }

    protected static double[] toDoubles(float[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }
}

