/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset;

import de.gsi.dataset.DataSet;

public interface DataSet2D
extends DataSet {
    @Override
    public int getDataCount();

    @Override
    default public int getDataCount(int dim) {
        return this.getDataCount();
    }

    @Override
    default public int getDimension() {
        return 2;
    }

    @Override
    default public int getIndex(int dimIndex, double value) {
        return dimIndex == 0 ? this.getXIndex(value) : this.getYIndex(value);
    }

    default public double getValue(double x) {
        int index1 = this.getXIndex(x);
        double x1 = this.getX(index1);
        double y1 = this.getY(index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.getY(index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.getX(index2);
        if (x1 == x2) {
            return y1;
        }
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    @Override
    default public double getValue(int dimIndex, double x) {
        return this.getValue(x);
    }

    default public double getX(int index) {
        return this.get(0, index);
    }

    public int getXIndex(double var1);

    default public double[] getXValues() {
        return this.getValues(0);
    }

    default public double getY(int index) {
        return this.get(1, index);
    }

    public int getYIndex(double var1);

    default public double[] getYValues() {
        return this.getValues(1);
    }
}

