/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DefaultAxisDescription;

public abstract class AbstractDataSet3D<D extends AbstractDataSet3D<D>>
extends AbstractDataSet<D>
implements DataSet3D {
    private static final long serialVersionUID = 2766945109681463872L;

    public AbstractDataSet3D(String name) {
        super(name, 3);
        this.getAxisDescriptions().add(new DefaultAxisDescription((DataSet)this, "z-Axis", "a.u."));
    }

    @Override
    public int getDataCount() {
        return this.getDataCount(0) * this.getDataCount(1);
    }

    @Override
    public int getXIndex(double x) {
        if (this.getDataCount(0) == 0) {
            return 0;
        }
        if (x < this.getX(0)) {
            return 0;
        }
        int lastIndex = this.getDataCount(0) - 1;
        if (x > this.getX(lastIndex)) {
            return lastIndex;
        }
        return this.binarySearchX(x, 0, lastIndex);
    }

    @Override
    public int getYIndex(double y) {
        if (this.getDataCount(1) == 0) {
            return 0;
        }
        if (y < this.getY(0)) {
            return 0;
        }
        int lastIndex = this.getDataCount(1) - 1;
        if (y > this.getY(lastIndex)) {
            return lastIndex;
        }
        return this.binarySearchY(y, 0, lastIndex);
    }

    @Override
    public D recomputeLimits(int dimension) {
        this.lock().writeLockGuard(() -> {
            this.getAxisDescription(dimension).clear();
            if (dimension == 0) {
                int dataCount = this.getDataCount(0);
                AxisDescription axisRange = this.getAxisDescription(dimension);
                for (int i = 0; i < dataCount; ++i) {
                    axisRange.add(this.getX(i));
                }
            } else if (dimension == 1) {
                int dataCount = this.getDataCount(1);
                AxisDescription axisRange = this.getAxisDescription(dimension);
                for (int i = 0; i < dataCount; ++i) {
                    axisRange.add(this.getY(i));
                }
            } else {
                int xDataCount = this.getDataCount(0);
                int yDataCount = this.getDataCount(1);
                AxisDescription axisRange = this.getAxisDescription(dimension);
                for (int i = 0; i < xDataCount; ++i) {
                    for (int j = 0; j < yDataCount; ++j) {
                        axisRange.add(this.getZ(i, j));
                    }
                }
            }
        });
        return (D)((AbstractDataSet3D)this.getThis());
    }
}

