/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError,
EditableDataSet,
DataSet2D {
    private static final long serialVersionUID = 8931518518245752926L;
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;
    protected DoubleArrayList yErrorsPos;
    protected DoubleArrayList yErrorsNeg;

    public DoubleErrorDataSet(DataSet2D another) {
        super(another.getName(), another.getDimension(), DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        this.set(another);
    }

    public DoubleErrorDataSet(String name) {
        this(name, 2);
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int initalSize, boolean deepCopy) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        int errorMin = Math.min(Math.min(yErrorsPos.length, yErrorsNeg.length), initalSize);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, dataMaxIndex);
        if (deepCopy) {
            int size = Math.min(dataMaxIndex, initalSize);
            this.xValues = new DoubleArrayList(initalSize);
            this.yValues = new DoubleArrayList(initalSize);
            this.yErrorsPos = new DoubleArrayList(initalSize);
            this.yErrorsNeg = new DoubleArrayList(initalSize);
            this.resize(initalSize);
            System.arraycopy(xValues, 0, this.xValues.elements(), 0, size);
            System.arraycopy(yValues, 0, this.yValues.elements(), 0, size);
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos.elements(), 0, size);
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg.elements(), 0, size);
        } else {
            this.xValues = DoubleArrayList.wrap((double[])xValues);
            this.yValues = DoubleArrayList.wrap((double[])yValues);
            this.yErrorsPos = DoubleArrayList.wrap((double[])yErrorsPos);
            this.yErrorsNeg = DoubleArrayList.wrap((double[])yErrorsNeg);
        }
    }

    public DoubleErrorDataSet(String name, int initalSize) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleArrayList(initalSize);
        this.yValues = new DoubleArrayList(initalSize);
        this.yErrorsPos = new DoubleArrayList(initalSize);
        this.yErrorsNeg = new DoubleArrayList(initalSize);
    }

    public DoubleErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(x);
            this.yValues.add(y);
            this.yErrorsNeg.add(yErrorNeg);
            this.yErrorsPos.add(yErrorPos);
            if (label != null && !label.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, label);
            }
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "add"));
    }

    public DoubleErrorDataSet add(double[] xValuesNew, double[] yValuesNew, double[] yErrorsNegNew, double[] yErrorsPosNew) {
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        this.lock().writeLockGuard(() -> {
            this.xValues.addElements(this.xValues.size(), xValuesNew);
            this.yValues.addElements(this.yValues.size(), yValuesNew);
            this.yErrorsNeg.addElements(this.yErrorsNeg.size(), yErrorsNegNew);
            this.yErrorsPos.addElements(this.yErrorsPos.size(), yErrorsPosNew);
            this.getAxisDescription(0).add(xValuesNew);
            this.getAxisDescription(1).add(yValuesNew);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet add(int index, double ... newValue) {
        return this.add(index, newValue[0], newValue[1]);
    }

    public DoubleErrorDataSet add(int index, double x, double y) {
        return this.add(index, x, y, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(index, x, y, yErrorNeg, yErrorPos, null);
    }

    public DoubleErrorDataSet add(int index, double x, double y, double yErrorNeg, double yErrorPos, String label) {
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.add(indexAt, x);
            this.yValues.add(indexAt, y);
            this.yErrorsNeg.add(indexAt, yErrorNeg);
            this.yErrorsPos.add(indexAt, yErrorPos);
            this.getDataLabelMap().addValueAndShiftKeys(indexAt, this.xValues.size(), label);
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleErrorDataSet add(int index, double[] x, double[] y, double[] yErrorNeg, double[] yErrorPos) {
        AssertUtils.notNull("X coordinates", x);
        AssertUtils.notNull("Y coordinates", y);
        AssertUtils.notNull("X coordinates", yErrorNeg);
        AssertUtils.notNull("Y coordinates", yErrorPos);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalDoubleArrays(x, y, min);
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.addElements(indexAt, x, 0, min);
            this.yValues.addElements(indexAt, y, 0, min);
            this.yErrorsNeg.addElements(indexAt, yErrorNeg, 0, min);
            this.yErrorsPos.addElements(indexAt, yErrorPos, 0, min);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            this.getDataLabelMap().shiftKeys(indexAt, this.xValues.size());
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleErrorDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.yErrorsPos.clear();
            this.yErrorsNeg.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.xValues.elements()[index] : this.yValues.elements()[index];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsNeg.elements()[index];
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsPos.elements()[index];
    }

    @Override
    public double[] getErrorsNegative(int dimIndex) {
        return dimIndex == 0 ? super.getErrorsPositive(dimIndex) : this.yErrorsNeg.elements();
    }

    @Override
    public double[] getErrorsPositive(int dimIndex) {
        return dimIndex == 0 ? super.getErrorsPositive(dimIndex) : this.yErrorsPos.elements();
    }

    @Override
    public final double[] getValues(int dimIndex) {
        return dimIndex == 0 ? this.xValues.elements() : this.yValues.elements();
    }

    @Override
    public double getX(int index) {
        return this.xValues.elements()[index];
    }

    @Override
    public double[] getXValues() {
        return this.xValues.elements();
    }

    @Override
    public double getY(int index) {
        return this.yValues.elements()[index];
    }

    @Override
    public double[] getYValues() {
        return this.yValues.elements();
    }

    public DoubleErrorDataSet increaseCapacity(int amount) {
        this.lock().writeLockGuard(() -> {
            int size = this.getDataCount();
            this.resize(this.getCapacity() + amount);
            this.resize(size);
        });
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public DoubleErrorDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            this.xValues.removeElements(fromIndex, toIndex);
            this.yValues.removeElements(fromIndex, toIndex);
            this.yErrorsNeg.removeElements(fromIndex, toIndex);
            this.yErrorsPos.removeElements(fromIndex, toIndex);
            this.getDataLabelMap().remove(fromIndex, toIndex);
            this.getDataLabelMap().remove(fromIndex, toIndex);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public DoubleErrorDataSet resize(int size) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(size);
            this.yValues.size(size);
            this.yErrorsPos.size(size);
            this.yErrorsNeg.size(size);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public DoubleErrorDataSet set(DataSet2D other) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            int index;
            this.getDataLabelMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(other.getStyle());
            if (other instanceof DataSetError) {
                this.set(other.getXValues(), other.getYValues(), ((DataSetError)((Object)other)).getErrorsNegative(1), ((DataSetError)((Object)other)).getErrorsPositive(1), true);
            } else {
                int count = other.getDataCount();
                this.set(other.getXValues(), other.getYValues(), new double[count], new double[count], true);
            }
        }));
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, true);
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, boolean copy) {
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        int errorMin = Math.min(yErrorsPos.length, yErrorsNeg.length);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, dataMaxIndex);
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (copy) {
                if (this.xValues == null) {
                    this.xValues = new DoubleArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new DoubleArrayList();
                }
                if (this.yErrorsPos == null) {
                    this.yErrorsPos = new DoubleArrayList();
                }
                if (this.yErrorsNeg == null) {
                    this.yErrorsNeg = new DoubleArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, xValues);
                this.yValues.addElements(0, yValues);
                this.yErrorsNeg.addElements(0, yErrorsNeg);
                this.yErrorsPos.addElements(0, yErrorsPos);
            } else {
                this.xValues = DoubleArrayList.wrap((double[])xValues);
                this.yValues = DoubleArrayList.wrap((double[])yValues);
                this.yErrorsNeg = DoubleArrayList.wrap((double[])yErrorsNeg);
                this.yErrorsPos = DoubleArrayList.wrap((double[])yErrorsPos);
            }
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet set(int index, double ... newValue) {
        return this.set(index, newValue[0], newValue[1]);
    }

    public DoubleErrorDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    public DoubleErrorDataSet set(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock().writeLockGuard(() -> {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = x;
            this.yValues.elements()[index] = y;
            this.yErrorsNeg.size(dataCount);
            this.yErrorsPos.size(dataCount);
            this.yErrorsNeg.elements()[index] = yErrorNeg;
            this.yErrorsPos.elements()[index] = yErrorPos;
            this.getDataLabelMap().remove(index);
            this.getDataStyleMap().remove(index);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - single"));
    }

    public DoubleErrorDataSet set(int index, double[] x, double[] y, double[] yErrorNeg, double[] yErrorPos) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(index + x.length, this.xValues.size()));
            System.arraycopy(x, 0, this.xValues.elements(), index, x.length);
            System.arraycopy(y, 0, this.yValues.elements(), index, y.length);
            System.arraycopy(yErrorNeg, 0, this.yErrorsNeg.elements(), index, yErrorNeg.length);
            System.arraycopy(yErrorPos, 0, this.yErrorsPos.elements(), index, yErrorPos.length);
            this.getDataLabelMap().remove(index, index + x.length);
            this.getDataStyleMap().remove(index, index + x.length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - via arrays"));
    }

    public DoubleErrorDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
            this.yErrorsPos.trim(0);
            this.yErrorsNeg.trim(0);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }
}

