/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.FragmentedDataSet;

public class RollingDataSet
extends FragmentedDataSet {
    private static final long serialVersionUID = -3110510420345581034L;
    private double lastLength;
    private int depth = 0;

    public RollingDataSet(String name) {
        super(name);
    }

    @Override
    public void add(DataSet set) {
        while (this.list.size() >= this.depth) {
            DataSet ds = (DataSet)this.list.remove(0);
            this.dataCount -= ds.getDataCount();
        }
        for (DataSet ds : this.list) {
            ((InternalDataSet)ds).shift(-this.lastLength);
        }
        this.list.add(new InternalDataSet(set));
        this.dataCount += set.getDataCount();
        this.lastLength = set.getAxisDescription(0).getMax();
        this.recomputeLimits(0);
        this.recomputeLimits(1);
        this.fireInvalidated(new AddedDataEvent(this));
    }

    public int getDepth() {
        return this.depth;
    }

    public double getLastLength() {
        return this.lastLength;
    }

    public void setDepth(int d) {
        this.depth = d;
    }

    private class InternalDataSet
    extends DoubleDataSet {
        public InternalDataSet(DataSet ds) {
            super(ds);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        }

        public void shift(double value) {
            this.lock().writeLockGuard(() -> {
                int i = 0;
                while (i < this.xValues.size()) {
                    double[] dArray = this.getXValues();
                    int n = i++;
                    dArray[n] = dArray[n] + value;
                }
            });
            this.fireInvalidated(new UpdatedDataEvent(this));
        }
    }
}

