/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.locks.DataSetLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransposedDataSet
implements DataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransposedDataSet.class);
    private static final long serialVersionUID = 2019092401L;
    protected final DataSet dataSet;
    protected int[] permutation;
    private boolean transposed;

    private TransposedDataSet(DataSet dataSet, boolean transposed) {
        if (dataSet == null) {
            throw new IllegalArgumentException("DataSet is null");
        }
        this.dataSet = dataSet;
        this.permutation = new int[dataSet.getDimension()];
        this.transposed = transposed;
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
        if (transposed) {
            this.permutation[0] = 1;
            this.permutation[1] = 0;
        }
    }

    private TransposedDataSet(DataSet dataSet, int[] permutation) {
        if (dataSet == null) {
            throw new IllegalArgumentException("DataSet is null");
        }
        if (permutation == null) {
            throw new IllegalArgumentException("permutation is null");
        }
        if (permutation.length < dataSet.getDimension()) {
            throw new IllegalArgumentException("insufficient permutation.lenght='" + permutation.length + "' w.r.t. DataSet dimensions (" + dataSet.getDimension() + ")");
        }
        for (int i = 0; i < dataSet.getDimension(); ++i) {
            if (permutation[i] < dataSet.getDimension()) continue;
            throw new IndexOutOfBoundsException("permutation[" + i + "] contains dimIndex='" + permutation[i] + "' outside DataSet dimension (" + dataSet.getDimension() + ")");
        }
        this.dataSet = dataSet;
        this.permutation = Arrays.copyOf(permutation, this.dataSet.getDimension());
        this.transposed = false;
    }

    @Override
    public AtomicBoolean autoNotification() {
        return this.dataSet.autoNotification();
    }

    @Override
    public double get(int dimIndex, int index) {
        return this.dataSet.get(this.permutation[dimIndex], index);
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        ArrayList<AxisDescription> result = new ArrayList<AxisDescription>();
        for (int dimIndex : this.permutation) {
            result.add(this.dataSet.getAxisDescription(dimIndex));
        }
        return result;
    }

    @Override
    public int getDataCount(int dimIndex) {
        return this.dataSet.getDataCount(this.permutation[dimIndex]);
    }

    @Override
    public String getDataLabel(int index) {
        return this.dataSet.getDataLabel(index);
    }

    @Override
    public int getDimension() {
        return this.permutation.length;
    }

    @Override
    public int getIndex(int dimIndex, double value) {
        return this.dataSet.getIndex(this.permutation[dimIndex], value);
    }

    @Override
    public String getName() {
        return this.dataSet.getName();
    }

    public int[] getPermutation() {
        return Arrays.copyOf(this.permutation, this.permutation.length);
    }

    @Override
    public String getStyle() {
        return this.dataSet.getStyle();
    }

    @Override
    public String getStyle(int index) {
        return this.dataSet.getStyle(index);
    }

    @Override
    public double getValue(int dimIndex, double x) {
        return this.dataSet.getValue(this.permutation[dimIndex], x);
    }

    @Override
    public double[] getValues(int dimIndex) {
        int n = this.getDataCount(this.permutation[dimIndex]);
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.get(dimIndex, i);
        }
        return retValues;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    @Override
    public <D extends DataSet> DataSetLock<D> lock() {
        return this.dataSet.lock();
    }

    @Override
    public DataSet recomputeLimits(int dimension) {
        return this.dataSet.recomputeLimits(this.permutation[dimension]);
    }

    public void setPermutation(int[] permutation) {
        if (permutation == null) {
            throw new IllegalArgumentException("permutation is null");
        }
        this.lock().writeLockGuard(() -> {
            if (permutation.length < this.dataSet.getDimension()) {
                throw new IllegalArgumentException("insufficient permutation.lenght='" + permutation.length + "' w.r.t. DataSet dimensions (" + this.dataSet.getDimension() + ")");
            }
            for (int i = 0; i < this.dataSet.getDimension(); ++i) {
                if (permutation[i] < this.dataSet.getDimension()) continue;
                throw new IndexOutOfBoundsException("permutation[" + i + "] contains dimIndex='" + permutation[i] + "' outside DataSet dimension (" + this.dataSet.getDimension() + ")");
            }
            this.permutation = Arrays.copyOf(permutation, this.dataSet.getDimension());
            if (this.transposed) {
                int tmp = this.permutation[1];
                this.permutation[1] = this.permutation[0];
                this.permutation[0] = tmp;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().addArgument((Object)this.permutation).log("applied permutation: {}");
            }
        });
        this.invokeListener(new AxisChangeEvent((EventSource)this, "Permutation changed", -1));
    }

    @Override
    public DataSet setStyle(String style) {
        return this.lock().writeLockGuard(() -> this.dataSet.setStyle(style));
    }

    public void setTransposed(boolean transposed) {
        this.lock().writeLockGuard(() -> {
            if (this.transposed != transposed) {
                int tmp = this.permutation[1];
                this.permutation[1] = this.permutation[0];
                this.permutation[0] = tmp;
                this.transposed = transposed;
            }
        });
        this.invokeListener(new AxisChangeEvent((EventSource)this, "(Un)transposed", -1));
    }

    @Override
    public List<EventListener> updateEventListener() {
        return this.dataSet.updateEventListener();
    }

    public static TransposedDataSet permute(DataSet dataSet, int[] permutation) {
        if (dataSet instanceof DataSet3D) {
            return new TransposedDataSet3D((DataSet3D)dataSet, permutation);
        }
        return new TransposedDataSet(dataSet, permutation);
    }

    public static TransposedDataSet transpose(DataSet dataSet) {
        return TransposedDataSet.transpose(dataSet, true);
    }

    public static TransposedDataSet transpose(DataSet dataSet, boolean transpose) {
        if (dataSet instanceof DataSet3D) {
            return new TransposedDataSet3D((DataSet3D)dataSet, transpose);
        }
        return new TransposedDataSet(dataSet, transpose);
    }

    public static class TransposedDataSet3D
    extends TransposedDataSet
    implements DataSet3D {
        private static final long serialVersionUID = 19092601L;

        private TransposedDataSet3D(DataSet3D dataSet, boolean transposed) {
            super((DataSet)dataSet, transposed);
        }

        private TransposedDataSet3D(DataSet3D dataSet, int[] permutation) {
            super((DataSet)dataSet, permutation);
            if (permutation[0] > 1 || permutation[1] > 1 || permutation[2] != 2) {
                throw new IllegalArgumentException("cannot swap first x or y dimension with z dimension (index missmatch)");
            }
        }

        @Override
        public int getDataCount() {
            return ((DataSet3D)this.dataSet).getDataCount();
        }

        @Override
        public int getXIndex(double x) {
            switch (this.permutation[0]) {
                case 0: {
                    return ((DataSet3D)this.dataSet).getXIndex(x);
                }
                case 1: {
                    return ((DataSet3D)this.dataSet).getYIndex(x);
                }
            }
            return 0;
        }

        @Override
        public int getYIndex(double y) {
            switch (this.permutation[1]) {
                case 0: {
                    return ((DataSet3D)this.dataSet).getXIndex(y);
                }
                case 1: {
                    return ((DataSet3D)this.dataSet).getYIndex(y);
                }
            }
            return 0;
        }

        @Override
        public double getZ(int xIndex, int yIndex) {
            return ((DataSet3D)this.dataSet).getZ(this.permutation[0] == 0 ? xIndex : yIndex, this.permutation[1] == 0 ? xIndex : yIndex);
        }

        @Override
        public void setPermutation(int[] permutation) {
            this.lock().writeLockGuard(() -> {
                if (permutation[0] > 1 || permutation[1] > 1 || permutation[2] != 2) {
                    throw new IllegalArgumentException("cannot swap first x or y dimension with z dimension (index missmatch)");
                }
                super.setPermutation(permutation);
            });
        }
    }
}

