/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

public class CircularBuffer<E> {
    private final E[] elements;
    private final int capacity;
    private int writePos;
    private boolean flipped;

    public CircularBuffer(int capacity) {
        this.capacity = capacity;
        this.elements = new Object[capacity];
        this.flipped = false;
    }

    public int available() {
        if (this.flipped) {
            return this.capacity;
        }
        return this.writePos;
    }

    public E get() {
        return this.get(0);
    }

    public E[] get(E[] into, int length) {
        return this.get(into, 0, length);
    }

    public E[] get(E[] into, int readPos, int length) {
        E[] retVal = into == null ? new Object[length] : into;
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.get(i + readPos);
        }
        return retVal;
    }

    public E get(int readPos) {
        int index;
        int n = index = this.flipped ? this.writePos + readPos : readPos;
        if (!this.flipped) {
            if (index >= 0) {
                return this.elements[index];
            }
            throw new IllegalArgumentException("writePos = '" + this.writePos + "' readPos = '" + readPos + "'/index = '" + index + "' is beyond circular buffer capacity limits = [0," + this.capacity + "]");
        }
        while (index < 0) {
            index += this.capacity;
        }
        while (index >= this.capacity) {
            index -= this.capacity;
        }
        return this.elements[index];
    }

    public boolean put(E element) {
        this.elements[this.writePos++] = element;
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return true;
    }

    public int put(E[] newElements, int length) {
        return this.put(newElements, 0, length);
    }

    public int put(E[] newElements, int startIndex, int length) {
        int lengthUpperHalf = this.capacity - this.writePos;
        if (length <= lengthUpperHalf) {
            System.arraycopy(newElements, startIndex, this.elements, this.writePos, length);
            this.writePos += length;
            if (this.writePos == this.capacity) {
                this.writePos = 0;
                this.flipped = true;
            }
            return this.writePos;
        }
        System.arraycopy(newElements, startIndex, this.elements, this.writePos, lengthUpperHalf);
        this.writePos = this.capacity - 1;
        this.writePos += lengthUpperHalf;
        if (this.writePos >= this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return this.put(newElements, startIndex + lengthUpperHalf, length - lengthUpperHalf);
    }

    public int remainingCapacity() {
        return this.capacity - this.available();
    }

    public void reset() {
        this.writePos = 0;
        this.flipped = false;
    }
}

