/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.event;

import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventThreadHelper;
import de.gsi.dataset.event.UpdateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public interface EventSource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void addListener(EventListener listener) {
        List<EventListener> list = this.updateEventListener();
        synchronized (list) {
            Objects.requireNonNull(listener, "UpdateListener must not be null");
            if (!this.updateEventListener().contains(listener)) {
                this.updateEventListener().add(listener);
            }
        }
    }

    public AtomicBoolean autoNotification();

    default public void invokeListener() {
        this.invokeListener(null);
    }

    default public void invokeListener(UpdateEvent updateEvent) {
        this.invokeListener(updateEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void invokeListener(UpdateEvent updateEvent, boolean executeParallel) {
        Object object = this.autoNotification();
        synchronized (object) {
            if (!this.autoNotification().get() || this.updateEventListener() == null) {
                return;
            }
        }
        object = this.updateEventListener();
        synchronized (object) {
            if (!executeParallel) {
                for (EventListener listener : this.updateEventListener()) {
                    listener.handle(updateEvent);
                }
                return;
            }
            UpdateEvent event = updateEvent == null ? new UpdateEvent(this) : updateEvent;
            ArrayList<Callable<Boolean>> workers = new ArrayList<Callable<Boolean>>();
            for (EventListener listener : this.updateEventListener()) {
                workers.add(() -> {
                    listener.handle(event);
                    return Boolean.TRUE;
                });
            }
            try {
                List jobs = EventThreadHelper.getExecutorService().invokeAll(workers);
                for (Future future : jobs) {
                    Boolean execstate = (Boolean)future.get();
                    if (execstate.booleanValue()) continue;
                    throw new IllegalStateException("one parallel worker thread finished execution with error");
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException("one parallel worker thread finished execution with error", e);
            }
        }
    }

    default public boolean isAutoNotification() {
        return this.autoNotification().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void removeListener(EventListener listener) {
        List<EventListener> list = this.updateEventListener();
        synchronized (list) {
            Objects.requireNonNull(listener, "UpdateListener must not be null");
            if (this.updateEventListener().contains(listener)) {
                this.updateEventListener().remove(listener);
            }
        }
    }

    public List<EventListener> updateEventListener();
}

