/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.DataType;
import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.ClassDescriptions;
import de.gsi.dataset.serializer.spi.FieldHeader;
import de.gsi.dataset.serializer.spi.GenericsHelper;
import de.gsi.dataset.utils.AssertUtils;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinarySerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinarySerialiser.class);
    private static final String READ_POSITION_AT_BUFFER_END = "read position at buffer end";
    public static final byte VERSION_MAJOR = 1;
    public static final byte VERSION_MINOR = 0;
    public static final byte VERSION_MICRO = 0;
    protected static final BinarySerialiser SELF;
    protected static HeaderInfo headerThis;
    private static int bufferIncrements;

    protected BinarySerialiser() {
    }

    public static void adjustDataByteSizeBlock(IoBuffer buffer, long sizeMarkerStart) {
        long sizeMarkerEnd = buffer.position();
        buffer.position(sizeMarkerStart);
        long expectedNumberOfBytes = sizeMarkerEnd - sizeMarkerStart;
        buffer.putInt((int)expectedNumberOfBytes);
        buffer.position(sizeMarkerEnd);
    }

    public static HeaderInfo checkHeaderInfo(IoBuffer readBuffer) {
        AssertUtils.notNull("readBuffer", readBuffer);
        FieldHeader headerStartField = BinarySerialiser.getFieldHeader(readBuffer);
        byte startMarker = readBuffer.getByte();
        if (startMarker != DataType.START_MARKER.getAsByte()) {
            throw new InvalidParameterException("header does not start with a START_MARKER('" + DataType.START_MARKER.getAsByte() + "') DataType but " + startMarker + " fieldName = " + headerStartField.getFieldName());
        }
        readBuffer.getString();
        String producer = readBuffer.getString();
        readBuffer.getString();
        byte major = readBuffer.getByte();
        byte minor = readBuffer.getByte();
        byte micro = readBuffer.getByte();
        BinarySerialiser binarySerialiser = SELF;
        binarySerialiser.getClass();
        HeaderInfo header = binarySerialiser.new HeaderInfo(producer, major, minor, micro);
        if (!header.isCompatible()) {
            String msg = String.format("byte buffer version incompatible: reveived '%s' vs. this '%s'", header.toString(), headerThis.toString());
            throw new IllegalStateException(msg);
        }
        return header;
    }

    public static int[] getArrayDimensions(IoBuffer readBuffer) {
        int arrayDims = readBuffer.getInt();
        int[] dims = new int[arrayDims];
        for (int i = 0; i < arrayDims; ++i) {
            dims[i] = readBuffer.getInt();
        }
        return dims;
    }

    public static boolean getBoolean(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getBoolean();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static boolean[] getBooleanArray(IoBuffer readBuffer) {
        return readBuffer.getBooleanArray();
    }

    public static int getBufferIncrements() {
        return bufferIncrements;
    }

    public static byte getByte(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getByte();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static byte[] getByteArray(IoBuffer readBuffer) {
        return readBuffer.getByteArray();
    }

    public static char[] getCharArray(IoBuffer readBuffer) {
        return readBuffer.getCharArray();
    }

    public static <E> Collection<E> getCollection(IoBuffer readBuffer, Collection<E> collection) {
        DataType valueDataType = DataType.fromByte(readBuffer.getByte());
        Object[] values = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, valueDataType);
        int nElements = values.length;
        ArrayList<Object> retCollection = collection == null ? new ArrayList<Object>(nElements) : collection;
        for (int i = 0; i < nElements; ++i) {
            retCollection.add(values[i]);
        }
        return retCollection;
    }

    public static double getDouble(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getDouble();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static double[] getDoubleArray(IoBuffer readBuffer) {
        return readBuffer.getDoubleArray();
    }

    public static double[] getDoubleArray(IoBuffer readBuffer, DataType dataType) {
        switch (dataType) {
            case BOOL_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getBooleanArray(readBuffer));
            }
            case BYTE_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getByteArray(readBuffer));
            }
            case SHORT_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getShortArray(readBuffer));
            }
            case INT_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getIntArray(readBuffer));
            }
            case LONG_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getLongArray(readBuffer));
            }
            case FLOAT_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getFloatArray(readBuffer));
            }
            case DOUBLE_ARRAY: {
                return BinarySerialiser.getDoubleArray(readBuffer);
            }
            case CHAR_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getCharArray(readBuffer));
            }
            case STRING_ARRAY: {
                return BinarySerialiser.toDoubles(BinarySerialiser.getStringArray(readBuffer));
            }
        }
        throw new IllegalArgumentException("dataType '" + (Object)((Object)dataType) + "' is not an array");
    }

    public static Enum<?> getEnum(IoBuffer readBuffer, Enum<?> enumeration) {
        String enumSimpleName = BinarySerialiser.getString(readBuffer);
        String enumName = BinarySerialiser.getString(readBuffer);
        String enumTypeList = BinarySerialiser.getString(readBuffer);
        String enumState = BinarySerialiser.getString(readBuffer);
        int enumOrdinal = BinarySerialiser.getInteger(readBuffer);
        Class<?> enumClass = ClassDescriptions.getClassByName(enumName);
        if (enumClass == null && (enumClass = ClassDescriptions.getClassByName(enumSimpleName)) == null) {
            throw new IllegalStateException("could not find enum class description '" + enumName + "' or '" + enumSimpleName + "'");
        }
        try {
            Method valueOf = enumClass.getMethod("valueOf", String.class);
            return (Enum)valueOf.invoke(null, enumState);
        }
        catch (ReflectiveOperationException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().setCause((Throwable)e).addArgument(enumClass).log("could not match 'valueOf(String)' function for class/(supposedly) enum of {}");
            }
            return null;
        }
    }

    public static String getEnumTypeList(IoBuffer readBuffer) {
        String enumSimpleName = BinarySerialiser.getString(readBuffer);
        String enumName = BinarySerialiser.getString(readBuffer);
        String enumTypeList = BinarySerialiser.getString(readBuffer);
        String enumState = BinarySerialiser.getString(readBuffer);
        int enumOrdinal = BinarySerialiser.getInteger(readBuffer);
        return enumTypeList;
    }

    public static FieldHeader getFieldHeader(IoBuffer readBuffer) {
        String fieldName = readBuffer.getString();
        byte dataTypeByte = readBuffer.getByte();
        DataType dataType = DataType.fromByte(dataTypeByte);
        if (dataType.isScalar()) {
            long pos = readBuffer.position();
            long nBytesToRead = dataType.equals((Object)DataType.STRING) ? (long)(readBuffer.getInt() + 4) : dataType.getPrimitiveSize();
            readBuffer.position(pos);
            return new FieldHeader(fieldName, dataType, new int[]{1}, readBuffer.position(), nBytesToRead);
        }
        long temp = readBuffer.position();
        int expectedNumberOfBytes = readBuffer.getInt();
        int arrayDims = readBuffer.getInt();
        int[] dims = new int[arrayDims];
        for (int i = 0; i < arrayDims; ++i) {
            dims[i] = readBuffer.getInt();
        }
        long readDataPosition = readBuffer.position();
        readBuffer.position(temp);
        return new FieldHeader(fieldName, dataType, dims, readDataPosition, expectedNumberOfBytes);
    }

    public static float getFloat(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getFloat();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static float[] getFloatArray(IoBuffer readBuffer) {
        return readBuffer.getFloatArray();
    }

    protected static Object[] getGenericArrayAsPrimitive(IoBuffer readBuffer, DataType dataType) {
        Object[] retVal;
        switch (dataType) {
            case BOOL: {
                retVal = GenericsHelper.toObject(readBuffer.getBooleanArray());
                break;
            }
            case BYTE: {
                retVal = GenericsHelper.toObject(readBuffer.getByteArray());
                break;
            }
            case SHORT: {
                retVal = GenericsHelper.toObject(readBuffer.getShortArray());
                break;
            }
            case INT: {
                retVal = GenericsHelper.toObject(readBuffer.getIntArray());
                break;
            }
            case LONG: {
                retVal = GenericsHelper.toObject(readBuffer.getLongArray());
                break;
            }
            case FLOAT: {
                retVal = GenericsHelper.toObject(readBuffer.getFloatArray());
                break;
            }
            case DOUBLE: {
                retVal = GenericsHelper.toObject(readBuffer.getDoubleArray());
                break;
            }
            case STRING: {
                retVal = readBuffer.getStringArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("type not implemented - " + (Object)((Object)dataType));
            }
        }
        return retVal;
    }

    public static int[] getIntArray(IoBuffer readBuffer) {
        return readBuffer.getIntArray();
    }

    public static int getInteger(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getInt();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static <E> List<E> getList(IoBuffer readBuffer, List<E> collection) {
        DataType valueDataType = DataType.fromByte(readBuffer.getByte());
        Object[] values = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, valueDataType);
        int nElements = values.length;
        ArrayList<Object> retCollection = collection == null ? new ArrayList<Object>(nElements) : collection;
        for (int i = 0; i < nElements; ++i) {
            retCollection.add(values[i]);
        }
        return retCollection;
    }

    public static long getLong(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getLong();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static long[] getLongArray(IoBuffer readBuffer) {
        return readBuffer.getLongArray();
    }

    public static <K, V> Map<K, V> getMap(IoBuffer readBuffer, Map<K, V> map) {
        DataType keyDataType = DataType.fromByte(readBuffer.getByte());
        DataType valueDataType = DataType.fromByte(readBuffer.getByte());
        Object[] keys = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, keyDataType);
        Object[] values = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, valueDataType);
        ConcurrentHashMap<Object, Object> retMap = map == null ? new ConcurrentHashMap<Object, Object>() : map;
        for (int i = 0; i < keys.length; ++i) {
            retMap.put(keys[i], values[i]);
        }
        return retMap;
    }

    private static int getNumberOfElements(int[] dimensions) {
        AssertUtils.notNull("dimensions", dimensions);
        int ret = 1;
        for (int i = 0; i < dimensions.length; ++i) {
            int dim = dimensions[i];
            if (i > 0) {
                AssertUtils.gtThanZero("dimensions[" + i + "]", dim);
            }
            ret *= dim;
        }
        return ret;
    }

    public static <E> Queue<E> getQueue(IoBuffer readBuffer, Queue<E> collection) {
        DataType valueDataType = DataType.fromByte(readBuffer.getByte());
        Object[] values = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, valueDataType);
        int nElements = values.length;
        PriorityQueue<Object> retCollection = collection == null ? new PriorityQueue<Object>(nElements) : collection;
        for (int i = 0; i < nElements; ++i) {
            retCollection.add(values[i]);
        }
        return retCollection;
    }

    public static <E> Set<E> getSet(IoBuffer readBuffer, Set<E> collection) {
        DataType valueDataType = DataType.fromByte(readBuffer.getByte());
        Object[] values = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, valueDataType);
        int nElements = values.length;
        HashSet<Object> retCollection = collection == null ? new HashSet<Object>(nElements) : collection;
        for (int i = 0; i < nElements; ++i) {
            retCollection.add(values[i]);
        }
        return retCollection;
    }

    public static short getShort(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getShort();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static short[] getShortArray(IoBuffer readBuffer) {
        return readBuffer.getShortArray();
    }

    public static String getString(IoBuffer readBuffer) {
        if (readBuffer.hasRemaining()) {
            return readBuffer.getString();
        }
        return null;
    }

    public static String[] getStringArray(IoBuffer readBuffer) {
        return readBuffer.getStringArray();
    }

    public static FieldHeader parseIoStream(IoBuffer buffer) {
        FieldHeader fieldRoot = new FieldHeader("ROOT", DataType.START_MARKER, new int[]{0}, buffer.position(), 100L);
        BinarySerialiser.parseIoStream(buffer, fieldRoot, 0);
        return fieldRoot;
    }

    protected static void parseIoStream(IoBuffer buffer, FieldHeader fieldRoot, int recursionDepth) {
        FieldHeader fieldHeader;
        while ((fieldHeader = BinarySerialiser.getFieldHeader(buffer)) != null) {
            byte markerValue;
            long bytesToSkip = fieldHeader.getExpectedNumberOfDataBytes();
            long skipPosition = buffer.position() + bytesToSkip;
            fieldRoot.getChildren().add(fieldHeader);
            if (fieldHeader.getDataType().equals((Object)DataType.END_MARKER)) {
                markerValue = buffer.getByte();
                if (DataType.END_MARKER.getAsByte() == markerValue) break;
                throw new IllegalStateException("reached end marker, mismatched value '" + markerValue + "' vs. should '" + DataType.END_MARKER.getAsByte() + "'");
            }
            if (bytesToSkip < 0L) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.atWarn().addArgument((Object)fieldHeader.getFieldName()).addArgument((Object)fieldHeader.getDataType()).addArgument((Object)bytesToSkip).log("FieldHeader for '{}' type '{}' has bytesToSkip '{} <= 0'");
                }
                BinarySerialiser.swallowRest(buffer, fieldHeader);
            } else {
                buffer.position(skipPosition);
            }
            if (!fieldHeader.getDataType().equals((Object)DataType.START_MARKER)) continue;
            buffer.position(fieldHeader.getDataBufferPosition());
            markerValue = buffer.getByte();
            if (DataType.START_MARKER.getAsByte() != markerValue) {
                throw new IllegalStateException("reached start marker, mismatched value '" + markerValue + "' vs. should '" + DataType.START_MARKER.getAsByte() + "'");
            }
            BinarySerialiser.parseIoStream(buffer, fieldHeader, recursionDepth + 1);
        }
    }

    public static void put(IoBuffer buffer, String fieldName, boolean value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.BOOL);
        buffer.putBoolean(value);
    }

    public static void put(IoBuffer buffer, String fieldName, boolean[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, boolean[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.BOOL_ARRAY, dims, nElements);
        buffer.putBooleanArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, byte value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.BYTE);
        buffer.putByte(value);
    }

    public static void put(IoBuffer buffer, String fieldName, byte[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, byte[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.BYTE_ARRAY, dims, nElements);
        buffer.putByteArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static <E> void put(IoBuffer buffer, String fieldName, Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Object[] values = collection.toArray();
        int nElements = collection.size();
        DataType valueDataType = DataType.fromClassType(values[0].getClass());
        int entrySize = 17;
        DataType dataType = DataType.COLLECTION;
        if (collection instanceof List) {
            dataType = DataType.LIST;
        } else if (collection instanceof Queue) {
            dataType = DataType.QUEUE;
        } else if (collection instanceof Set) {
            dataType = DataType.SET;
        }
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, dataType, new int[]{nElements}, nElements * 17 + 9);
        buffer.putByte(valueDataType.getAsByte());
        BinarySerialiser.putGenericArrayAsPrimitive(buffer, valueDataType, values, nElements);
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, double value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.DOUBLE);
        buffer.putDouble(value);
    }

    public static void put(IoBuffer buffer, String fieldName, double[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, double[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.DOUBLE_ARRAY, dims, nElements);
        buffer.putDoubleArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, Enum<?> enumeration) {
        if (enumeration == null) {
            return;
        }
        Class<?> clazz = enumeration.getClass();
        if (clazz == null) {
            return;
        }
        Enum[] enumConsts = (Enum[])clazz.getEnumConstants();
        if (enumConsts == null) {
            return;
        }
        boolean nElements = true;
        int entrySize = 17;
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.ENUM, new int[]{1}, 26);
        String typeList = Arrays.asList(clazz.getEnumConstants()).stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        buffer.putString(clazz.getSimpleName());
        buffer.putString(enumeration.getClass().getName());
        buffer.putString(typeList);
        buffer.putString(enumeration.name());
        buffer.putInt(enumeration.ordinal());
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, float value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.FLOAT);
        buffer.putFloat(value);
    }

    public static void put(IoBuffer buffer, String fieldName, float[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, float[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.FLOAT_ARRAY, dims, nElements);
        buffer.putFloatArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, int value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.INT);
        buffer.putInt(value);
    }

    public static void put(IoBuffer buffer, String fieldName, int[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, int[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.INT_ARRAY, dims, nElements);
        buffer.putIntArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, long value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.LONG);
        buffer.putLong(value);
    }

    public static void put(IoBuffer buffer, String fieldName, long[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, long[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.LONG_ARRAY, dims, nElements);
        buffer.putLongArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static <K, V> void put(IoBuffer buffer, String fieldName, Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Object[] keySet = map.keySet().toArray();
        Object[] valueSet = map.values().toArray();
        int nElements = keySet.length;
        DataType keyDataType = DataType.fromClassType(keySet[0].getClass());
        DataType valueDataType = DataType.fromClassType(valueSet[0].getClass());
        int entrySize = 17;
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.MAP, new int[]{nElements}, nElements * 17 + 9);
        buffer.putByte(keyDataType.getAsByte());
        buffer.putByte(valueDataType.getAsByte());
        BinarySerialiser.putGenericArrayAsPrimitive(buffer, keyDataType, keySet, nElements);
        BinarySerialiser.putGenericArrayAsPrimitive(buffer, valueDataType, valueSet, nElements);
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, short value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.SHORT);
        buffer.putShort(value);
    }

    public static void put(IoBuffer buffer, String fieldName, short[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, short[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.SHORT_ARRAY, dims, nElements);
        buffer.putShortArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static void put(IoBuffer buffer, String fieldName, String value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.STRING, (value == null ? 1 : value.length()) + 1);
        buffer.putString(value == null ? "" : value);
    }

    public static void put(IoBuffer buffer, String fieldName, String[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(IoBuffer buffer, String fieldName, String[] arrayValue, int[] dims) {
        if (arrayValue == null || arrayValue.length == 0) {
            return;
        }
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        long sizeMarkerStart = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.STRING_ARRAY, dims, nElements);
        buffer.putStringArray(arrayValue, Math.min(nElements, arrayValue.length));
        BinarySerialiser.adjustDataByteSizeBlock(buffer, sizeMarkerStart);
    }

    public static long putArrayHeader(IoBuffer buffer, String fieldName, DataType dataType, int[] dims, int nElements) {
        AssertUtils.notNull("dims", dims);
        int arrayByteSize = nElements * (int)dataType.getPrimitiveSize();
        int addBufferSize = (dims.length + 6) * 4 + arrayByteSize;
        BinarySerialiser.putFieldHeader(buffer, fieldName, dataType, addBufferSize);
        long sizeMarkerStart = buffer.position();
        buffer.putInt(-1);
        buffer.putInt(dims.length);
        for (int dim : dims) {
            buffer.putInt(dim);
        }
        return sizeMarkerStart;
    }

    public static void putEndMarker(IoBuffer buffer, String markerName) {
        BinarySerialiser.putFieldHeader(buffer, markerName, DataType.END_MARKER);
        buffer.putByte(DataType.END_MARKER.getAsByte());
    }

    public static void putFieldHeader(IoBuffer buffer, String fieldName, DataType dataType) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, dataType, 0);
    }

    public static void putFieldHeader(IoBuffer buffer, String fieldName, DataType dataType, int additionalSize) {
        AssertUtils.notNull("buffer", buffer);
        AssertUtils.notNull("fieldName", fieldName);
        long addCapacity = (long)(fieldName.length() + 1 + 4 + 1) * 1L + (long)bufferIncrements + dataType.getPrimitiveSize() + (long)additionalSize;
        buffer.ensureAdditionalCapacity(addCapacity);
        buffer.putString(fieldName);
        buffer.putByte(dataType.getAsByte());
    }

    public static void putGenericArrayAsPrimitive(IoBuffer buffer, DataType dataType, Object[] data, int nToCopy) {
        switch (dataType) {
            case BOOL: {
                buffer.putBooleanArray(GenericsHelper.toBoolPrimitive(data), nToCopy);
                break;
            }
            case BYTE: {
                buffer.putByteArray(GenericsHelper.toBytePrimitive(data), nToCopy);
                break;
            }
            case SHORT: {
                buffer.putShortArray(GenericsHelper.toShortPrimitive(data), nToCopy);
                break;
            }
            case INT: {
                buffer.putIntArray(GenericsHelper.toIntegerPrimitive(data), nToCopy);
                break;
            }
            case LONG: {
                buffer.putLongArray(GenericsHelper.toLongPrimitive(data), nToCopy);
                break;
            }
            case FLOAT: {
                buffer.putFloatArray(GenericsHelper.toFloatPrimitive(data), nToCopy);
                break;
            }
            case DOUBLE: {
                buffer.putDoubleArray(GenericsHelper.toDoublePrimitive(data), nToCopy);
                break;
            }
            case STRING: {
                buffer.putStringArray(GenericsHelper.toStringPrimitive(data), nToCopy);
                break;
            }
            default: {
                throw new IllegalArgumentException("type not implemented - " + data[0].getClass().getSimpleName());
            }
        }
    }

    public static void putHeaderInfo(IoBuffer buffer) {
        AssertUtils.notNull("buffer", buffer);
        long addCapacity = 20 + "OBJ_ROOT_START".length() + "#file producer : ".length() + BinarySerialiser.class.getCanonicalName().length();
        buffer.ensureAdditionalCapacity(addCapacity);
        BinarySerialiser.putStartMarker(buffer, "OBJ_ROOT_START");
        buffer.putString("#file producer : ");
        buffer.putString(BinarySerialiser.class.getCanonicalName());
        buffer.putString("\n");
        buffer.putByte((byte)1);
        buffer.putByte((byte)0);
        buffer.putByte((byte)0);
    }

    public static void putStartMarker(IoBuffer buffer, String markerName) {
        BinarySerialiser.putFieldHeader(buffer, markerName, DataType.START_MARKER);
        buffer.putByte(DataType.START_MARKER.getAsByte());
    }

    public static void setBufferIncrements(int bufferIncrements) {
        AssertUtils.gtEqThanZero("bufferIncrements", bufferIncrements);
        BinarySerialiser.bufferIncrements = bufferIncrements;
    }

    protected static void swallowRest(IoBuffer readBuffer, FieldHeader fieldHeader) {
        Object leftOver = null;
        int size = -1;
        switch (fieldHeader.getDataType()) {
            case BOOL: {
                leftOver = BinarySerialiser.getBoolean(readBuffer);
                break;
            }
            case BYTE: {
                leftOver = BinarySerialiser.getByte(readBuffer);
                break;
            }
            case SHORT: {
                leftOver = BinarySerialiser.getShort(readBuffer);
                break;
            }
            case INT: {
                leftOver = BinarySerialiser.getInteger(readBuffer);
                break;
            }
            case LONG: {
                leftOver = BinarySerialiser.getLong(readBuffer);
                break;
            }
            case FLOAT: {
                leftOver = Float.valueOf(BinarySerialiser.getFloat(readBuffer));
                break;
            }
            case DOUBLE: {
                leftOver = BinarySerialiser.getDouble(readBuffer);
                break;
            }
            case STRING: {
                leftOver = BinarySerialiser.getString(readBuffer);
                break;
            }
            case BOOL_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getBooleanArray(readBuffer);
                break;
            }
            case BYTE_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getByteArray(readBuffer);
                break;
            }
            case SHORT_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getShortArray(readBuffer);
                break;
            }
            case INT_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getIntArray(readBuffer);
                break;
            }
            case LONG_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getLongArray(readBuffer);
                break;
            }
            case FLOAT_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getFloatArray(readBuffer);
                break;
            }
            case DOUBLE_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getDoubleArray(readBuffer);
                break;
            }
            case STRING_ARRAY: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getStringArray(readBuffer);
                break;
            }
            case MAP: {
                size = readBuffer.getInt();
                leftOver = BinarySerialiser.getMap(readBuffer, new ConcurrentHashMap());
                break;
            }
            case END_MARKER: {
                byte endMarker = BinarySerialiser.getByte(readBuffer);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.atDebug().addArgument((Object)fieldHeader).addArgument((Object)Byte.toString(endMarker)).log("swallowed '{}'='{}'");
                break;
            }
            default: {
                throw new IllegalArgumentException("encountered unknown format for " + fieldHeader.toString());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)fieldHeader).addArgument(leftOver).addArgument((Object)size).log("swallowed unused element '%s{}'='%s{}' size = {}");
        }
    }

    private static double[] toDoubles(boolean[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i] ? 1.0 : 0.0;
        }
        return doubleArray;
    }

    private static double[] toDoubles(byte[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    private static double[] toDoubles(char[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    private static double[] toDoubles(float[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    private static double[] toDoubles(int[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    private static double[] toDoubles(long[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    private static double[] toDoubles(short[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    private static double[] toDoubles(String[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i] == null ? Double.NaN : Double.parseDouble(input[i]);
        }
        return doubleArray;
    }

    static {
        BinarySerialiser binarySerialiser = SELF = new BinarySerialiser();
        binarySerialiser.getClass();
        headerThis = binarySerialiser.new HeaderInfo(BinarySerialiser.class.getSimpleName(), 1, 0, 0);
    }

    public class HeaderInfo {
        private final String producerName;
        private final byte versionMajor;
        private final byte versionMinor;
        private final byte versionMicro;

        private HeaderInfo(String producer, byte major, byte minor, byte micro) {
            this.producerName = producer;
            this.versionMajor = major;
            this.versionMinor = minor;
            this.versionMicro = micro;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HeaderInfo)) {
                return false;
            }
            HeaderInfo other = (HeaderInfo)obj;
            return other.isCompatible();
        }

        public String getProducerName() {
            return this.producerName;
        }

        public byte getVersionMajor() {
            return this.versionMajor;
        }

        public byte getVersionMicro() {
            return this.versionMicro;
        }

        public byte getVersionMinor() {
            return this.versionMinor;
        }

        public int hashCode() {
            return this.producerName.hashCode();
        }

        public boolean isCompatible() {
            return this.getVersionMajor() <= 1;
        }

        public String toString() {
            return String.format("%s-v%d.%d.%d", this.getProducerName(), this.getVersionMajor(), this.getVersionMinor(), this.getVersionMicro());
        }
    }
}

