/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.event;

import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.utils.DoubleCircularBuffer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class EventRateLimiter
implements EventListener {
    private static final int MAX_RATE_BUFFER = 20;
    private static final AtomicInteger serialCounter = new AtomicInteger(0);
    private final Timer timer = new Timer(EventRateLimiter.class.getSimpleName() + serialCounter.getAndIncrement(), true);
    private final AtomicBoolean rateLimitActive = new AtomicBoolean(false);
    private final Object lock = new Object();
    private final DoubleCircularBuffer rateEstimatorBuffer = new DoubleCircularBuffer(20);
    private final EventListener eventListener;
    private final long minUpdatePeriod;
    private final double maxUpdateRate;
    private final UpdateStrategy updateStrategy;
    private long lastUpdateMillis = System.currentTimeMillis();
    private UpdateEvent lastUpdateEvent;

    public EventRateLimiter(EventListener eventListener, long minUpdatePeriod) {
        this(eventListener, minUpdatePeriod, null);
    }

    public EventRateLimiter(EventListener eventListener, long minUpdatePeriod, UpdateStrategy updateStrategy) {
        this.eventListener = eventListener;
        this.minUpdatePeriod = minUpdatePeriod;
        this.maxUpdateRate = 1000.0 / (double)minUpdatePeriod;
        this.updateStrategy = updateStrategy == null ? UpdateStrategy.INSTANTANEOUS_RATE : updateStrategy;
        this.rateEstimatorBuffer.put(this.lastUpdateMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRateEstimate() {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.rateEstimatorBuffer.available() <= 1) {
                long diff = Math.abs(now - this.lastUpdateMillis);
                double d = diff >= 1L ? 1000.0 / (double)diff : 1.0;
                return d;
            }
            double lastUpate = now;
            int nData = this.rateEstimatorBuffer.available();
            double diff = 0.0;
            for (int i = 0; i < nData; ++i) {
                double timeStamp = this.rateEstimatorBuffer.get(i);
                diff += Math.abs(timeStamp - lastUpate);
                lastUpate = timeStamp;
            }
            double avgPeriod = diff / (double)nData;
            return 2000.0 / avgPeriod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(UpdateEvent event) {
        long now = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.lastUpdateEvent = event;
            long diff = now - this.lastUpdateMillis;
            boolean suppressUpdate = false;
            switch (this.updateStrategy) {
                case AVERAGE_RATE: {
                    suppressUpdate = this.getRateEstimate() > this.maxUpdateRate;
                    break;
                }
                default: {
                    boolean bl = suppressUpdate = diff < this.minUpdatePeriod;
                }
            }
            if (suppressUpdate) {
                if (this.rateLimitActive.compareAndSet(false, true)) {
                    this.timer.schedule((TimerTask)new DelayedUpdateTask(), this.minUpdatePeriod);
                }
                return;
            }
            this.rateEstimatorBuffer.put(now);
            this.lastUpdateMillis = now;
        }
        this.eventListener.handle(event);
    }

    protected class DelayedUpdateTask
    extends TimerTask {
        protected DelayedUpdateTask() {
        }

        @Override
        public void run() {
            EventRateLimiter.this.rateLimitActive.set(false);
            EventRateLimiter.this.handle(EventRateLimiter.this.lastUpdateEvent);
        }
    }

    public static enum UpdateStrategy {
        INSTANTANEOUS_RATE,
        AVERAGE_RATE;

    }
}

