/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.HashMapHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ObjectObjectMap<K, V>
implements Map<K, V> {
    private static final String NOT_IMPLEMENTED = "not implemented";
    private static final Object FREE_KEY = new Object();
    private static final Object REMOVED_KEY = new Object();
    private Object[] data;
    private Object nullValue;
    private boolean hasNull;
    private final float fillFactor;
    private int threshold;
    private int sizeInternal;
    private int mask;
    private int mask2;

    public ObjectObjectMap(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = HashMapHelper.arraySize(size, fillFactor);
        this.mask = capacity - 1;
        this.mask2 = capacity * 2 - 1;
        this.fillFactor = fillFactor;
        this.data = new Object[capacity * 2];
        Arrays.fill(this.data, FREE_KEY);
        this.threshold = (int)((float)capacity * fillFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, FREE_KEY);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return (V)this.nullValue;
        }
        int ptr = (key.hashCode() & this.mask) << 1;
        Object k = this.data[ptr];
        if (k.equals(FREE_KEY)) {
            return null;
        }
        if (k.equals(key)) {
            return (V)this.data[ptr + 1];
        }
        do {
            if (!(k = this.data[ptr = ptr + 2 & this.mask2]).equals(FREE_KEY)) continue;
            return null;
        } while (!k.equals(key));
        return (V)this.data[ptr + 1];
    }

    public int getStartIndex(Object key) {
        return key.hashCode() & this.mask;
    }

    private V insertNullKey(V value) {
        if (this.hasNull) {
            Object ret = this.nullValue;
            this.nullValue = value;
            return (V)ret;
        }
        this.nullValue = value;
        ++this.sizeInternal;
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.sizeInternal == 0;
    }

    @Override
    public Set<K> keySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return this.insertNullKey(value);
        }
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.data[ptr];
        if (k.equals(FREE_KEY)) {
            this.data[ptr] = key;
            this.data[ptr + 1] = value;
            if (this.sizeInternal >= this.threshold) {
                this.rehash(this.data.length * 2);
            } else {
                ++this.sizeInternal;
            }
            return null;
        }
        if (k.equals(key)) {
            Object ret = this.data[ptr + 1];
            this.data[ptr + 1] = value;
            return (V)ret;
        }
        int firstRemoved = -1;
        if (k.equals(REMOVED_KEY)) {
            firstRemoved = ptr;
        }
        while (true) {
            if ((k = this.data[ptr = ptr + 2 & this.mask2]).equals(FREE_KEY)) {
                if (firstRemoved != -1) {
                    ptr = firstRemoved;
                }
                this.data[ptr] = key;
                this.data[ptr + 1] = value;
                if (this.sizeInternal >= this.threshold) {
                    this.rehash(this.data.length * 2);
                } else {
                    ++this.sizeInternal;
                }
                return null;
            }
            if (k.equals(key)) {
                Object ret = this.data[ptr + 1];
                this.data[ptr + 1] = value;
                return (V)ret;
            }
            if (!k.equals(REMOVED_KEY) || firstRemoved != -1) continue;
            firstRemoved = ptr;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    private void rehash(int newCapacity) {
        this.threshold = (int)((double)newCapacity / 2.0 * (double)this.fillFactor);
        this.mask = newCapacity / 2 - 1;
        this.mask2 = newCapacity - 1;
        int oldCapacity = this.data.length;
        Object[] oldData = this.data;
        this.data = new Object[newCapacity];
        Arrays.fill(this.data, FREE_KEY);
        this.sizeInternal = this.hasNull ? 1 : 0;
        for (int i = 0; i < oldCapacity; i += 2) {
            Object oldKey = oldData[i];
            if (oldKey.equals(FREE_KEY) || oldKey.equals(REMOVED_KEY)) continue;
            this.put(oldKey, oldData[i + 1]);
        }
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.data[ptr];
        if (k.equals(FREE_KEY)) {
            return null;
        }
        if (k.equals(key)) {
            --this.sizeInternal;
            this.data[ptr] = this.data[ptr + 2 & this.mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
            Object ret = this.data[ptr + 1];
            this.data[ptr + 1] = null;
            return (V)ret;
        }
        do {
            if (!(k = this.data[ptr = ptr + 2 & this.mask2]).equals(FREE_KEY)) continue;
            return null;
        } while (!k.equals(key));
        --this.sizeInternal;
        this.data[ptr] = this.data[ptr + 2 & this.mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
        Object ret = this.data[ptr + 1];
        this.data[ptr + 1] = null;
        return (V)ret;
    }

    private V removeNullKey() {
        if (this.hasNull) {
            Object ret = this.nullValue;
            this.nullValue = null;
            this.hasNull = false;
            --this.sizeInternal;
            return (V)ret;
        }
        return null;
    }

    @Override
    public int size() {
        return this.sizeInternal;
    }

    @Override
    public Collection<V> values() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }
}

