/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.FastByteBuffer;
import de.gsi.dataset.serializer.spi.FieldHeader;

public class BinaryArrayFactory
extends BinarySerialiser {
    protected BinaryArrayFactory() {
    }

    public static void put(FastByteBuffer buffer, String fieldName, double[][] matrix) {
        if (matrix == null || matrix.length == 0 || matrix[0].length == 0) {
            return;
        }
        int[] dims = new int[]{matrix.length, matrix[0].length};
        double[] serialisedMatrix = new double[dims[0] * dims[1]];
        for (int i = 0; i < dims[0]; ++i) {
            for (int j = 0; j < dims[1]; ++j) {
                serialisedMatrix[i * dims[1] + j] = matrix[i][j];
            }
        }
        BinarySerialiser.put((IoBuffer)buffer, fieldName, serialisedMatrix, dims);
    }

    public static double[][] readDoubleMatrix(IoBuffer buffer, FieldHeader fieldHeader) {
        if (fieldHeader.getDataDimension() != 2) {
            throw new IllegalArgumentException("2-dim array required, field is for n-dim=" + fieldHeader.getDataDimension());
        }
        double[] serialisedMatrix = buffer.getDoubleArray();
        int dim1 = fieldHeader.getDataDimensions()[0];
        int dim2 = fieldHeader.getDataDimensions()[1];
        double[][] matrix = new double[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                matrix[i][j] = serialisedMatrix[i * dim2 + j];
            }
        }
        return matrix;
    }
}

