/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.IoBuffer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ByteBuffer
implements IoBuffer {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    public static final long SIZE_OF_BOOLEAN = 1L;
    public static final long SIZE_OF_BYTE = 1L;
    public static final long SIZE_OF_SHORT = 2L;
    public static final long SIZE_OF_CHAR = 2L;
    public static final long SIZE_OF_INT = 4L;
    public static final long SIZE_OF_LONG = 8L;
    public static final long SIZE_OF_FLOAT = 4L;
    public static final long SIZE_OF_DOUBLE = 8L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final java.nio.ByteBuffer nioByteBuffer;

    public ByteBuffer() {
        this(1000);
    }

    public ByteBuffer(int nCapacity) {
        this.nioByteBuffer = java.nio.ByteBuffer.wrap(new byte[nCapacity]);
        this.nioByteBuffer.mark();
    }

    @Override
    public int capacity() {
        return this.nioByteBuffer.capacity();
    }

    @Override
    public IoBuffer clear() {
        this.nioByteBuffer.clear();
        return this;
    }

    @Override
    public IoBuffer ensureAdditionalCapacity(long capacity) {
        return this;
    }

    @Override
    public IoBuffer ensureCapacity(long capacity) {
        return this;
    }

    @Override
    public IoBuffer forceCapacity(long length, long preserve) {
        return this;
    }

    @Override
    public boolean getBoolean() {
        return this.nioByteBuffer.get() > 0;
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, long offset, int length) {
        int arraySize = this.getInt();
        boolean[] ret = dst == null ? new boolean[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getBoolean();
        }
        return ret;
    }

    @Override
    public byte getByte() {
        return this.nioByteBuffer.get();
    }

    @Override
    public byte[] getByteArray(byte[] dst, long offset, int length) {
        int arraySize = this.getInt();
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        byte[] ret = dst == null ? new byte[bytesToCopy + (int)offset] : dst;
        this.nioByteBuffer.get(ret, (int)offset, bytesToCopy);
        return ret;
    }

    @Override
    public char getChar() {
        return this.nioByteBuffer.getChar();
    }

    @Override
    public char[] getCharArray(char[] dst, long offset, int length) {
        int arraySize = this.getInt();
        char[] ret = dst == null ? new char[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getChar();
        }
        return ret;
    }

    @Override
    public double getDouble() {
        return this.nioByteBuffer.getDouble();
    }

    @Override
    public double[] getDoubleArray(double[] dst, long offset, int length) {
        int arraySize = this.getInt();
        double[] ret = dst == null ? new double[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getDouble();
        }
        return ret;
    }

    @Override
    public float getFloat() {
        return this.nioByteBuffer.getFloat();
    }

    @Override
    public float[] getFloatArray(float[] dst, long offset, int length) {
        int arraySize = this.getInt();
        float[] ret = dst == null ? new float[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getFloat();
        }
        return ret;
    }

    @Override
    public int getInt() {
        return this.nioByteBuffer.getInt();
    }

    @Override
    public int[] getIntArray(int[] dst, long offset, int length) {
        int arraySize = this.getInt();
        int[] ret = dst == null ? new int[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getInt();
        }
        return ret;
    }

    @Override
    public long getLong() {
        return this.nioByteBuffer.getLong();
    }

    @Override
    public long[] getLongArray(long[] dst, long offset, int length) {
        int arraySize = this.getInt();
        long[] ret = dst == null ? new long[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getLong();
        }
        return ret;
    }

    @Override
    public short getShort() {
        return this.nioByteBuffer.getShort();
    }

    @Override
    public short[] getShortArray(short[] dst, long offset, int length) {
        int arraySize = this.getInt();
        short[] ret = dst == null ? new short[arraySize + (int)offset] : dst;
        int bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        int end = (int)offset + bytesToCopy;
        for (int i = (int)offset; i < end; ++i) {
            ret[i] = this.getShort();
        }
        return ret;
    }

    @Override
    public String getString() {
        int arraySize = this.getInt() - 1;
        byte[] values = new byte[arraySize];
        this.nioByteBuffer.get(values, 0, arraySize);
        this.getByte();
        return new String(values);
    }

    @Override
    public String[] getStringArray(String[] dst, long offset, int length) {
        int arraySize = this.getInt();
        String[] ret = dst == null ? new String[arraySize] : dst;
        int size = dst == null ? arraySize : Math.min(arraySize, length);
        for (int k = 0; k < size; ++k) {
            ret[k + (int)offset] = this.getString();
        }
        return ret;
    }

    @Override
    public boolean hasRemaining() {
        return this.nioByteBuffer.hasRemaining();
    }

    @Override
    public boolean isReadOnly() {
        return this.nioByteBuffer.isReadOnly();
    }

    @Override
    public long limit() {
        return this.nioByteBuffer.limit();
    }

    @Override
    public IoBuffer limit(int newLimit) {
        this.nioByteBuffer.limit(newLimit);
        return this;
    }

    @Override
    public ReadWriteLock lock() {
        return this.lock;
    }

    @Override
    public long position() {
        return this.nioByteBuffer.position();
    }

    @Override
    public IoBuffer position(long newPosition) {
        this.nioByteBuffer.position((int)newPosition);
        return this;
    }

    @Override
    public IoBuffer putBoolean(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
        return this;
    }

    @Override
    public IoBuffer putBooleanArray(boolean[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.putBoolean(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putByte(byte b) {
        this.nioByteBuffer.put(b);
        return this;
    }

    @Override
    public IoBuffer putByteArray(byte[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        this.nioByteBuffer.put(src, (int)offset, nElements);
        return this;
    }

    @Override
    public IoBuffer putChar(char value) {
        this.nioByteBuffer.putChar(value);
        return this;
    }

    @Override
    public IoBuffer putCharArray(char[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.nioByteBuffer.putChar(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putDouble(double value) {
        this.nioByteBuffer.putDouble(value);
        return this;
    }

    @Override
    public IoBuffer putDoubleArray(double[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.nioByteBuffer.putDouble(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putFloat(float value) {
        this.nioByteBuffer.putFloat(value);
        return this;
    }

    @Override
    public IoBuffer putFloatArray(float[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.nioByteBuffer.putFloat(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putInt(int value) {
        this.nioByteBuffer.putInt(value);
        return this;
    }

    @Override
    public IoBuffer putIntArray(int[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.nioByteBuffer.putInt(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putLong(long value) {
        this.nioByteBuffer.putLong(value);
        return this;
    }

    @Override
    public IoBuffer putLongArray(long[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.nioByteBuffer.putLong(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putShort(short value) {
        this.nioByteBuffer.putShort(value);
        return this;
    }

    @Override
    public IoBuffer putShortArray(short[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        int end = (int)offset + nElements;
        for (int i = (int)offset; i < end; ++i) {
            this.nioByteBuffer.putShort(src[i + (int)offset]);
        }
        return this;
    }

    @Override
    public IoBuffer putString(String string) {
        int strLength = string == null ? 0 : string.length();
        this.putInt(strLength + 1);
        for (int i = 0; i < strLength; ++i) {
            this.putByte((byte)string.charAt(i));
        }
        this.putByte((byte)0);
        return this;
    }

    @Override
    public IoBuffer putStringArray(String[] src, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, src.length) : src.length;
        this.putInt(nElements);
        for (int k = 0; k < nElements; ++k) {
            this.putString(src[k + (int)offset]);
        }
        return this;
    }

    @Override
    public long remaining() {
        return this.nioByteBuffer.remaining();
    }

    @Override
    public IoBuffer reset() {
        this.nioByteBuffer.reset();
        this.nioByteBuffer.mark();
        return this;
    }

    @Override
    public IoBuffer trim() {
        return this;
    }

    @Override
    public IoBuffer trim(int requestedCapacity) {
        return this;
    }
}

